/*
 * Decompiled with CFR 0.152.
 */
package name.richardson.james.bukkit.utilities.updater;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenManifest {
    private final List<String> versionList = new LinkedList<String>();

    public MavenManifest(File file) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(file);
        doc.getDocumentElement().normalize();
        NodeList root = doc.getChildNodes();
        Node meta = this.getNode("metadata", root);
        Node versioning = this.getNode("versioning", meta.getChildNodes());
        Node versions = this.getNode("versions", versioning.getChildNodes());
        NodeList nodes = versions.getChildNodes();
        this.setVersionList(nodes);
        file.deleteOnExit();
    }

    public String getCurrentVersion() {
        return this.versionList.get(0);
    }

    public List<String> getVersionList() {
        return Collections.unmodifiableList(this.versionList);
    }

    private Node getNode(String tagName, NodeList nodes) {
        for (int x = 0; x < nodes.getLength(); ++x) {
            Node node = nodes.item(x);
            if (!node.getNodeName().equalsIgnoreCase(tagName)) continue;
            return node;
        }
        return null;
    }

    private void setVersionList(NodeList nodes) {
        this.versionList.clear();
        for (int i = 0; i <= nodes.getLength() - 1; ++i) {
            Node node = nodes.item(i);
            if (!node.getNodeName().equalsIgnoreCase("version")) continue;
            this.versionList.add(0, node.getChildNodes().item(0).getNodeValue());
        }
    }
}

