/*
 * Decompiled with CFR 0.152.
 */
package name.richardson.james.bukkit.utilities.updater;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Random;
import javax.xml.parsers.ParserConfigurationException;
import name.richardson.james.bukkit.utilities.logging.Logger;
import name.richardson.james.bukkit.utilities.updater.MavenManifest;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.xml.sax.SAXException;

public class PluginUpdater
implements Runnable,
Listener {
    private final String artifactId;
    private final long delay = new Random().nextInt(20) * 20;
    private final String groupId;
    private final Logger logger;
    private MavenManifest manifest;
    private final name.richardson.james.bukkit.utilities.plugin.Plugin plugin;
    private final URL repositoryURL;
    private final State state;
    private final String version;

    public PluginUpdater(name.richardson.james.bukkit.utilities.plugin.Plugin plugin, State state, Branch branch) {
        this.state = state;
        this.logger = plugin.getCustomLogger();
        this.version = plugin.getDescription().getVersion();
        this.artifactId = plugin.getArtifactID();
        this.groupId = plugin.getGroupID();
        this.repositoryURL = plugin.getRepositoryURL();
        this.plugin = plugin;
        Bukkit.getScheduler().scheduleAsyncDelayedTask((Plugin)plugin, (Runnable)this, this.delay);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.getPermissionManager().hasPlayerPermission((Permissible)player, this.plugin.getPermissionManager().getRootPermission())) {
            String message = this.plugin.getLocalisation().getMessage(this, "new-version-available", this.plugin.getName(), this.manifest.getCurrentVersion());
            player.sendMessage(message);
        }
    }

    public void run() {
        try {
            this.parseMavenMetaData();
            if (this.isNewVersionAvailable()) {
                switch (this.state) {
                    case NOTIFY: {
                        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
                        this.logger.info(this, "new-version-available", this.plugin.getName(), this.manifest.getCurrentVersion());
                    }
                }
            }
        }
        catch (IOException e) {
            this.logger.warning(this, "unable-to-read-metadata", this.artifactId);
        }
        catch (SAXException e) {
            this.logger.warning(this, "unable-to-read-metadata", this.artifactId);
        }
        catch (ParserConfigurationException e) {
            this.logger.warning(this, "unable-to-read-metadata", this.artifactId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getMavenMetaData(File storage) throws IOException {
        StringBuilder path = new StringBuilder();
        path.append(this.repositoryURL);
        path.append("/");
        path.append(this.groupId.replace(".", "/"));
        path.append("/");
        path.append(this.artifactId);
        path.append("/maven-metadata.xml");
        URL url = new URL(path.toString());
        Channel rbc = null;
        FileOutputStream fos = null;
        try {
            this.logger.debug(this, "fetching-resource", url.toString());
            rbc = Channels.newChannel(url.openStream());
            this.logger.debug(this, "saving-resource", url.toString());
            fos = new FileOutputStream(storage);
            fos.getChannel().transferFrom((ReadableByteChannel)rbc, 0L, 0x1000000L);
        }
        finally {
            rbc.close();
            fos.close();
        }
    }

    private boolean isNewVersionAvailable() {
        DefaultArtifactVersion current = new DefaultArtifactVersion(this.version);
        this.logger.debug(this, "local-version", current.toString());
        DefaultArtifactVersion target = new DefaultArtifactVersion(this.manifest.getCurrentVersion());
        this.logger.debug(this, "remote-version", target.toString());
        return current.compareTo(target) == -1;
    }

    private void parseMavenMetaData() throws IOException, SAXException, ParserConfigurationException {
        File temp = File.createTempFile(this.artifactId, null);
        this.getMavenMetaData(temp);
        this.manifest = new MavenManifest(temp);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        NOTIFY,
        OFF;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Branch {
        DEVELOPMENT,
        STABLE;

    }
}

