/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelmap.gui;

import com.thevoxelbox.voxelmap.RadarSettingsManager;
import com.thevoxelbox.voxelmap.gui.GuiSlotMobs;
import com.thevoxelbox.voxelmap.gui.overridden.GuiScreenMinimap;
import com.thevoxelbox.voxelmap.util.CustomMob;
import com.thevoxelbox.voxelmap.util.CustomMobsManager;
import com.thevoxelbox.voxelmap.util.EnumMobs;
import com.thevoxelbox.voxelmap.util.I18nUtils;

public class GuiMobs
extends GuiScreenMinimap {
    private final bcd parentScreen;
    protected final RadarSettingsManager options;
    protected String screenTitle = "Select Mobs";
    private GuiSlotMobs mobsList;
    private ban buttonEnable;
    private ban buttonDisable;
    private String tooltip = null;
    protected String selectedMobName = null;

    public GuiMobs(bcd parentScreen, RadarSettingsManager options) {
        this.parentScreen = parentScreen;
        this.options = options;
    }

    public void r_() {
        boolean isSomethingSelected;
        boolean var2 = false;
        this.screenTitle = I18nUtils.getString("options.minimap.mobs.title");
        this.mobsList = new GuiSlotMobs(this);
        this.mobsList.d(7, 8);
        this.buttonEnable = new ban(-1, this.getWidth() / 2 - 154, this.getHeight() - 28, 100, 20, I18nUtils.getString("options.minimap.mobs.enable"));
        this.getButtonList().add(this.buttonEnable);
        this.buttonDisable = new ban(-2, this.getWidth() / 2 - 50, this.getHeight() - 28, 100, 20, I18nUtils.getString("options.minimap.mobs.disable"));
        this.getButtonList().add(this.buttonDisable);
        this.getButtonList().add(new ban(-200, this.getWidth() / 2 + 4 + 50, this.getHeight() - 28, 100, 20, I18nUtils.getString("gui.done")));
        this.buttonEnable.l = isSomethingSelected = this.selectedMobName != null;
        this.buttonDisable.l = isSomethingSelected;
    }

    protected void a(ban par1GuiButton) {
        if (par1GuiButton.l) {
            if (par1GuiButton.k == -1) {
                this.setMobEnabled(this.selectedMobName, true);
            }
            if (par1GuiButton.k == -2) {
                this.setMobEnabled(this.selectedMobName, false);
            }
            if (par1GuiButton.k == -200) {
                this.getMinecraft().a(this.parentScreen);
            }
        }
    }

    protected void setSelectedMob(String mob) {
        this.selectedMobName = mob;
    }

    private boolean isMobEnabled(String selectedMobName2) {
        EnumMobs mob = EnumMobs.getMobByName(this.selectedMobName);
        if (mob != null) {
            return mob.enabled;
        }
        CustomMob customMob = CustomMobsManager.getCustomMobByName(this.selectedMobName);
        if (customMob != null) {
            return customMob.enabled;
        }
        return false;
    }

    private void setMobEnabled(String selectedMobName, boolean enabled) {
        for (EnumMobs mob : EnumMobs.values()) {
            if (!mob.name.equals(selectedMobName)) continue;
            mob.enabled = enabled;
        }
        for (CustomMob mob : CustomMobsManager.mobs) {
            if (!mob.name.equals(selectedMobName)) continue;
            mob.enabled = enabled;
        }
    }

    protected void toggleMobVisibility() {
        EnumMobs mob = EnumMobs.getMobByName(this.selectedMobName);
        if (mob != null) {
            this.setMobEnabled(this.selectedMobName, !mob.enabled);
        } else {
            CustomMob customMob = CustomMobsManager.getCustomMobByName(this.selectedMobName);
            if (customMob != null) {
                this.setMobEnabled(this.selectedMobName, !customMob.enabled);
            }
        }
    }

    public void a(int par1, int par2, float par3) {
        super.drawMap();
        this.tooltip = null;
        this.mobsList.a(par1, par2, par3);
        this.a(this.getFontRenderer(), this.screenTitle, this.getWidth() / 2, 20, 0xFFFFFF);
        boolean isSomethingSelected = this.selectedMobName != null;
        this.buttonEnable.l = isSomethingSelected && !this.isMobEnabled(this.selectedMobName);
        this.buttonDisable.l = isSomethingSelected && this.isMobEnabled(this.selectedMobName);
        super.a(par1, par2, par3);
        if (this.tooltip != null) {
            this.drawTooltip(this.tooltip, par1, par2);
        }
    }

    protected void drawTooltip(String par1Str, int par2, int par3) {
        if (par1Str != null) {
            int var4 = par2 + 12;
            int var5 = par3 - 12;
            int var6 = this.getFontRenderer().a(par1Str);
            this.a(var4 - 3, var5 - 3, var4 + var6 + 3, var5 + 8 + 3, -1073741824, -1073741824);
            this.getFontRenderer().a(par1Str, var4, var5, -1);
        }
    }

    static String setTooltip(GuiMobs par0GuiWaypoints, String par1Str) {
        par0GuiWaypoints.tooltip = par1Str;
        return par0GuiWaypoints.tooltip;
    }
}

