/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.chunk.Chunk;

public class TFGenericPacketHandler {
    public static final byte CHANGE_DIM_ID = 1;
    public static final byte TRANSFORM_BIOME = 2;

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void incomingPacket(FMLNetworkEvent.ClientCustomPacketEvent event) {
        ByteBuf buf = event.packet.payload();
        byte discriminatorByte = buf.readByte();
        if (discriminatorByte == 2) {
            this.processTransformBiomeData(buf);
        }
    }

    private void processTransformBiomeData(ByteBuf buf) {
        int x = buf.readInt();
        int z = buf.readInt();
        byte biomeID = buf.readByte();
        WorldClient worldObj = Minecraft.func_71410_x().field_71441_e;
        Chunk chunkAt = worldObj.func_72938_d(x, z);
        chunkAt.func_76605_m()[(z & 0xF) << 4 | x & 0xF] = biomeID;
        worldObj.func_147458_c(x, 0, z, x, 255, z);
    }

    public static FMLProxyPacket makeBiomeChangePacket(int x, int z, byte biomeID) {
        PacketBuffer payload = new PacketBuffer(Unpooled.buffer());
        payload.writeByte(2);
        payload.writeInt(x);
        payload.writeInt(z);
        payload.writeByte((int)biomeID);
        FMLProxyPacket pkt = new FMLProxyPacket((ByteBuf)payload, "TwilightForest");
        return pkt;
    }
}

