/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.extrabuttons.block;

import com.jaquadro.minecraft.extrabuttons.ExtraButtons;
import com.jaquadro.minecraft.extrabuttons.tileentity.TileEntityButton;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ToggleButton
extends BlockContainer {
    private boolean isLit;
    private static boolean blockIsChanging;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArrayOn;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArrayOff;

    public ToggleButton(boolean isLit) {
        super(Material.field_151594_q);
        this.func_149675_a(true);
        this.func_149647_a(CreativeTabs.field_78028_d);
        this.isLit = isLit;
    }

    public AxisAlignedBB func_149668_a(World par1World, int par2, int par3, int par4) {
        return null;
    }

    public int func_149738_a(World world) {
        return 5;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149707_d(World world, int x, int y, int z, int side) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        return dir == ForgeDirection.NORTH && world.isSideSolid(x, y, z + 1, ForgeDirection.NORTH) || dir == ForgeDirection.SOUTH && world.isSideSolid(x, y, z - 1, ForgeDirection.SOUTH) || dir == ForgeDirection.WEST && world.isSideSolid(x + 1, y, z, ForgeDirection.WEST) || dir == ForgeDirection.EAST && world.isSideSolid(x - 1, y, z, ForgeDirection.EAST);
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return world.isSideSolid(x - 1, y, z, ForgeDirection.EAST) || world.isSideSolid(x + 1, y, z, ForgeDirection.WEST) || world.isSideSolid(x, y, z - 1, ForgeDirection.SOUTH) || world.isSideSolid(x, y, z + 1, ForgeDirection.NORTH);
    }

    public boolean hasTileEntity(int data) {
        return true;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TileEntityButton te = (TileEntityButton)world.func_147438_o(x, y, z);
        int dir = te != null ? te.getDirection() : 0;
        boolean invalid = false;
        if (!world.isSideSolid(x - 1, y, z, ForgeDirection.EAST) && dir == 1) {
            invalid = true;
        }
        if (!world.isSideSolid(x + 1, y, z, ForgeDirection.WEST) && dir == 2) {
            invalid = true;
        }
        if (!world.isSideSolid(x, y, z - 1, ForgeDirection.SOUTH) && dir == 3) {
            invalid = true;
        }
        if (!world.isSideSolid(x, y, z + 1, ForgeDirection.NORTH) && dir == 4) {
            invalid = true;
        }
        if (invalid) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
        }
    }

    public void func_149719_a(IBlockAccess blockAccess, int x, int y, int z) {
        TileEntityButton te = (TileEntityButton)blockAccess.func_147438_o(x, y, z);
        if (te != null) {
            this.setBlockBoundsByTileEntity(te);
        }
    }

    private void setBlockBoundsByTileEntity(TileEntityButton te) {
        int dir = te.getDirection();
        boolean isLatched = te.isDepressed();
        float var4 = 0.375f;
        float var5 = 0.625f;
        float var6 = 0.1875f;
        float depth = 0.125f;
        if (isLatched) {
            depth = 0.0625f;
        }
        if (dir == 1) {
            this.func_149676_a(0.0f, var4, 0.5f - var6, depth, var5, 0.5f + var6);
        } else if (dir == 2) {
            this.func_149676_a(1.0f - depth, var4, 0.5f - var6, 1.0f, var5, 0.5f + var6);
        } else if (dir == 3) {
            this.func_149676_a(0.5f - var6, var4, 0.0f, 0.5f + var6, var5, depth);
        } else if (dir == 4) {
            this.func_149676_a(0.5f - var6, var4, 1.0f - depth, 0.5f + var6, var5, 1.0f);
        }
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        if (this.isLit) {
            world.func_147460_e(x, y - 1, z, (Block)this);
            world.func_147460_e(x, y + 1, z, (Block)this);
            world.func_147460_e(x - 1, y, z, (Block)this);
            world.func_147460_e(x + 1, y, z, (Block)this);
            world.func_147460_e(x, y, z - 1, (Block)this);
            world.func_147460_e(x, y, z + 1, (Block)this);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        TileEntityButton te = (TileEntityButton)world.func_147438_o(x, y, z);
        if (te == null) {
            return false;
        }
        if (te.isDepressed()) {
            return true;
        }
        int dir = te.getDirection();
        te.setIsDepressed(true);
        te.setIsLatched(!te.isLatched());
        ToggleButton.updateBlockState(te.isLatched(), world, x, y, z);
        world.func_147458_c(x, y, z, x, y, z);
        world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.click", 0.3f, 0.6f);
        this.updateNeighbors(world, x, y, z, dir);
        world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
        return true;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int data) {
        if (!blockIsChanging) {
            TileEntityButton te = (TileEntityButton)world.func_147438_o(x, y, z);
            if (te != null && te.isLatched()) {
                this.updateNeighbors(world, x, y, z, te.getDirection());
            }
            if (this.isLit) {
                world.func_147460_e(x, y - 1, z, (Block)this);
                world.func_147460_e(x, y + 1, z, (Block)this);
                world.func_147460_e(x - 1, y, z, (Block)this);
                world.func_147460_e(x + 1, y, z, (Block)this);
                world.func_147460_e(x, y, z - 1, (Block)this);
                world.func_147460_e(x, y, z + 1, (Block)this);
            }
        }
        super.func_149749_a(world, x, y, z, block, data);
    }

    private static void updateBlockState(boolean isLit, World world, int x, int y, int z) {
        int data = world.func_72805_g(x, y, z);
        TileEntity te = world.func_147438_o(x, y, z);
        blockIsChanging = true;
        if (isLit) {
            world.func_147449_b(x, y, z, ExtraButtons.illuminatedButtonOn);
        } else {
            world.func_147449_b(x, y, z, ExtraButtons.illuminatedButtonOff);
        }
        blockIsChanging = false;
        world.func_72921_c(x, y, z, data, 2);
        if (te != null) {
            te.func_145829_t();
            world.func_147455_a(x, y, z, te);
        }
    }

    public int func_149709_b(IBlockAccess blockAccess, int x, int y, int z, int side) {
        TileEntityButton te = (TileEntityButton)blockAccess.func_147438_o(x, y, z);
        return te != null && te.isLatched() ? 15 : 0;
    }

    public int func_149748_c(IBlockAccess blockAccess, int x, int y, int z, int side) {
        TileEntityButton te = (TileEntityButton)blockAccess.func_147438_o(x, y, z);
        if (te == null || !te.isLatched()) {
            return 0;
        }
        int dir = te.getDirection();
        return dir == 5 && side == 1 ? 15 : (dir == 4 && side == 2 ? 15 : (dir == 3 && side == 3 ? 15 : (dir == 2 && side == 4 ? 15 : (dir == 1 && side == 5 ? 15 : 0))));
    }

    public boolean func_149744_f() {
        return true;
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        TileEntityButton te = (TileEntityButton)world.func_147438_o(x, y, z);
        if (te != null && te.isDepressed() && !world.field_72995_K) {
            te.setIsDepressed(false);
            world.func_147471_g(x, y, z);
            world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.click", 0.3f, 0.5f);
        }
    }

    public void func_149683_g() {
        float hx = 0.1875f;
        float hy = 0.125f;
        float hz = 0.125f;
        this.func_149676_a(0.5f - hx, 0.5f - hy, 0.5f - hz, 0.5f + hx, 0.5f + hy, 0.5f + hz);
    }

    private void updateNeighbors(World world, int x, int y, int z, int dir) {
        world.func_147459_d(x, y, z, (Block)this);
        if (dir == 1) {
            world.func_147459_d(x - 1, y, z, (Block)this);
        } else if (dir == 2) {
            world.func_147459_d(x + 1, y, z, (Block)this);
        } else if (dir == 3) {
            world.func_147459_d(x, y, z - 1, (Block)this);
        } else if (dir == 4) {
            world.func_147459_d(x, y, z + 1, (Block)this);
        } else {
            world.func_147459_d(x, y - 1, z, (Block)this);
        }
    }

    public TileEntity func_149915_a(World world, int data) {
        return new TileEntityButton();
    }

    public boolean func_149667_c(Block block) {
        return block == ExtraButtons.illuminatedButtonOn || block == ExtraButtons.illuminatedButtonOff;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileEntityButton te;
        int data = world.func_72805_g(x, y, z);
        TileEntity baseTE = world.func_147438_o(x, y, z);
        if (baseTE != null && baseTE.getClass().isAssignableFrom(TileEntityButton.class) && (te = (TileEntityButton)baseTE).isLatched()) {
            return this.iconArrayOn[data];
        }
        return this.iconArrayOff[data];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int data) {
        return this.iconArrayOff[data];
    }

    public Item func_149650_a(int metadata, Random rand, int fortune) {
        return Item.func_150898_a((Block)ExtraButtons.illuminatedButtonOff);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        int count = this.quantityDropped(metadata, fortune, world.field_73012_v);
        for (int i = 0; i < count; ++i) {
            Item item = this.func_149650_a(metadata, world.field_73012_v, fortune);
            if (item == null) continue;
            ret.add(new ItemStack(item, 1, metadata));
        }
        return ret;
    }

    public int func_149692_a(int data) {
        return data;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs creativeTabs, List blockList) {
        if (!this.isLit) {
            for (int i = 0; i < 16; ++i) {
                blockList.add(new ItemStack(item, 1, i));
            }
        }
    }

    public static int getBlockFromDye(int data) {
        return ~data & 0xF;
    }

    public static int getDyeFromBlock(int data) {
        return ~data & 0xF;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.iconArrayOff = new IIcon[16];
        this.iconArrayOn = new IIcon[16];
        for (int i = 0; i < 16; ++i) {
            this.iconArrayOff[i] = iconRegister.func_94245_a("extrabuttons:illum_button_off_" + i);
            this.iconArrayOn[i] = iconRegister.func_94245_a("extrabuttons:illum_button_on_" + i);
        }
    }
}

