/*
 * Decompiled with CFR 0.152.
 */
package mickkay.scenter.config;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.List;
import mickkay.scenter.config.CommentEntry;
import mickkay.scenter.config.EmptyLineEntry;
import mickkay.scenter.config.Entry;
import mickkay.scenter.config.TargetEntry;

public class TargetsConfig {
    private List<Entry> entries = new ArrayList<Entry>();

    public List<Entry> getEntries() {
        return this.entries;
    }

    public void load(Reader reader) throws IOException {
        BufferedReader bufReader = new BufferedReader(reader);
        int lineNo = 0;
        try {
            String line;
            while ((line = bufReader.readLine()) != null) {
                ++lineNo;
                if (line.trim().length() == 0) {
                    this.entries.add(new EmptyLineEntry(line));
                    continue;
                }
                if (CommentEntry.PATTERN.matcher(line).matches()) {
                    this.entries.add(new CommentEntry(line));
                    continue;
                }
                this.entries.add(new TargetEntry(line));
            }
        }
        catch (IllegalArgumentException e) {
            throw new IOException(String.format("Can't read line %s: %s", lineNo, e.getMessage()), e);
        }
        finally {
            bufReader.close();
        }
    }

    public void save(Writer writer) throws IOException {
        int lineNo = 0;
        for (Entry e : this.entries) {
            if (lineNo > 0) {
                writer.append(String.format("%n", new Object[0]));
            }
            ++lineNo;
            writer.append(e.getLine());
        }
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        try {
            this.save(writer);
            writer.close();
        }
        catch (IOException e) {
            throw new UndeclaredThrowableException(e);
        }
        return writer.toString();
    }

    public TargetEntry addTarget(String blockName, String color) {
        TargetEntry newEntry = new TargetEntry();
        newEntry.setName(blockName);
        newEntry.setColor(color);
        this.getEntries().add(newEntry);
        return newEntry;
    }

    public TargetEntry addTarget(String blockName, String color, String comment) {
        TargetEntry newEntry = new TargetEntry();
        newEntry.setName(blockName);
        newEntry.setColor(color);
        newEntry.setComment(comment);
        this.getEntries().add(newEntry);
        return newEntry;
    }

    public TargetEntry addTarget(String blockName, Integer subtype, String color, String comment) {
        TargetEntry newEntry = new TargetEntry();
        newEntry.setName(blockName);
        newEntry.setSubtype(subtype);
        newEntry.setColor(color);
        newEntry.setComment(comment);
        this.getEntries().add(newEntry);
        return newEntry;
    }

    public TargetEntry addTargetAfter(TargetEntry refEntry, String blockName, String color, String comment) {
        TargetEntry newEntry = new TargetEntry();
        newEntry.setName(blockName);
        newEntry.setColor(color);
        newEntry.setComment(comment);
        int index = this.entries.indexOf(refEntry);
        this.getEntries().add(index + 1, newEntry);
        return newEntry;
    }

    public CommentEntry addComment(String comment) {
        CommentEntry newEntry = new CommentEntry();
        newEntry.setComment(comment);
        this.getEntries().add(newEntry);
        return newEntry;
    }

    public boolean isEmpty() {
        return this.getEntries().isEmpty();
    }

    public boolean hasTargetEntry(String blockName) {
        return this.getTargetEntry(blockName) != null;
    }

    public TargetEntry getTargetEntry(String blockName) {
        for (Entry entry : this.entries) {
            TargetEntry targetEntry;
            if (!(entry instanceof TargetEntry) || !(targetEntry = (TargetEntry)entry).getName().equals(blockName)) continue;
            return targetEntry;
        }
        return null;
    }
}

