/*
 * Decompiled with CFR 0.152.
 */
package naruto1310.craftableAnimals.core;

import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import naruto1310.craftableAnimals.core.AbstractCraftableAnimalsExtension;
import naruto1310.craftableAnimals.core.ICraftableAnimal;
import naruto1310.craftableAnimals.core.ItemCraftableAnimal;
import naruto1310.craftableAnimals.core.ItemCraftableAnimalBase;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.EnumHelper;

public class CraftableAnimalsRegistry {
    protected static final int armorRenderIndex;
    private static final List<AbstractCraftableAnimalsExtension> extensions;
    private static final Map<String, ItemCraftableAnimal> stringToItemMap;
    private static final List<String> babyAnimals;
    public static final List<Block> itemInteractList;

    public static void registerExtension(AbstractCraftableAnimalsExtension extension) {
        if (extension == null) {
            throw new IllegalArgumentException("Cannot register craftableAnimals extension null.");
        }
        if (extensions.contains(extension)) {
            throw new IllegalArgumentException("The craftableAnimals extension " + extension.getClass().getSimpleName() + " could not be registered. It already exists.");
        }
        extensions.add(extension);
        System.out.println("The craftableAnimals extension " + extension.getClass().getSimpleName() + " was registered successfully.");
    }

    public static List<AbstractCraftableAnimalsExtension> getExtensions() {
        return Collections.unmodifiableList(extensions);
    }

    public static void addStringToItemMapping(String animal, ItemCraftableAnimal item) {
        stringToItemMap.put(animal, item);
    }

    protected static void addBaby(String animal) {
        babyAnimals.add(animal);
    }

    public static boolean hasBaby(String animal) {
        return babyAnimals.contains(animal);
    }

    public static ItemCraftableAnimal getItemFromString(String animal) {
        return stringToItemMap.get(animal);
    }

    public static String getAnimal(ItemStack stack) {
        return ((ICraftableAnimal)stack.func_77973_b()).getAnimal(stack);
    }

    public static int getType(ItemStack stack) {
        return ((ICraftableAnimal)stack.func_77973_b()).getType(stack);
    }

    public static EntityLiving[] createEntity(ItemStack stack, World world) {
        return ((ICraftableAnimal)stack.func_77973_b()).createEntity(stack, world);
    }

    public static ItemStack createItemCraftableAnimalStack(ItemStack stack) {
        return new ItemStack((Item)CraftableAnimalsRegistry.getItemFromString(((ItemCraftableAnimalBase)stack.func_77973_b()).getAnimal(stack)), stack.field_77994_a, ((ItemCraftableAnimalBase)stack.func_77973_b()).getType(stack));
    }

    static {
        extensions = new ArrayList<AbstractCraftableAnimalsExtension>();
        stringToItemMap = new HashMap<String, ItemCraftableAnimal>();
        babyAnimals = new ArrayList<String>();
        itemInteractList = new ArrayList<Block>();
        EnumHelper.addArmorMaterial((String)"craftableAnimal", (int)100, (int[])new int[]{0, 0, 0, 0}, (int)0);
        armorRenderIndex = FMLCommonHandler.instance().getEffectiveSide().isClient() ? RenderingRegistry.addNewArmourRendererPrefix((String)"craftableAnimal") : -1;
    }
}

