/*
 * Decompiled with CFR 0.152.
 */
package naruto1310.craftableAnimals.core;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import naruto1310.craftableAnimals.core.CraftableAnimalsRegistry;
import naruto1310.craftableAnimals.core.ItemCraftableAnimalBase;
import naruto1310.craftableAnimals.core.SpawnEntity;
import naruto1310.craftableAnimals.vanilla.CAConfig;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Facing;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public abstract class ItemCraftableAnimal
extends ItemCraftableAnimalBase {
    protected String animal;
    protected int types;
    protected int spawnAtLeastAtDifficulty;
    protected IIcon[] icons;
    protected byte armor;

    public ItemCraftableAnimal(String animal, int types, int difficulty) {
        this.func_77627_a(true);
        this.animal = animal;
        this.types = types;
        this.spawnAtLeastAtDifficulty = difficulty;
        CraftableAnimalsRegistry.addStringToItemMapping(animal, this);
        this.func_77637_a(CreativeTabs.field_78026_f);
        this.icons = new IIcon[Math.max(types, 1)];
        this.func_77655_b(animal);
        this.armor = 0;
        GameRegistry.registerItem((Item)this, (String)(this.getOwnerMod() + ":" + animal), (String)this.getOwnerMod());
        this.func_77655_b(this.getOwnerMod() + ":" + animal);
        this.func_111206_d(animal);
    }

    public ItemCraftableAnimal setHasBaby() {
        CraftableAnimalsRegistry.addBaby(this.animal);
        return this;
    }

    public ItemCraftableAnimal setSupportedArmor(int armor) {
        this.armor = (byte)armor;
        return this;
    }

    @Override
    public EntityLiving[] spawn(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side) {
        if (world.field_72995_K) {
            return null;
        }
        if (CraftableAnimalsRegistry.itemInteractList.contains(world.func_147439_a(x, y, z))) {
            return null;
        }
        if (this.spawnAtLeastAtDifficulty > world.field_73013_u.ordinal()) {
            if (CAConfig.showError && player instanceof EntityClientPlayerMP) {
                ((EntityClientPlayerMP)player).func_71165_d("To place this mob turn your difficulty up to " + (this.spawnAtLeastAtDifficulty == 1 ? "Easy" : (this.spawnAtLeastAtDifficulty == 2 ? "Normal" : "Hard")) + (this.spawnAtLeastAtDifficulty != 3 ? " or higher" : "") + ".");
            }
            return null;
        }
        EntityLiving entity = SpawnEntity.spawn(this.animal, world, (double)(x + Facing.field_71586_b[side]) + 0.5, y + Facing.field_71587_c[side], (double)(z + Facing.field_71585_d[side]) + 0.5, player, stack.func_77960_j());
        if (stack.func_82837_s() && entity != null) {
            entity.func_94058_c(stack.func_82833_r());
        }
        if (!player.field_71075_bZ.field_75098_d) {
            --stack.field_77994_a;
        }
        return new EntityLiving[]{entity};
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77667_c(ItemStack stack) {
        int d = stack.func_77960_j();
        return "item.craftableAnimal." + this.animal + (this.types != 0 ? "." + Math.min(d, this.types - 1) : "");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int d) {
        if (this.animal.contentEquals("Enderman")) {
            return this.field_77791_bV;
        }
        return this.icons[d];
    }

    public IIcon getIcon(ItemStack stack, int renderPass) {
        if (this.func_77623_v()) {
            return this.func_77618_c(stack.func_77960_j(), renderPass);
        }
        return this.func_77617_a(stack.func_77960_j());
    }

    public final String getAnimal() {
        return this.animal;
    }

    public void func_94581_a(IIconRegister register) {
        for (int i = 0; i < Math.max(this.types, 1); ++i) {
            this.icons[i] = register.func_94245_a(this.getOwnerMod() + ":" + this.animal.toLowerCase() + (this.types == 0 ? "" : Integer.valueOf(i)));
        }
        this.field_77791_bV = this.icons[0];
    }

    @Override
    public EntityLiving[] createEntity(ItemStack stack, World world) {
        return new EntityLiving[]{SpawnEntity.getEntityForRender(this.getAnimal(stack), world, this.getType(stack))};
    }

    @Override
    public String getAnimal(ItemStack stack) {
        return ((ItemCraftableAnimal)stack.func_77973_b()).getAnimal();
    }

    @Override
    public int getType(ItemStack stack) {
        return stack.func_77960_j();
    }

    public byte getSupportedArmor() {
        return this.armor;
    }

    public abstract String getOwnerMod();
}

