/*
 * Decompiled with CFR 0.152.
 */
package naruto1310.craftableAnimals.core;

import java.util.Random;
import naruto1310.craftableAnimals.core.CraftableAnimalsRegistry;
import naruto1310.craftableAnimals.core.ItemCraftableAnimalBase;
import naruto1310.craftableAnimals.core.SpawnEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ReportedException;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderCraftableAnimalModifier
implements IItemRenderer {
    RenderItem renderItem = new RenderItem();
    public int id1;
    public int id2;

    public RenderCraftableAnimalModifier(int id1, int id2) {
        this.id1 = id1;
        this.id2 = id2;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type == IItemRenderer.ItemRenderType.ENTITY && (helper == IItemRenderer.ItemRendererHelper.ENTITY_BOBBING || helper == IItemRenderer.ItemRendererHelper.ENTITY_ROTATION && RenderManager.field_78727_a.field_78733_k.field_74347_j);
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack stack, Object ... data) {
        EntityLiving[] entitys;
        ItemStack animal;
        IIcon icon = stack.func_77973_b().func_77650_f(stack);
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            switch (this.id1) {
                case 0: {
                    animal = CraftableAnimalsRegistry.createItemCraftableAnimalStack(stack);
                    this.renderItem0Inventory(type, stack, icon, animal, data);
                    break;
                }
                case 1: {
                    entitys = null;
                    if (stack.func_77942_o()) {
                        entitys = ((ItemCraftableAnimalBase)stack.func_77973_b()).createEntity(stack, (World)Minecraft.func_71410_x().field_71441_e);
                    }
                    this.renderItem1Inventory(type, stack, icon, entitys, data);
                }
            }
        }
        if (type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            switch (this.id2) {
                case 0: {
                    animal = CraftableAnimalsRegistry.createItemCraftableAnimalStack(stack);
                    this.renderItem0Equipped(type, stack, icon, animal, data);
                    break;
                }
                case 1: {
                    entitys = null;
                    if (stack.func_77942_o()) {
                        entitys = ((ItemCraftableAnimalBase)stack.func_77973_b()).createEntity(stack, (World)Minecraft.func_71410_x().field_71441_e);
                    }
                    this.renderItem1Equipped(type, stack, icon, entitys, data);
                }
            }
        }
        if (type == IItemRenderer.ItemRenderType.ENTITY) {
            switch (this.id2) {
                case 0: {
                    animal = CraftableAnimalsRegistry.createItemCraftableAnimalStack(stack);
                    this.renderItem0Entity(type, stack, icon, animal, data);
                    break;
                }
                case 1: {
                    entitys = null;
                    if (stack.func_77942_o()) {
                        entitys = ((ItemCraftableAnimalBase)stack.func_77973_b()).createEntity(stack, (World)Minecraft.func_71410_x().field_71441_e);
                    }
                    this.renderItem1Entity(type, stack, icon, entitys, data);
                }
            }
        }
    }

    public void renderItem0Equipped(IItemRenderer.ItemRenderType type, ItemStack stack, IIcon icon, ItemStack animal, Object ... data) {
        if (animal.func_77973_b().func_77623_v()) {
            for (int i = 0; i < animal.func_77973_b().getRenderPasses(animal.func_77960_j()); ++i) {
                this.renderEquippedItem(animal.func_77973_b().getIcon(animal, i));
            }
        } else {
            this.renderEquippedItem(animal.func_77973_b().func_77650_f(animal));
        }
        this.renderEquippedItem(icon);
    }

    public void renderItem0Inventory(IItemRenderer.ItemRenderType type, ItemStack stack, IIcon icon, ItemStack animal, Object ... data) {
        if (animal.func_77973_b().func_77623_v()) {
            for (int i = 0; i < animal.func_77973_b().getRenderPasses(animal.func_77960_j()); ++i) {
                this.renderInventoryItem(animal.func_77973_b().getIcon(animal, i));
            }
        } else {
            this.renderInventoryItem(animal.func_77973_b().func_77650_f(animal));
        }
        this.renderInventoryItem(icon);
    }

    public void renderItem0Entity(IItemRenderer.ItemRenderType type, ItemStack stack, IIcon icon, ItemStack animal, Object ... data) {
        EntityItem entity = (EntityItem)data[1];
        int j = animal.field_77994_a;
        byte b0 = j < 2 ? (byte)1 : (j < 16 ? (byte)2 : (j < 32 ? (byte)3 : 4));
        if (animal.func_77973_b().func_77623_v()) {
            for (int i = 0; i < animal.func_77973_b().getRenderPasses(animal.func_77960_j()); ++i) {
                this.renderEntityItem(animal.func_77973_b().getIcon(animal, i), entity, this.renderItem.getMiniItemCount(animal, b0));
            }
        } else {
            this.renderEntityItem(animal.func_77973_b().func_77650_f(animal), entity, this.renderItem.getMiniItemCount(animal, b0));
        }
        this.renderEntityItem(icon, entity, this.renderItem.getMiniItemCount(animal, b0));
    }

    public void renderItem1Equipped(IItemRenderer.ItemRenderType type, ItemStack stack, IIcon icon, EntityLiving[] entitys, Object ... data) {
        if (entitys != null) {
            for (EntityLiving entity : entitys) {
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                float f = 0.4f;
                if (entity.field_70131_O > 4.0f) {
                    f /= 3.0f;
                }
                if (entity.field_70131_O < 0.5f) {
                    f *= 1.2f;
                }
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glScalef((float)f, (float)f, (float)f);
                GL11.glTranslatef((float)(-0.5f / f), (float)0.5f, (float)0.0f);
                RenderCraftableAnimalModifier.renderEntityWithoutShadow((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, RenderManager.field_78727_a.field_78733_k.field_74320_O == 2 ? 0.0f : 180.0f);
                GL11.glTranslatef((float)(0.5f / f), (float)-0.5f, (float)0.0f);
                GL11.glScalef((float)(1.0f / f), (float)(1.0f / f), (float)(1.0f / f));
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)(entity.field_70131_O * (entity instanceof EntitySpider ? 0.0f : 0.3f)), (float)0.0f);
            }
        } else {
            this.renderEquippedItem(icon);
        }
    }

    public void renderItem1Inventory(IItemRenderer.ItemRenderType type, ItemStack stack, IIcon icon, EntityLiving[] entitys, Object ... data) {
        if (entitys != null) {
            for (EntityLiving entity : entitys) {
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glColor3f((float)0.25f, (float)0.25f, (float)0.25f);
                this.renderInventoryItem(icon);
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                GL11.glTranslatef((float)8.0f, (float)8.0f, (float)0.0f);
                if (!SpawnEntity.isSpawnable(EntityList.func_75621_b((Entity)entity))) continue;
                try {
                    ItemStack animal = new ItemStack((Item)CraftableAnimalsRegistry.getItemFromString(EntityList.func_75621_b((Entity)entity)), 1, SpawnEntity.getTypeFromEntity(entity));
                    if (animal.func_77973_b().func_77623_v()) {
                        for (int i = 0; i < animal.func_77973_b().getRenderPasses(animal.func_77960_j()); ++i) {
                            this.renderInventoryItem(animal.func_77973_b().getIcon(animal, i));
                        }
                        continue;
                    }
                    this.renderInventoryItem(animal.func_77973_b().func_77650_f(animal));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        } else {
            this.renderInventoryItem(icon);
        }
    }

    public void renderItem1Entity(IItemRenderer.ItemRenderType type, ItemStack stack, IIcon icon, EntityLiving[] entitys, Object ... data) {
        if (entitys != null) {
            for (EntityLiving entity : entitys) {
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                EntityItem item = (EntityItem)data[1];
                float f = 0.5f;
                if (entity.field_70131_O > 4.0f) {
                    f /= 3.0f;
                }
                if (entity.field_70131_O < 0.5f) {
                    f *= 1.2f;
                }
                GL11.glScalef((float)f, (float)f, (float)f);
                RenderCraftableAnimalModifier.renderEntityWithoutShadow((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, -RenderManager.field_78727_a.field_78735_i - ((float)item.field_70292_b / 20.0f + item.field_70290_d) * 57.295776f);
                GL11.glScalef((float)(1.0f / f), (float)(1.0f / f), (float)(1.0f / f));
                GL11.glTranslatef((float)0.0f, (float)(entity.field_70131_O * (entity instanceof EntitySpider ? 0.0f : 0.3f)), (float)0.0f);
            }
        } else {
            this.renderEntityItemAsEntity(icon, (EntityItem)data[1], (byte)1);
        }
    }

    private void renderEquippedItem(IIcon icon) {
        ItemRenderer.func_78439_a((Tessellator)Tessellator.field_78398_a, (float)icon.func_94212_f(), (float)icon.func_94206_g(), (float)icon.func_94209_e(), (float)icon.func_94210_h(), (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)0.0625f);
    }

    private void renderInventoryItem(IIcon icon) {
        this.renderItem.func_94149_a(0, 0, icon, 16, 16);
    }

    private void renderEntityItem(IIcon icon, EntityItem entity, byte itemCount) {
        Tessellator tessellator = Tessellator.field_78398_a;
        Random random = new Random(187L);
        float f4 = icon.func_94209_e();
        float f5 = icon.func_94212_f();
        float f6 = icon.func_94206_g();
        float f7 = icon.func_94210_h();
        float f9 = 0.5f;
        float f10 = 0.25f;
        if (RenderManager.field_78727_a.field_78733_k.field_74347_j) {
            GL11.glPushMatrix();
            if (RenderItem.field_82407_g) {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            } else {
                GL11.glRotatef((float)((((float)entity.field_70292_b + 0.0f) / 20.0f + entity.field_70290_d) * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
            }
            float f12 = 0.0625f;
            float f11 = 0.021875f;
            GL11.glTranslatef((float)(-f9), (float)(-f10), (float)(-((f12 + f11) * (float)itemCount / 2.0f)));
            for (int k = 0; k < itemCount; ++k) {
                if (k > 0 && this.renderItem.shouldSpreadItems()) {
                    float x = (random.nextFloat() * 2.0f - 1.0f) * 0.3f / 0.5f;
                    float y = (random.nextFloat() * 2.0f - 1.0f) * 0.3f / 0.5f;
                    GL11.glTranslatef((float)x, (float)y, (float)(f12 + f11));
                } else {
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(f12 + f11));
                }
                ItemRenderer.func_78439_a((Tessellator)tessellator, (float)f5, (float)f6, (float)f4, (float)f7, (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)f12);
            }
            GL11.glPopMatrix();
        } else {
            for (int l = 0; l < itemCount; ++l) {
                GL11.glPushMatrix();
                if (l > 0) {
                    GL11.glTranslatef((float)((random.nextFloat() * 2.0f - 1.0f) * 0.3f), (float)((random.nextFloat() * 2.0f - 1.0f) * 0.3f), (float)((random.nextFloat() * 2.0f - 1.0f) * 0.3f));
                }
                if (!RenderItem.field_82407_g) {
                    GL11.glRotatef((float)(180.0f - RenderManager.field_78727_a.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
                }
                tessellator.func_78382_b();
                tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
                tessellator.func_78374_a((double)(0.0f - f9), (double)(0.0f - f10), 0.0, (double)f4, (double)f7);
                tessellator.func_78374_a((double)(1.0f - f9), (double)(0.0f - f10), 0.0, (double)f5, (double)f7);
                tessellator.func_78374_a((double)(1.0f - f9), (double)(1.0f - f10), 0.0, (double)f5, (double)f6);
                tessellator.func_78374_a((double)(0.0f - f9), (double)(1.0f - f10), 0.0, (double)f4, (double)f6);
                tessellator.func_78381_a();
                GL11.glPopMatrix();
            }
        }
    }

    private void renderEntityItemAsEntity(IIcon icon, EntityItem entity, byte itemCount) {
        Tessellator tessellator = Tessellator.field_78398_a;
        Random random = new Random(187L);
        float f4 = icon.func_94209_e();
        float f5 = icon.func_94212_f();
        float f6 = icon.func_94206_g();
        float f7 = icon.func_94210_h();
        float f9 = 0.5f;
        float f10 = 0.25f;
        if (RenderManager.field_78727_a.field_78733_k.field_74347_j) {
            GL11.glPushMatrix();
            if (RenderItem.field_82407_g) {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            } else {
                GL11.glRotatef((float)((((float)entity.field_70292_b + 0.0f) / 20.0f + entity.field_70290_d) * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
            }
            float f12 = 0.0625f;
            float f11 = 0.021875f;
            GL11.glTranslatef((float)(-f9), (float)(-f10), (float)(-((f12 + f11) * (float)itemCount / 2.0f)));
            for (int k = 0; k < itemCount; ++k) {
                if (k > 0 && this.renderItem.shouldSpreadItems()) {
                    float x = (random.nextFloat() * 2.0f - 1.0f) * 0.3f / 0.5f;
                    float y = (random.nextFloat() * 2.0f - 1.0f) * 0.3f / 0.5f;
                    GL11.glTranslatef((float)x, (float)y, (float)(f12 + f11));
                } else {
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(f12 + f11));
                }
                ItemRenderer.func_78439_a((Tessellator)tessellator, (float)f5, (float)f6, (float)f4, (float)f7, (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)f12);
            }
            GL11.glPopMatrix();
        } else {
            for (int l = 0; l < itemCount; ++l) {
                GL11.glPushMatrix();
                if (l > 0) {
                    GL11.glTranslatef((float)((random.nextFloat() * 2.0f - 1.0f) * 0.3f), (float)((random.nextFloat() * 2.0f - 1.0f) * 0.3f), (float)((random.nextFloat() * 2.0f - 1.0f) * 0.3f));
                }
                if (!RenderItem.field_82407_g) {
                    GL11.glRotatef((float)(180.0f - RenderManager.field_78727_a.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
                }
                tessellator.func_78382_b();
                tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
                tessellator.func_78374_a((double)(0.0f - f9), (double)(0.0f - f10), 0.0, (double)f4, (double)f7);
                tessellator.func_78374_a((double)(1.0f - f9), (double)(0.0f - f10), 0.0, (double)f5, (double)f7);
                tessellator.func_78374_a((double)(1.0f - f9), (double)(1.0f - f10), 0.0, (double)f5, (double)f6);
                tessellator.func_78374_a((double)(0.0f - f9), (double)(1.0f - f10), 0.0, (double)f4, (double)f6);
                tessellator.func_78381_a();
                GL11.glPopMatrix();
            }
        }
    }

    public static void renderEntityWithoutShadow(Entity entity, double x, double y, double z, float rotation, float delta, float fireRotation) {
        block9: {
            Render render = null;
            try {
                render = RenderManager.field_78727_a.func_78713_a(entity);
                if (render == null || RenderManager.field_78727_a.field_78724_e == null) break block9;
                try {
                    render.func_76986_a(entity, x, y, z, rotation, delta);
                }
                catch (Throwable t) {
                    throw new ReportedException(CrashReport.func_85055_a((Throwable)t, (String)"Rendering entity in world"));
                }
                try {
                    if (entity.func_90999_ad()) {
                        GL11.glDisable((int)2896);
                        IIcon icon = Blocks.field_150480_ab.func_149840_c(0);
                        IIcon icon1 = Blocks.field_150480_ab.func_149840_c(1);
                        GL11.glPushMatrix();
                        float f1 = entity.field_70130_N * 1.4f;
                        GL11.glScalef((float)f1, (float)f1, (float)f1);
                        Tessellator tessellator = Tessellator.field_78398_a;
                        float f2 = 0.5f;
                        float f3 = 0.0f;
                        float f4 = entity.field_70131_O / f1;
                        float f5 = (float)(entity.field_70163_u - entity.field_70121_D.field_72338_b);
                        GL11.glRotatef((float)fireRotation, (float)0.0f, (float)1.0f, (float)0.0f);
                        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(-0.3f + f4 * 0.02f));
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        float f6 = 0.0f;
                        int i = 0;
                        tessellator.func_78382_b();
                        while (f4 > 0.0f) {
                            IIcon icon2 = i % 2 == 0 ? icon : icon1;
                            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
                            float f7 = icon2.func_94209_e();
                            float f8 = icon2.func_94206_g();
                            float f9 = icon2.func_94212_f();
                            float f10 = icon2.func_94210_h();
                            if (i / 2 % 2 == 0) {
                                float f11 = f9;
                                f9 = f7;
                                f7 = f11;
                            }
                            tessellator.func_78374_a((double)(f2 - f3), (double)(-f5), (double)f6, (double)f9, (double)f10);
                            tessellator.func_78374_a((double)(-f2 - f3), (double)(-f5), (double)f6, (double)f7, (double)f10);
                            tessellator.func_78374_a((double)(-f2 - f3), (double)(1.4f - f5), (double)f6, (double)f7, (double)f8);
                            tessellator.func_78374_a((double)(f2 - f3), (double)(1.4f - f5), (double)f6, (double)f9, (double)f8);
                            f4 -= 0.45f;
                            f5 -= 0.45f;
                            f2 *= 0.9f;
                            f6 += 0.03f;
                            ++i;
                        }
                        tessellator.func_78381_a();
                        GL11.glPopMatrix();
                        GL11.glEnable((int)2896);
                    }
                }
                catch (Throwable t) {
                    throw new ReportedException(CrashReport.func_85055_a((Throwable)t, (String)"Post-rendering entity in world"));
                }
            }
            catch (Throwable t) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)t, (String)"Rendering entity in world");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Entity being rendered");
                entity.func_85029_a(crashreportcategory);
                CrashReportCategory crashreportcategory1 = crashreport.func_85058_a("Renderer details");
                crashreportcategory1.func_71507_a("Assigned renderer", (Object)render);
                crashreportcategory1.func_71507_a("Location", (Object)CrashReportCategory.func_85074_a((double)x, (double)y, (double)z));
                crashreportcategory1.func_71507_a("Rotation", (Object)Float.valueOf(rotation));
                crashreportcategory1.func_71507_a("Delta", (Object)Float.valueOf(delta));
                throw new ReportedException(crashreport);
            }
        }
    }
}

