/*
 * Decompiled with CFR 0.152.
 */
package naruto1310.craftableAnimals.vanilla;

import java.lang.reflect.Method;
import naruto1310.craftableAnimals.core.AbstractCraftableAnimalsExtension;
import naruto1310.craftableAnimals.core.SpawnEntity;
import naruto1310.craftableAnimals.vanilla.CAConfig;
import net.minecraft.block.Block;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class CAVanillaExtension
extends AbstractCraftableAnimalsExtension {
    private static final String[] entitys = new String[]{"SnowMan", "VillagerGolem", "Bat", "Chicken", "Cow", "EntityHorse", "MushroomCow", "Ozelot", "Pig", "Sheep", "ShearedSheep", "Squid", "Villager", "Enderman", "Wolf", "PigZombie", "Blaze", "CaveSpider", "Creeper", "Ghast", "LavaSlime", "Silverfish", "Skeleton", "Slime", "Spider", "Jockey", "Zombie", "Witch", "EnderDragon", "Giant", "WitherBoss"};

    @Override
    public String[] getEntitys() {
        return entitys;
    }

    @Override
    public EntityLiving modifyEntity(EntityLiving entity, World world, EntityPlayer player, int type) {
        if (entity instanceof EntityHorse) {
            EntityHorse horse = (EntityHorse)entity;
            if (type < 35) {
                horse.func_110214_p(0);
                horse.func_110235_q(type / 5 + type % 5 * 256);
            } else {
                horse.func_110214_p(type - 34);
            }
            this.setAdult((EntityLiving)horse, true);
            return horse;
        }
        if (entity instanceof EntityOcelot) {
            EntityOcelot ocelot = (EntityOcelot)entity;
            ocelot.func_70096_w().func_75692_b(18, (Object)new Byte((byte)type));
            ocelot.func_70903_f(false);
            if (player != null && type != 0) {
                ocelot.func_70903_f(true);
                ocelot.func_70910_a(player.getDisplayName());
            }
            return ocelot;
        }
        if (entity instanceof EntityPig) {
            EntityPig pig = (EntityPig)entity;
            if (type == 1) {
                pig.func_70900_e(true);
            }
            if (type == 16) {
                pig.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAITempt((EntityCreature)pig, 0.25, (Item)Items.field_151112_aM, false));
                this.setAdult((EntityLiving)pig, false);
                if (player != null && player instanceof EntityClientPlayerMP) {
                    switch (player.func_70681_au().nextInt(3)) {
                        case 0: {
                            ((EntityClientPlayerMP)player).func_71165_d("What the heck? Where am I?");
                            break;
                        }
                        case 1: {
                            ((EntityClientPlayerMP)player).func_71165_d("Hey, let's go fishing.");
                            break;
                        }
                        case 2: {
                            ((EntityClientPlayerMP)player).func_71165_d("What's up?");
                        }
                    }
                }
            }
            return pig;
        }
        if (entity instanceof EntitySheep) {
            EntitySheep sheep = (EntitySheep)entity;
            sheep.func_70891_b(type % 16);
            sheep.func_70893_e(type > 15);
            return sheep;
        }
        if (entity instanceof EntityVillager) {
            EntityVillager villager = (EntityVillager)entity;
            villager.func_70938_b(type);
            return villager;
        }
        if (entity instanceof EntityEnderman) {
            EntityEnderman enderman2 = (EntityEnderman)entity;
            if (type != 0) {
                enderman2.func_146081_a(Block.func_149729_e((int)(type / 16)));
                enderman2.func_70817_b(type % 16);
            }
            return enderman2;
        }
        if (entity instanceof EntityWolf) {
            EntityWolf wolf = (EntityWolf)entity;
            if (type == 1) {
                wolf.func_70903_f(true);
                if (player != null) {
                    wolf.func_70910_a(player.getDisplayName());
                }
            }
            if (type == 2) {
                wolf.func_70916_h(true);
                if (player != null) {
                    wolf.func_70624_b((EntityLivingBase)player);
                }
            }
            return wolf;
        }
        if (entity instanceof EntitySlime) {
            try {
                EntitySlime slime = (EntitySlime)entity;
                boolean isMagmaCube = entity instanceof EntityMagmaCube;
                for (Method m : isMagmaCube ? slime.getClass().getSuperclass().getDeclaredMethods() : slime.getClass().getDeclaredMethods()) {
                    Class<?>[] params = m.getParameterTypes();
                    if (params.length != 1 || params[0] != Integer.TYPE) continue;
                    m.setAccessible(true);
                    m.invoke((Object)slime, type == (isMagmaCube ? 3 : 4) ? CAConfig.giantSlimeSize : type + 1);
                }
                return slime;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (entity instanceof EntityCreeper) {
            EntityCreeper creeper = (EntityCreeper)entity;
            creeper.func_70096_w().func_75692_b(17, (Object)((byte)type));
            return creeper;
        }
        if (entity instanceof EntitySkeleton) {
            EntitySkeleton skeleton = (EntitySkeleton)entity;
            for (int i = 0; i < 5; ++i) {
                skeleton.func_70062_b(i, null);
            }
            skeleton.func_82201_a(type);
            skeleton.field_70714_bg.func_75776_a(4, (EntityAIBase)(type == 0 ? new EntityAIArrowAttack((IRangedAttackMob)skeleton, 0.25, 60, 10.0f) : new EntityAIAttackOnCollide((EntityCreature)skeleton, EntityPlayer.class, (double)0.31f, false)));
            skeleton.func_70062_b(0, type == 0 ? new ItemStack((Item)Items.field_151031_f) : new ItemStack(Items.field_151052_q));
            return skeleton;
        }
        return entity;
    }

    @Override
    public int getTypeFromEntity(EntityLiving entity) {
        if (entity instanceof EntityOcelot) {
            return ((EntityOcelot)entity).func_70096_w().func_75683_a(18);
        }
        if (entity instanceof EntityPig) {
            return ((EntityPig)entity).func_70901_n() ? 1 : 0;
        }
        if (entity instanceof EntitySheep) {
            return ((EntitySheep)entity).func_70896_n();
        }
        if (entity instanceof EntityVillager) {
            return ((EntityVillager)entity).func_70946_n();
        }
        if (entity instanceof EntityWolf) {
            EntityWolf wolf = (EntityWolf)entity;
            return wolf.func_70909_n() ? 1 : (wolf.func_70919_bu() ? 2 : 0);
        }
        if (entity instanceof EntityMagmaCube) {
            EntityMagmaCube magmaCube = (EntityMagmaCube)entity;
            return magmaCube.func_70809_q() < 3 ? magmaCube.func_70809_q() : 3;
        }
        if (entity instanceof EntitySlime) {
            EntitySlime slime = (EntitySlime)entity;
            return slime.func_70809_q() < 4 ? slime.func_70809_q() : 4;
        }
        if (entity instanceof EntityCreeper) {
            return ((EntityCreeper)entity).func_70830_n() ? 1 : 0;
        }
        if (entity instanceof EntitySkeleton) {
            return ((EntitySkeleton)entity).func_82202_m();
        }
        if (entity instanceof EntityZombie) {
            return ((EntityZombie)entity).func_82231_m() ? 1 : 0;
        }
        return 0;
    }

    @Override
    public EntityLiving setAdult(EntityLiving entity, boolean adult) {
        if (entity instanceof EntityAgeable) {
            ((EntityAgeable)entity).func_70873_a(adult ? 6000 : -24000);
            return entity;
        }
        if (entity instanceof EntityZombie) {
            if (!adult) {
                ((EntityZombie)entity).func_82227_f(true);
            } else {
                EntityZombie zombie = (EntityZombie)SpawnEntity.getEntityForRender("Zombie", entity.field_70170_p, SpawnEntity.getTypeFromEntity(entity));
                zombie.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
                for (int i = 0; i < 5; ++i) {
                    zombie.func_70062_b(i, entity.func_71124_b(i));
                }
                World world = entity.field_70170_p;
                entity.func_70106_y();
                world.func_72838_d((Entity)zombie);
            }
            return entity;
        }
        return null;
    }

    @Override
    public EntityLiving overwriteSpawn(String animal, World world, double x, double y, double z, EntityPlayer player, int type) {
        if (animal.contentEquals("Jockey")) {
            EntityLiving spider = SpawnEntity.spawn((type >= 4 ? "Cave" : "") + "Spider", world, x, y, z, player, 0);
            EntityLiving jockey = SpawnEntity.spawn(type % 4 == 0 ? "Skeleton" : (type % 4 == 1 ? "Zombie" : (type % 4 == 2 ? "PigZombie" : "Creeper")), world, x, y, z, player, 0);
            jockey.func_70078_a((Entity)spider);
            return spider;
        }
        return null;
    }
}

