/*
 * Decompiled with CFR 0.152.
 */
package naruto1310.craftableAnimals.core;

import naruto1310.craftableAnimals.core.AbstractCraftableAnimalsExtension;
import naruto1310.craftableAnimals.core.CraftableAnimalsRegistry;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class SpawnEntity {
    private static String getStringFromEntity(EntityLiving entity) {
        return EntityList.func_75621_b((Entity)entity);
    }

    public static EntityLiving spawn(String animal, World world, double x, double y, double z, EntityPlayer player, int type) {
        for (AbstractCraftableAnimalsExtension extension : CraftableAnimalsRegistry.getExtensions()) {
            if (!SpawnEntity.isHandler(extension, animal)) continue;
            EntityLiving entity = extension.overwriteSpawn(animal, world, x, y, z, player, type);
            if (entity != null) {
                return entity;
            }
            entity = extension.modifyEntity((EntityLiving)EntityList.func_75620_a((String)animal, (World)world), world, player, type);
            if (entity == null) {
                String s = "Could not spawn \"" + animal + "\".";
                if (player instanceof EntityClientPlayerMP) {
                    ((EntityClientPlayerMP)player).func_71165_d(s);
                }
                new NullPointerException(s).printStackTrace();
                return null;
            }
            entity.func_70012_b(x, y, z, world.field_73012_v.nextFloat(), 0.0f);
            world.func_72838_d((Entity)entity);
            return entity;
        }
        EntityLiving entity = (EntityLiving)EntityList.func_75620_a((String)animal, (World)world);
        entity.func_70012_b(x, y, z, world.field_73012_v.nextFloat(), 0.0f);
        world.func_72838_d((Entity)entity);
        return entity;
    }

    public static EntityLiving getEntityForRender(String animal, World world, int type) {
        for (AbstractCraftableAnimalsExtension extension : CraftableAnimalsRegistry.getExtensions()) {
            if (!SpawnEntity.isHandler(extension, animal)) continue;
            return extension.modifyEntity((EntityLiving)EntityList.func_75620_a((String)animal, (World)world), world, null, type);
        }
        return (EntityLiving)EntityList.func_75620_a((String)animal, (World)world);
    }

    public static int getTypeFromEntity(EntityLiving entity) {
        for (AbstractCraftableAnimalsExtension extension : CraftableAnimalsRegistry.getExtensions()) {
            if (!SpawnEntity.isHandler(extension, SpawnEntity.getStringFromEntity(entity))) continue;
            return extension.getTypeFromEntity(entity);
        }
        return 0;
    }

    public static EntityLiving setAdult(EntityLiving entity, boolean adult) {
        for (AbstractCraftableAnimalsExtension extension : CraftableAnimalsRegistry.getExtensions()) {
            if (!SpawnEntity.isHandler(extension, SpawnEntity.getStringFromEntity(entity))) continue;
            return extension.setAdult(entity, adult);
        }
        return null;
    }

    public static boolean isSpawnable(String animal) {
        for (AbstractCraftableAnimalsExtension extension : CraftableAnimalsRegistry.getExtensions()) {
            if (!SpawnEntity.isHandler(extension, animal)) continue;
            return true;
        }
        return false;
    }

    private static boolean isHandler(AbstractCraftableAnimalsExtension extension, String animal) {
        for (String s : extension.getEntitys()) {
            if (!animal.contentEquals(s)) continue;
            return true;
        }
        return false;
    }
}

