/*
 * Decompiled with CFR 0.152.
 */
package naruto1310.craftableAnimals.vanilla;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBlaze;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelCow;
import net.minecraft.client.model.ModelCreeper;
import net.minecraft.client.model.ModelEnderman;
import net.minecraft.client.model.ModelIronGolem;
import net.minecraft.client.model.ModelMagmaCube;
import net.minecraft.client.model.ModelPig;
import net.minecraft.client.model.ModelQuadruped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.model.ModelSheep1;
import net.minecraft.client.model.ModelSheep2;
import net.minecraft.client.model.ModelSlime;
import net.minecraft.client.model.ModelSnowMan;
import net.minecraft.client.model.ModelSpider;
import net.minecraft.client.model.ModelSquid;
import net.minecraft.client.model.TexturedQuad;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class EntityArmorRenderer {
    private static Map<ModelBase, ModelRenderer> helmets = new HashMap<ModelBase, ModelRenderer>();
    private static Map<ModelBase, ModelRenderer> chests0 = new HashMap<ModelBase, ModelRenderer>();
    private static Map<ModelBase, ModelRenderer> chests1 = new HashMap<ModelBase, ModelRenderer>();
    private static Map<ModelBase, ModelRenderer> chests2 = new HashMap<ModelBase, ModelRenderer>();
    private static Map<ModelBase, ModelRenderer> alegs = new HashMap<ModelBase, ModelRenderer>();
    private static Map<ModelBase, ModelRenderer> clegs = new HashMap<ModelBase, ModelRenderer>();
    private static Map<ModelBase, ModelRenderer> boots = new HashMap<ModelBase, ModelRenderer>();
    private static Field blazeHead = null;
    private static Field squidBody = null;
    private static Field slimeBodys = null;
    private static Field magmaCubeBodys = null;
    private static ResourceLocation textureCreeper = new ResourceLocation("textures/entity/creeper/creeper.png");
    private static ResourceLocation texturePig = new ResourceLocation("textures/entity/pig/pig.png");
    private static ResourceLocation textureCow = new ResourceLocation("textures/entity/cow/cow.png");
    private static ResourceLocation textureMooshroom = new ResourceLocation("textures/entity/cow/mooshroom.png");
    private static ResourceLocation textureSheep = new ResourceLocation("textures/entity/sheep/sheep.png");
    private static ResourceLocation textureSheep2 = new ResourceLocation("textures/entity/sheep/sheep_fur.png");
    private static ResourceLocation textureSlime = new ResourceLocation("textures/entity/slime/slime.png");
    private static boolean setColor = true;

    public static void render(ModelBase model, Entity entity) {
        if (!(entity instanceof EntityLiving)) {
            return;
        }
        setColor = ((EntityLiving)entity).field_70737_aN == 0;
        EntityArmorRenderer.renderHelmet(model, entity);
        EntityArmorRenderer.renderChestplate(model, entity);
        EntityArmorRenderer.renderLegs(model, entity);
        EntityArmorRenderer.renderBoots(model, entity);
    }

    private static void renderHelmet(ModelBase model, Entity entity) {
        if (!EntityArmorRenderer.hasArmor(entity, 4)) {
            return;
        }
        boolean c = model.field_78091_s;
        if (model instanceof ModelSnowMan) {
            EntityArmorRenderer.render(EntityArmorRenderer.setupHelmet(model, ((ModelSnowMan)model).field_78195_c, -10.0f, -4.7f), entity, 4, 1.3f);
        }
        if (model instanceof ModelQuadruped) {
            ModelQuadruped q = (ModelQuadruped)model;
            if (model instanceof ModelSheep1) {
                if (c) {
                    GL11.glTranslatef((float)0.0f, (float)0.5f, (float)0.25f);
                }
                EntityArmorRenderer.render(EntityArmorRenderer.setupHelmet(model, q.field_78150_a, -6.0f, -6.1f), entity, 4, 1.0f);
                if (c) {
                    GL11.glTranslatef((float)0.0f, (float)-0.5f, (float)-0.25f);
                }
                return;
            }
            if (model instanceof ModelCow) {
                if (c) {
                    GL11.glTranslatef((float)0.0f, (float)0.5f, (float)0.375f);
                }
                EntityArmorRenderer.render(EntityArmorRenderer.setupHelmet(model, q.field_78150_a, -6.0f, -7.0f), entity, 4, 1.0f);
                if (c) {
                    GL11.glTranslatef((float)0.0f, (float)-0.5f, (float)-0.375f);
                }
                return;
            }
            if (model instanceof ModelPig) {
                if (model.field_78091_s) {
                    GL11.glTranslatef((float)0.0f, (float)0.25f, (float)0.25f);
                }
                EntityArmorRenderer.render(EntityArmorRenderer.setupHelmet(model, q.field_78150_a, -6.0f, -8.5f), entity, 4, 1.0f);
                if (model.field_78091_s) {
                    GL11.glTranslatef((float)0.0f, (float)-0.25f, (float)-0.25f);
                }
                return;
            }
        }
        if (model instanceof ModelSquid) {
            try {
                EntityArmorRenderer.render(EntityArmorRenderer.setupHelmet(model, (ModelRenderer)squidBody.get(model), -8.5f, -4.5f), entity, 4, 1.5f);
            }
            catch (Exception e) {
                if (squidBody == null) {
                    for (Field f : ModelSquid.class.getDeclaredFields()) {
                        if (f.getType() != ModelRenderer.class) continue;
                        f.setAccessible(true);
                        squidBody = f;
                        return;
                    }
                }
                e.printStackTrace();
            }
            return;
        }
        if (model instanceof ModelIronGolem) {
            EntityArmorRenderer.render(EntityArmorRenderer.setupHelmet(model, ((ModelIronGolem)model).field_78178_a, -12.1f, -6.0f), entity, 4, 1.0f);
            return;
        }
        if (model instanceof ModelSlime) {
            try {
                EntityArmorRenderer.render(EntityArmorRenderer.setupHelmet(model, (ModelRenderer)slimeBodys.get(model), 14.0f, -4.5f), entity, 4, 1.0f);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(textureSlime);
            }
            catch (Exception e) {
                if (slimeBodys == null) {
                    Field f = ModelSlime.class.getDeclaredFields()[0];
                    f.setAccessible(true);
                    slimeBodys = f;
                }
                e.printStackTrace();
            }
            return;
        }
        if (model instanceof ModelMagmaCube) {
            try {
                EntityArmorRenderer.render(EntityArmorRenderer.setupHelmet(model, ((ModelRenderer[])magmaCubeBodys.get(model))[0], 14.0f, -4.5f), entity, 4, 1.0f);
            }
            catch (Exception e) {
                if (magmaCubeBodys == null) {
                    for (Field f : ModelMagmaCube.class.getDeclaredFields()) {
                        if (f.getType() != ModelRenderer[].class) continue;
                        f.setAccessible(true);
                        magmaCubeBodys = f;
                        return;
                    }
                }
                e.printStackTrace();
            }
            return;
        }
        if (model instanceof ModelSpider) {
            EntityArmorRenderer.render(EntityArmorRenderer.setupHelmet(model, ((ModelSpider)model).field_78209_a, -6.0f, -8.5f), entity, 4, 1.0f);
            return;
        }
        if (model instanceof ModelBlaze) {
            try {
                EntityArmorRenderer.render(EntityArmorRenderer.setupHelmet(model, (ModelRenderer)blazeHead.get(model), -6.0f, -4.5f), entity, 4, 1.0f);
            }
            catch (Exception e) {
                if (blazeHead == null) {
                    for (Field f : ModelBlaze.class.getDeclaredFields()) {
                        if (f.getType() != ModelRenderer.class) continue;
                        f.setAccessible(true);
                        blazeHead = f;
                        return;
                    }
                }
                e.printStackTrace();
            }
            return;
        }
        if (model instanceof ModelEnderman) {
            EntityArmorRenderer.render(EntityArmorRenderer.setupHelmet(model, ((ModelEnderman)model).field_78116_c, -8.5f, -4.5f), entity, 4, 1.0f);
            return;
        }
        if (model instanceof ModelCreeper) {
            EntityArmorRenderer.render(EntityArmorRenderer.setupHelmet(model, ((ModelCreeper)model).field_78135_a, -8.5f, -4.5f), entity, 4, 1.0f);
            return;
        }
    }

    private static void renderChestplate(ModelBase model, Entity entity) {
        if (!EntityArmorRenderer.hasArmor(entity, 3)) {
            return;
        }
        if (model instanceof ModelCreeper) {
            EntityArmorRenderer.render(((ModelCreeper)model).field_78134_c, entity, 3, 1.1f);
        }
        if (model instanceof ModelEnderman) {
            ModelRenderer chest = chests0.get(model);
            if (chest == null) {
                chest = new ModelRenderer(model, 16, 16);
                chest.func_78790_a(-4.0f, 2.0f, -2.0f, 8, 12, 4, 0.0f);
                chests0.put(model, chest);
            }
            ModelRenderer m = ((ModelEnderman)model).field_78115_e;
            chest.func_78793_a(m.field_78800_c, m.field_78797_d, m.field_78798_e);
            chest.field_78795_f = m.field_78795_f;
            chest.field_78796_g = m.field_78796_g + (float)Math.toRadians(180.0);
            chest.field_78808_h = m.field_78808_h;
            EntityArmorRenderer.render(chest, entity, 3, 1.1f);
            ModelRenderer armL = chests1.get(model);
            if (armL == null) {
                armL = new ModelRenderer(model, 40, 16);
                armL.func_78790_a(-2.5f, -2.5f, -2.0f, 4, 12, 4, 0.0f);
                chests1.put(model, armL);
            }
            m = ((ModelEnderman)model).field_78113_g;
            armL.func_78793_a(m.field_78800_c, m.field_78797_d, m.field_78798_e);
            armL.field_78795_f = m.field_78795_f;
            armL.field_78796_g = m.field_78796_g;
            armL.field_78808_h = m.field_78808_h;
            EntityArmorRenderer.render(armL, entity, 3, 1.0f);
            ModelRenderer armR = chests2.get(model);
            if (armR == null) {
                armR = new ModelRenderer(model, 40, 16);
                armR.func_78790_a(-1.5f, -2.5f, -2.0f, 4, 12, 4, 0.0f);
                chests2.put(model, armR);
            }
            m = ((ModelEnderman)model).field_78112_f;
            armR.func_78793_a(m.field_78800_c, m.field_78797_d, m.field_78798_e);
            armR.field_78795_f = m.field_78795_f;
            armR.field_78796_g = m.field_78796_g;
            armR.field_78808_h = m.field_78808_h;
            EntityArmorRenderer.render(armR, entity, 3, 1.0f);
        }
    }

    private static void renderLegs(ModelBase model, Entity entity) {
        if (!EntityArmorRenderer.hasArmor(entity, 2)) {
            return;
        }
    }

    private static void renderBoots(ModelBase model, Entity entity) {
        ModelCreeper m;
        ModelRenderer leg;
        int i;
        ModelRenderer aleg;
        if (!(EntityArmorRenderer.hasArmor(entity, 1) || model instanceof ModelCreeper || model instanceof ModelQuadruped)) {
            return;
        }
        boolean c = model.field_78091_s;
        if (model instanceof ModelQuadruped) {
            if (c) {
                GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                GL11.glTranslatef((float)0.0f, (float)1.5f, (float)0.0f);
            }
            ModelQuadruped q = (ModelQuadruped)model;
            if (model instanceof ModelCow) {
                if (entity instanceof EntityMooshroom) {
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(textureMooshroom);
                } else {
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(textureCow);
                }
                q.field_78149_c.func_78785_a(0.0625f);
                q.field_78146_d.func_78785_a(0.0625f);
                q.field_78147_e.func_78785_a(0.0625f);
                q.field_78144_f.func_78785_a(0.0625f);
                EntityArmorRenderer.render(q.field_78149_c, entity, 1, 1.0f);
                EntityArmorRenderer.render(q.field_78146_d, entity, 1, 1.0f);
                EntityArmorRenderer.render(q.field_78147_e, entity, 1, 1.0f);
                EntityArmorRenderer.render(q.field_78144_f, entity, 1, 1.0f);
            }
            if (model instanceof ModelPig) {
                if (EntityArmorRenderer.hasArmor(entity, 1)) {
                    ModelRenderer cleg;
                    aleg = alegs.get(model);
                    if (aleg == null) {
                        aleg = new ModelRenderer(model, 0, 16);
                        aleg.func_78790_a(-2.0f, -6.0f, -2.0f, 4, 12, 4, 0.0f);
                        alegs.put(model, aleg);
                    }
                    if ((cleg = clegs.get(model)) == null) {
                        cleg = new ModelRenderer(model);
                        cleg.field_78804_l.add(new ModelCustomBox(cleg, 0, 16, -2.0f, 0.0f, -2.0f, 4, 6, 4, 0.0f));
                        clegs.put(model, cleg);
                    }
                    for (i = 0; i < 4; ++i) {
                        leg = i == 0 ? q.field_78149_c : (i == 1 ? q.field_78146_d : (i == 2 ? q.field_78147_e : q.field_78144_f));
                        aleg.func_78793_a(leg.field_78800_c, leg.field_78797_d, leg.field_78798_e);
                        cleg.func_78793_a(leg.field_78800_c, leg.field_78797_d, leg.field_78798_e);
                        cleg.field_78795_f = aleg.field_78795_f = leg.field_78795_f;
                        cleg.field_78796_g = aleg.field_78796_g = leg.field_78796_g;
                        cleg.field_78808_h = aleg.field_78808_h = leg.field_78808_h;
                        Minecraft.func_71410_x().func_110434_K().func_110577_a(texturePig);
                        if (setColor) {
                            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                        }
                        cleg.func_78785_a(0.0625f);
                        EntityArmorRenderer.render(aleg, entity, 1, 1.0f);
                    }
                } else {
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(texturePig);
                    q.field_78149_c.func_78785_a(0.0625f);
                    q.field_78146_d.func_78785_a(0.0625f);
                    q.field_78147_e.func_78785_a(0.0625f);
                    q.field_78144_f.func_78785_a(0.0625f);
                }
            }
            if (model instanceof ModelSheep1) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(textureSheep2);
                if (setColor) {
                    float[] f = EntitySheep.field_70898_d[((EntitySheep)entity).func_70896_n()];
                    GL11.glColor3f((float)f[0], (float)f[1], (float)f[2]);
                }
                q.field_78149_c.func_78785_a(0.0625f);
                q.field_78146_d.func_78785_a(0.0625f);
                q.field_78147_e.func_78785_a(0.0625f);
                q.field_78144_f.func_78785_a(0.0625f);
            }
            if (model instanceof ModelSheep2) {
                if (EntityArmorRenderer.hasArmor(entity, 1)) {
                    aleg = alegs.get(model);
                    if (aleg == null) {
                        aleg = new ModelRenderer(model, 0, 16);
                        aleg.func_78790_a(-2.0f, 0.0f, -2.0f, 4, 12, 4, 0.0f);
                        alegs.put(model, aleg);
                    }
                    for (int i2 = 0; i2 < 4; ++i2) {
                        ModelRenderer leg2 = i2 == 0 ? q.field_78149_c : (i2 == 1 ? q.field_78146_d : (i2 == 2 ? q.field_78147_e : q.field_78144_f));
                        aleg.func_78793_a(leg2.field_78800_c, leg2.field_78797_d, leg2.field_78798_e);
                        aleg.field_78795_f = leg2.field_78795_f;
                        aleg.field_78796_g = leg2.field_78796_g;
                        aleg.field_78808_h = leg2.field_78808_h;
                        if (setColor) {
                            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                        }
                        EntityArmorRenderer.render(aleg, entity, 1, 1.0f);
                    }
                } else {
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(textureSheep);
                    if (setColor) {
                        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                    }
                    q.field_78149_c.func_78785_a(0.0625f);
                    q.field_78146_d.func_78785_a(0.0625f);
                    q.field_78147_e.func_78785_a(0.0625f);
                    q.field_78144_f.func_78785_a(0.0625f);
                }
            }
            if (c) {
                GL11.glTranslatef((float)0.0f, (float)-1.5f, (float)0.0f);
                GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
            }
        }
        if (model instanceof ModelSquid) {
            try {
                ModelRenderer[] squidTentcales = null;
                for (Field f : ModelSquid.class.getDeclaredFields()) {
                    if (f.getType() != ModelRenderer[].class) continue;
                    f.setAccessible(true);
                    squidTentcales = (ModelRenderer[])f.get(model);
                    break;
                }
                if ((aleg = alegs.get(model)) == null) {
                    aleg = new ModelRenderer(model, 0, 16);
                    aleg.func_78790_a(-2.0f, 7.0f, -2.0f, 4, 12, 4, 0.0f);
                    alegs.put(model, aleg);
                }
                for (int i3 = 0; i3 < 8; ++i3) {
                    void leg3 = squidTentcales[i3];
                    aleg.func_78793_a(leg3.field_78800_c, leg3.field_78797_d, leg3.field_78798_e);
                    aleg.field_78795_f = leg3.field_78795_f;
                    aleg.field_78796_g = leg3.field_78796_g;
                    aleg.field_78808_h = leg3.field_78808_h;
                    EntityArmorRenderer.render(aleg, entity, 1, 1.0f);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (model instanceof ModelBlaze) {
            try {
                if (EntityArmorRenderer.hasArmor(entity, 1)) {
                    ModelRenderer[] blazeSticks = null;
                    for (Field f : ModelBlaze.class.getDeclaredFields()) {
                        if (f.getType() != ModelRenderer[].class) continue;
                        f.setAccessible(true);
                        blazeSticks = (ModelRenderer[])f.get(model);
                        break;
                    }
                    if ((aleg = alegs.get(model)) == null) {
                        aleg = new ModelRenderer(model, 0, 16);
                        aleg.func_78789_a(0.0f, 0.0f, 0.0f, 2, 8, 2);
                        alegs.put(model, aleg);
                    }
                    for (int i4 = 0; i4 < 12; ++i4) {
                        void leg4 = blazeSticks[i4];
                        aleg.func_78793_a(leg4.field_78800_c, leg4.field_78797_d, leg4.field_78798_e);
                        aleg.field_78795_f = leg4.field_78795_f;
                        aleg.field_78796_g = leg4.field_78796_g;
                        aleg.field_78808_h = leg4.field_78808_h;
                        EntityArmorRenderer.render(aleg, entity, 1, 1.01f);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (model instanceof ModelCreeper) {
            m = (ModelCreeper)model;
            if (EntityArmorRenderer.hasArmor(entity, 1)) {
                ModelRenderer cleg;
                aleg = alegs.get(model);
                if (aleg == null) {
                    aleg = new ModelRenderer(model, 0, 16);
                    aleg.func_78790_a(-2.0f, -6.0f, -2.0f, 4, 12, 4, 0.0f);
                    alegs.put(model, aleg);
                }
                if ((cleg = clegs.get(model)) == null) {
                    cleg = new ModelRenderer(model);
                    cleg.field_78804_l.add(new ModelCustomBox(cleg, 0, 16, -2.0f, 0.0f, -2.0f, 4, 6, 4, 0.0f));
                    clegs.put(model, cleg);
                }
                for (i = 0; i < 4; ++i) {
                    leg = i == 0 ? m.field_78131_d : (i == 1 ? m.field_78132_e : (i == 2 ? m.field_78129_f : m.field_78130_g));
                    aleg.func_78793_a(leg.field_78800_c, leg.field_78797_d, leg.field_78798_e);
                    cleg.func_78793_a(leg.field_78800_c, leg.field_78797_d, leg.field_78798_e);
                    cleg.field_78795_f = aleg.field_78795_f = leg.field_78795_f;
                    cleg.field_78796_g = aleg.field_78796_g = leg.field_78796_g;
                    cleg.field_78808_h = aleg.field_78808_h = leg.field_78808_h;
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(textureCreeper);
                    if (setColor) {
                        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                    }
                    cleg.func_78785_a(0.0625f);
                    EntityArmorRenderer.render(aleg, entity, 1, 1.0f);
                }
            } else {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(textureCreeper);
                m.field_78131_d.func_78785_a(0.0625f);
                m.field_78132_e.func_78785_a(0.0625f);
                m.field_78129_f.func_78785_a(0.0625f);
                m.field_78130_g.func_78785_a(0.0625f);
            }
        }
        if (model instanceof ModelEnderman) {
            m = (ModelEnderman)model;
            aleg = alegs.get(model);
            if (aleg == null) {
                aleg = new ModelRenderer(model, 0, 16);
                aleg.func_78790_a(-2.0f, 20.0f, -2.0f, 4, 12, 4, 0.0f);
                alegs.put(model, aleg);
            }
            for (int i5 = 0; i5 < 2; ++i5) {
                ModelRenderer leg5 = i5 == 0 ? m.field_78124_i : m.field_78123_h;
                aleg.func_78793_a(leg5.field_78800_c, leg5.field_78797_d, leg5.field_78798_e);
                aleg.field_78795_f = leg5.field_78795_f;
                aleg.field_78796_g = leg5.field_78796_g;
                aleg.field_78808_h = leg5.field_78808_h;
                EntityArmorRenderer.render(aleg, entity, 1, 1.0f);
            }
        }
        if (model instanceof ModelSpider) {
            m = (ModelSpider)model;
            aleg = alegs.get(model);
            if (aleg == null) {
                aleg = new ModelRenderer(model, 0, 16);
                aleg.func_78790_a(-2.0f, 4.0f, -2.0f, 4, 12, 4, 0.0f);
                alegs.put(model, aleg);
            }
            ModelRenderer[] legs = new ModelRenderer[]{m.field_78205_d, m.field_78206_e, m.field_78203_f, m.field_78204_g, m.field_78212_h, m.field_78213_i, m.field_78210_j, m.field_78211_k};
            for (i = 0; i < 8; ++i) {
                leg = legs[i];
                aleg.func_78793_a(leg.field_78800_c, leg.field_78797_d, leg.field_78798_e);
                aleg.field_78795_f = leg.field_78796_g;
                aleg.field_78796_g = leg.field_78795_f;
                aleg.field_78808_h = -leg.field_78808_h;
                EntityArmorRenderer.render(aleg, entity, 1, 1.0f);
            }
        }
    }

    private static ModelRenderer setupHelmet(ModelBase model, ModelRenderer head, float y, float z) {
        ModelRenderer helmet = helmets.get(model);
        if (helmet == null) {
            helmet = new ModelRenderer(model, 0, 0).func_78787_b(72, 36);
            helmet.func_78790_a(-4.5f, y, z, 9, 9, 9, 0.0f);
            helmets.put(model, helmet);
        }
        helmet.func_78793_a(head.field_78800_c, head.field_78797_d, head.field_78798_e);
        helmet.field_78795_f = head.field_78795_f;
        helmet.field_78796_g = head.field_78796_g;
        helmet.field_78808_h = head.field_78808_h;
        return helmet;
    }

    private static boolean hasArmor(Entity entity, int slot) {
        return ((EntityLiving)entity).func_71124_b(4) != null;
    }

    private static void render(ModelRenderer model, Entity entity, int slot, float scale) {
        ItemStack stack = ((EntityLiving)entity).func_71124_b(slot);
        if (stack == null) {
            return;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(RenderBiped.getArmorResource((Entity)entity, (ItemStack)stack, (int)1, null));
        if (setColor) {
            int c = ((ItemArmor)stack.func_77973_b()).func_82814_b(stack);
            GL11.glColor3f((float)((float)(c >> 16 & 0xFF) / 255.0f), (float)((float)(c >> 8 & 0xFF) / 255.0f), (float)((float)(c & 0xFF) / 255.0f));
        }
        if (scale != 1.0f) {
            GL11.glScalef((float)scale, (float)scale, (float)scale);
        }
        model.func_78785_a(0.0625f);
        if (scale != 1.0f) {
            scale = 1.0f / scale;
            GL11.glScalef((float)scale, (float)scale, (float)scale);
        }
    }

    private static class ModelCustomBox
    extends ModelBox {
        private Field quadListField;
        private TexturedQuad[] quadList;

        public ModelCustomBox(ModelRenderer par1ModelRenderer, int par2, int par3, float par4, float par5, float par6, int par7, int par8, int par9, float par10) {
            super(par1ModelRenderer, par2, par3, par4, par5, par6, par7, par8, par9, par10);
        }

        public void func_78245_a(Tessellator t, float par2) {
            TexturedQuad[] ql = this.getQuadList();
            ql[2].func_78236_a(t, par2);
        }

        private TexturedQuad[] getQuadList() {
            if (this.quadList != null) {
                return this.quadList;
            }
            try {
                if (this.quadListField == null) {
                    for (Field f : ModelBox.class.getDeclaredFields()) {
                        if (f.getType() != TexturedQuad[].class) continue;
                        f.setAccessible(true);
                        this.quadListField = f;
                    }
                }
                this.quadList = (TexturedQuad[])this.quadListField.get((Object)this);
                return this.quadList;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

