/*
 * Decompiled with CFR 0.152.
 */
package naruto1310.craftableAnimals.vanilla;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.util.List;
import naruto1310.craftableAnimals.core.ItemCraftableAnimalBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.EntityInteractEvent;

public class ItemAnimalSoul
extends ItemCraftableAnimalBase {
    public ItemAnimalSoul() {
        this.func_77625_d(1);
        this.func_77642_a((Item)this);
        GameRegistry.registerItem((Item)this, (String)"craftableAnimals:animalSoul", (String)"craftableAnimals");
    }

    @SubscribeEvent
    public void onEntityInteract(EntityInteractEvent event) {
        EntityPlayer player = event.entityPlayer;
        ItemStack stack = player.func_71045_bC();
        World world = player.field_70170_p;
        if (world.field_72995_K || stack == null || !(stack.func_77973_b() instanceof ItemAnimalSoul)) {
            return;
        }
        if (((ItemAnimalSoul)stack.func_77973_b()).canUse(stack, world, player)) {
            ((ItemAnimalSoul)stack.func_77973_b()).onInteract(event);
        } else if (event.target instanceof EntityLiving) {
            stack.func_77982_d(((ItemAnimalSoul)stack.func_77973_b()).writeEntityToNBT((EntityLiving)event.target));
        }
        event.setCanceled(true);
    }

    @Override
    public EntityLiving[] spawn(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side) {
        if (stack.func_77942_o()) {
            EntityLiving[] entitys;
            for (EntityLiving entity : entitys = this.readEntityFromNBT(stack.func_77978_p(), world)) {
                entity.func_70107_b((double)x, (double)(y + 1), (double)z);
                world.func_72838_d((Entity)entity);
            }
            stack.func_77982_d(null);
            return entitys;
        }
        return null;
    }

    @Override
    public EntityLiving[] createEntity(ItemStack stack, World world) {
        if (!stack.func_77942_o()) {
            return null;
        }
        return this.readEntityFromNBT(stack.func_77978_p(), world);
    }

    @Override
    public String getAnimal(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return null;
        }
        return stack.func_77978_p().func_74779_i("EntityId");
    }

    @Override
    public int getType(ItemStack stack) {
        return 0;
    }

    @Override
    public void use(ItemStack stack, World world, EntityPlayer player) {
        stack.func_77982_d(null);
    }

    private NBTTagCompound getAdditionalEntityData(EntityLiving entity) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74776_a("limbSwing", entity.field_70754_ba);
        nbt.func_74776_a("rotationYawHead", entity.field_70759_as);
        nbt.func_74776_a("prevRotationYawHead", entity.field_70758_at);
        if (entity instanceof EntitySquid) {
            nbt.func_74776_a("tentacleAngle", ((EntitySquid)entity).field_70866_j);
            nbt.func_74776_a("prevTentacleAngle", ((EntitySquid)entity).field_70865_by);
        }
        if (entity instanceof EntitySheep) {
            try {
                for (Field f : EntitySheep.class.getDeclaredFields()) {
                    if (f.getType() != Integer.TYPE) continue;
                    f.setAccessible(true);
                    nbt.func_74768_a("sheepTimer", f.getInt(entity));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return nbt;
    }

    private void writeAdditionalDataToEntity(NBTTagCompound nbt, EntityLiving entity) {
        entity.field_70754_ba = nbt.func_74760_g("limbSwing");
        entity.field_70759_as = nbt.func_74760_g("rotationYawHead");
        entity.field_70758_at = nbt.func_74760_g("prevRotationYawHead");
        if (entity instanceof EntitySquid) {
            ((EntitySquid)entity).field_70866_j = nbt.func_74760_g("tentacleAngle");
            ((EntitySquid)entity).field_70865_by = nbt.func_74760_g("prevTentacleAngle");
        }
        if (entity instanceof EntitySheep) {
            try {
                for (Field f : EntitySheep.class.getDeclaredFields()) {
                    if (f.getType() != Integer.TYPE) continue;
                    f.setAccessible(true);
                    f.set(entity, new Integer(nbt.func_74762_e("sheepTimer")));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private NBTTagCompound writeEntityToNBT(EntityLiving entity) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("EntityId", EntityList.func_75621_b((Entity)entity));
        NBTTagCompound data = new NBTTagCompound();
        entity.func_70109_d(data);
        nbt.func_74782_a("animal", (NBTBase)data);
        nbt.func_74782_a("extraData", (NBTBase)this.getAdditionalEntityData(entity));
        if (entity.field_70153_n != null) {
            nbt.func_74782_a("ridden", (NBTBase)this.writeEntityToNBT((EntityLiving)entity.field_70153_n));
        }
        entity.func_70106_y();
        return nbt;
    }

    private EntityLiving[] readEntityFromNBT(NBTTagCompound nbt, World world) {
        EntityLiving entity = (EntityLiving)EntityList.func_75620_a((String)nbt.func_74779_i("EntityId"), (World)world);
        entity.func_70020_e(nbt.func_74775_l("animal"));
        this.writeAdditionalDataToEntity(nbt.func_74775_l("extraData"), entity);
        EntityLiving[] entitys = new EntityLiving[]{entity};
        if (nbt.func_74764_b("ridden")) {
            EntityLiving[] ridingEntitys = this.readEntityFromNBT(nbt.func_74775_l("ridden"), world);
            entitys = new EntityLiving[ridingEntitys.length + 1];
            for (int i = 0; i < ridingEntitys.length; ++i) {
                entitys[i + 1] = ridingEntitys[i];
            }
            entitys[0] = entity;
            entitys[1].func_70078_a((Entity)entitys[0]);
        }
        return entitys;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean held) {
        if (stack.func_77942_o()) {
            EntityLiving entity = this.createEntity(stack, player.field_70170_p)[0];
            list.add("Animal: " + EntityList.func_75621_b((Entity)entity));
            list.add("Health: " + entity.func_110143_aJ() / 2.0f);
            int riders = this.getNumRiders(stack.func_77978_p());
            if (riders > 0) {
                if (riders == 1) {
                    list.add("Ridden by " + stack.func_77978_p().func_74775_l("ridden").func_74779_i("EntityId"));
                } else {
                    list.add("Ridden by " + riders + " animals");
                }
            }
            list.add(this.getNumTags(stack.func_77978_p()) + " more tags");
        } else {
            list.add("empty");
        }
    }

    private int getNumTags(NBTTagCompound nbt) {
        int r = 0;
        for (Object o : nbt.func_150296_c()) {
            if (o instanceof NBTTagCompound) {
                r += this.getNumTags((NBTTagCompound)o);
                continue;
            }
            ++r;
        }
        return r;
    }

    private int getNumRiders(NBTTagCompound nbt) {
        int r = 0;
        if (nbt.func_74764_b("ridden")) {
            ++r;
            r += this.getNumRiders((NBTTagCompound)nbt.func_74781_a("ridden"));
        }
        return r;
    }

    @Override
    public boolean canUse(ItemStack stack, World world, EntityPlayer player) {
        return stack.func_77942_o();
    }
}

