/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.util;

import java.util.Random;
import mod.lucky.drop.LuckyDrop;
import mod.lucky.drop.LuckyDropBase;
import mod.lucky.util.CustomNBTTags;
import mod.lucky.util.ExpressionParser;
import mod.lucky.util.LuckyFunction;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class MakeLuckyDrops {
    public ExpressionParser expressionParser = ExpressionParser.instance;
    public EntityPlayer player;
    public World world;
    public int harvestX;
    public int harvestY;
    public int harvestZ;

    public LuckyDrop[] getDrops(LuckyDropBase drop, World world, EntityPlayer player, int harvestX, int harvestY, int harvestZ) throws ExpressionParser.ExpressionParserException {
        boolean foundGroup;
        System.out.println("Chosen drop: " + drop.getDropValue());
        this.world = world;
        this.player = player;
        this.harvestX = harvestX;
        this.harvestY = harvestY;
        this.harvestZ = harvestZ;
        this.expressionParser.world = world;
        this.expressionParser.player = player;
        this.expressionParser.harvestX = harvestX;
        this.expressionParser.harvestY = harvestY;
        this.expressionParser.harvestZ = harvestZ;
        String[] allDrops = new String[]{drop.getDropValue()};
        do {
            foundGroup = false;
            int count = 0;
            while (count < allDrops.length) {
                if (allDrops[count].startsWith("group")) {
                    foundGroup = true;
                    String[] groupContents = this.getGroupContents(allDrops[count], ';');
                    allDrops = this.addToArray(allDrops, groupContents, count);
                    count += groupContents.length;
                    continue;
                }
                ++count;
            }
        } while (foundGroup);
        return this.makeDropsFromArray(allDrops);
    }

    public String[] getGroupContents(String line, char regex) throws ExpressionParser.ExpressionParserException {
        String bracketOpen = line.startsWith("[") ? "[" : "(";
        String bracketClose = line.endsWith("]") ? "]" : ")";
        String lineOfContents = line.substring(line.indexOf(bracketOpen) + 1, line.lastIndexOf(bracketClose));
        String[] groupContents = LuckyFunction.splitBracketString(lineOfContents, regex);
        if (line.startsWith("group:")) {
            int amountToUse = this.expressionParser.getInteger(line.substring(line.indexOf(":") + 1, line.indexOf(bracketOpen)));
            groupContents = this.decreaseDropAmount(groupContents, amountToUse);
        }
        return groupContents;
    }

    public String[] decreaseDropAmount(String[] allDrops, int amountToUse) {
        Random random = new Random();
        boolean[] useDrop = new boolean[allDrops.length];
        int count = 0;
        do {
            int dropToUse;
            if (useDrop[dropToUse = random.nextInt(allDrops.length)]) continue;
            useDrop[dropToUse] = true;
            ++count;
        } while (count != amountToUse);
        String[] newAllDrops = new String[amountToUse];
        count = 0;
        for (int a = 0; a < allDrops.length; ++a) {
            if (!useDrop[a]) continue;
            newAllDrops[count] = allDrops[a];
            ++count;
        }
        return newAllDrops;
    }

    public String[] addToArray(String[] allDrops, String[] groupContents, int pos) {
        String[] newAllDrops = new String[allDrops.length - 1 + groupContents.length];
        int count = 0;
        for (int a = 0; a < allDrops.length; ++a) {
            if (a == pos) {
                String[] arr$ = groupContents;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    String groupContent;
                    newAllDrops[count] = groupContent = arr$[i$];
                    ++count;
                }
                continue;
            }
            newAllDrops[count] = allDrops[a];
            ++count;
        }
        return newAllDrops;
    }

    public LuckyDrop[] makeDropsFromArray(String[] line) throws ExpressionParser.ExpressionParserException {
        LuckyDrop[] dropList = new LuckyDrop[1024];
        int count = 0;
        for (String element : line) {
            LuckyDrop defaultDrop = this.setDropProperties(element);
            int amount = defaultDrop.getAmount();
            for (int b = 0; b < amount; ++b) {
                dropList[count] = defaultDrop.getReinitialize() ? this.setDropProperties(element) : defaultDrop;
                dropList[count].setAmount(1);
                ++count;
            }
        }
        return dropList;
    }

    public LuckyDrop setDropProperties(String line) throws ExpressionParser.ExpressionParserException {
        LuckyDrop drop = new LuckyDrop();
        String[] splitLine = LuckyFunction.splitBracketString(line, ',');
        drop.setPosX(this.harvestX);
        drop.setPosY(this.harvestY);
        drop.setPosZ(this.harvestZ);
        boolean scatter = false;
        int scatterMin = 0;
        int scatterMax = 0;
        boolean adjustHeight = false;
        int adjustHeightAmount = 0;
        for (String element : splitLine) {
            String name = element.substring(0, element.indexOf("=")).trim();
            String value = element.substring(element.indexOf("=") + 1).trim();
            if ((value.startsWith("(") && value.endsWith(")") || value.startsWith("[") && value.endsWith("]") || value.startsWith("{") && value.endsWith("}")) && !name.equals("NBTTag")) {
                name = name.substring(1, name.length() - 1);
            }
            if (name.equals("type")) {
                drop.setType(this.expressionParser.getString(value));
            }
            if (name.equals("ID")) {
                drop.setId(this.expressionParser.getString(value));
            }
            if (name.equals("damage")) {
                drop.setDamage(this.expressionParser.getInteger(value));
            }
            if (name.equals("amount")) {
                drop.setAmount(this.expressionParser.getInteger(value));
            }
            if (name.equals("reinitialize")) {
                drop.setReinitialize(this.expressionParser.getBoolean(value));
            }
            if (name.equals("posX")) {
                drop.setPosX(this.expressionParser.getInteger(value));
            }
            if (name.equals("posY")) {
                drop.setPosY(this.expressionParser.getInteger(value));
            }
            if (name.equals("posZ")) {
                drop.setPosZ(this.expressionParser.getInteger(value));
            }
            if (name.equals("displayCommandOutput")) {
                drop.setDisplayCommandOutput(this.expressionParser.getBoolean(value));
            }
            if (name.equals("commandSender")) {
                drop.setCommandSender(this.expressionParser.getString(value));
            }
            if (name.equals("relativeToPlayer")) {
                drop.setPosX(MathHelper.func_76128_c((double)this.player.field_70165_t));
                drop.setPosY(MathHelper.func_76128_c((double)this.player.field_70163_u));
                drop.setPosZ(MathHelper.func_76128_c((double)this.player.field_70161_v));
            }
            if (name.equals("duration")) {
                drop.setEffectDuration(this.expressionParser.getInteger(value));
            }
            if (name.equals("adjustHeight")) {
                adjustHeight = true;
                adjustHeightAmount = Integer.valueOf(value);
            }
            if (name.equals("scatterOffset")) {
                scatter = true;
                String[] splitInt = value.split("-");
                scatterMin = this.expressionParser.getInteger(splitInt[0]);
                scatterMax = this.expressionParser.getInteger(splitInt[1]);
            }
            if (!name.equals("NBTTag")) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            if (value.startsWith("#")) {
                tagCompound = (NBTTagCompound)CustomNBTTags.getNBTTagFromString(value);
            } else {
                this.getNBTTag((NBTBase)tagCompound, value);
            }
            drop.setNBTTag(tagCompound);
        }
        if (scatter) {
            int passes = 0;
            while (true) {
                Random random = new Random();
                int currXOffset = scatterMax - random.nextInt(scatterMax * 2 + 1);
                int currZOffset = scatterMax - random.nextInt(scatterMax * 2 + 1);
                if (currXOffset >= scatterMin || currXOffset <= scatterMin * -1 || currZOffset >= scatterMin || currZOffset <= scatterMin * -1) {
                    drop.setPosX(drop.getPosX() + currXOffset);
                    drop.setPosZ(drop.getPosZ() + currZOffset);
                    break;
                }
                if (passes > 1000) break;
                ++passes;
            }
        }
        if (adjustHeight) {
            boolean wasHeightAdjusted = false;
            int newPosY = drop.getPosY();
            int airCount = 0;
            for (int a = drop.getPosY(); a < drop.getPosY() + 16; ++a) {
                if (this.world.func_147439_a(drop.getPosX(), a, drop.getPosZ()).func_149662_c()) {
                    airCount = 0;
                    newPosY = a + 1;
                } else {
                    ++airCount;
                }
                if (airCount != adjustHeightAmount) continue;
                drop.setPosY(newPosY);
                break;
            }
        }
        return drop;
    }

    public void getNBTTag(NBTBase currTag, String tagLine) throws ExpressionParser.ExpressionParserException {
        String[] tagContents;
        for (String tagContent : tagContents = this.getGroupContents(tagLine, ',')) {
            String tagValue;
            String tagName = currTag instanceof NBTTagCompound ? tagContent.substring(0, tagContent.indexOf("=")) : "";
            String string = tagValue = currTag instanceof NBTTagCompound ? tagContent.substring(tagContent.indexOf("=") + 1) : tagContent;
            if (tagValue.startsWith("{") && tagValue.endsWith("}")) {
                tagValue = tagValue.substring(1, tagValue.length() - 1);
            }
            if (tagName.equals("id")) {
                try {
                    Item item = (Item)Item.field_150901_e.func_82594_a(this.expressionParser.getString(tagValue));
                    if (item != null) {
                        this.setTagValue(currTag, tagName, Item.field_150901_e.func_148757_b((Object)item));
                        continue;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (tagValue.startsWith("#") && CustomNBTTags.getNBTTagFromString(tagValue) != null) {
                this.setTagValue(currTag, tagName, CustomNBTTags.getNBTTagFromString(tagValue));
                continue;
            }
            if (tagValue.startsWith("(") && tagValue.endsWith(")")) {
                NBTTagCompound tagCompound = new NBTTagCompound();
                this.getNBTTag((NBTBase)tagCompound, tagValue);
                this.setTagValue(currTag, tagName, tagCompound);
                continue;
            }
            if (tagValue.startsWith("[") && tagValue.endsWith("]")) {
                NBTTagList tagList = new NBTTagList();
                this.getNBTTag((NBTBase)tagList, tagValue);
                this.setTagValue(currTag, tagName, tagList);
                continue;
            }
            if (tagValue.startsWith("\"") && tagValue.endsWith("\"")) {
                this.setTagValue(currTag, tagName, this.expressionParser.getString(tagValue));
                continue;
            }
            try {
                if (tagValue.endsWith("d") || tagValue.endsWith("D")) {
                    this.setTagValue(currTag, tagName, this.expressionParser.getDouble(tagValue.substring(0, tagValue.length() - 1)));
                    continue;
                }
                if (tagValue.endsWith("f") || tagValue.endsWith("F")) {
                    this.setTagValue(currTag, tagName, Float.valueOf(this.expressionParser.getFloat(tagValue.substring(0, tagValue.length() - 1))));
                    continue;
                }
                if (tagValue.endsWith("s") || tagValue.endsWith("S")) {
                    this.setTagValue(currTag, tagName, this.expressionParser.getShort(tagValue.substring(0, tagValue.length() - 1)));
                    continue;
                }
                if (tagValue.endsWith("b") || tagValue.endsWith("B")) {
                    this.setTagValue(currTag, tagName, this.expressionParser.getByte(tagValue.substring(0, tagValue.length() - 1)));
                    continue;
                }
                throw this.expressionParser.new ExpressionParser.ExpressionParserException();
            }
            catch (ExpressionParser.ExpressionParserException e0) {
                try {
                    this.setTagValue(currTag, tagName, this.expressionParser.getInteger(tagValue));
                }
                catch (ExpressionParser.ExpressionParserException e1) {
                    try {
                        this.setTagValue(currTag, tagName, this.expressionParser.getBoolean(tagValue));
                    }
                    catch (ExpressionParser.ExpressionParserException e2) {
                        try {
                            String[] valuesString = tagValue.split(":");
                            if (valuesString.length == 0) {
                                throw this.expressionParser.new ExpressionParser.ExpressionParserException();
                            }
                            boolean type = false;
                            if (valuesString[0].endsWith("b") || valuesString[0].endsWith("B")) {
                                type = true;
                            }
                            int[] valuesInt = new int[valuesString.length];
                            byte[] valuesByte = new byte[valuesString.length];
                            for (int b = 0; b < valuesString.length; ++b) {
                                if (!type) {
                                    valuesInt[b] = this.expressionParser.getInteger(valuesString[b]);
                                    continue;
                                }
                                if (valuesString[b].endsWith("b") || valuesString[0].endsWith("B")) {
                                    valuesString[b] = valuesString[b].substring(0, valuesString[b].length() - 1);
                                }
                                valuesByte[b] = this.expressionParser.getByte(valuesString[b]);
                            }
                            if (!type) {
                                if (valuesInt.length == 0) {
                                    throw this.expressionParser.new ExpressionParser.ExpressionParserException();
                                }
                                this.setTagValue(currTag, tagName, valuesInt);
                                continue;
                            }
                            if (valuesByte.length == 0) {
                                throw this.expressionParser.new ExpressionParser.ExpressionParserException();
                            }
                            this.setTagValue(currTag, tagName, valuesByte);
                        }
                        catch (ExpressionParser.ExpressionParserException e3) {
                            this.setTagValue(currTag, tagName, this.expressionParser.getString(tagValue));
                        }
                    }
                }
            }
        }
    }

    public void setTagValue(NBTBase currTag, String tagName, Object tagValue) {
        if (currTag instanceof NBTTagCompound) {
            NBTTagCompound tagCompound = (NBTTagCompound)currTag;
            if (tagValue instanceof String) {
                tagCompound.func_74778_a(tagName, (String)tagValue);
            }
            if (tagValue instanceof Boolean) {
                tagCompound.func_74757_a(tagName, ((Boolean)tagValue).booleanValue());
            }
            if (tagValue instanceof Integer) {
                tagCompound.func_74768_a(tagName, ((Integer)tagValue).intValue());
            }
            if (tagValue instanceof Float) {
                tagCompound.func_74776_a(tagName, ((Float)tagValue).floatValue());
            }
            if (tagValue instanceof Double) {
                tagCompound.func_74780_a(tagName, ((Double)tagValue).doubleValue());
            }
            if (tagValue instanceof Short) {
                tagCompound.func_74777_a(tagName, ((Short)tagValue).shortValue());
            }
            if (tagValue instanceof Byte) {
                tagCompound.func_74774_a(tagName, ((Byte)tagValue).byteValue());
            }
            if (tagValue instanceof int[]) {
                tagCompound.func_74783_a(tagName, (int[])tagValue);
            }
            if (tagValue instanceof byte[]) {
                tagCompound.func_74773_a(tagName, (byte[])tagValue);
            }
            if (tagValue instanceof NBTTagCompound) {
                tagCompound.func_74782_a(tagName, (NBTBase)((NBTTagCompound)tagValue));
            }
            if (tagValue instanceof NBTTagList) {
                tagCompound.func_74782_a(tagName, (NBTBase)((NBTTagList)tagValue));
            }
        }
        if (currTag instanceof NBTTagList) {
            NBTTagList tagList = (NBTTagList)currTag;
            if (tagValue instanceof String) {
                tagList.func_74742_a((NBTBase)new NBTTagString((String)tagValue));
            }
            if (tagValue instanceof Integer) {
                tagList.func_74742_a((NBTBase)new NBTTagInt(((Integer)tagValue).intValue()));
            }
            if (tagValue instanceof Float) {
                tagList.func_74742_a((NBTBase)new NBTTagFloat(((Float)tagValue).floatValue()));
            }
            if (tagValue instanceof Double) {
                tagList.func_74742_a((NBTBase)new NBTTagDouble(((Double)tagValue).doubleValue()));
            }
            if (tagValue instanceof Short) {
                tagList.func_74742_a((NBTBase)new NBTTagShort(((Short)tagValue).shortValue()));
            }
            if (tagValue instanceof Byte) {
                tagList.func_74742_a((NBTBase)new NBTTagByte(((Byte)tagValue).byteValue()));
            }
            if (tagValue instanceof int[]) {
                tagList.func_74742_a((NBTBase)new NBTTagIntArray((int[])tagValue));
            }
            if (tagValue instanceof byte[]) {
                tagList.func_74742_a((NBTBase)new NBTTagByteArray((byte[])tagValue));
            }
            if (tagValue instanceof NBTTagCompound) {
                tagList.func_74742_a((NBTBase)((NBTTagCompound)tagValue));
            }
            if (tagValue instanceof NBTTagList) {
                tagList.func_74742_a((NBTBase)((NBTTagList)tagValue));
            }
        }
    }
}

