/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.util;

import java.util.Random;
import mod.lucky.Lucky;
import mod.lucky.tileentity.TileEntityLuckyBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class StructureUtil {
    public static int getEdgeDistance(int firstPos, int newPos) {
        int distance = newPos - firstPos;
        if (distance < 0) {
            distance *= -1;
        }
        return distance;
    }

    public static boolean isEdgeSingleSide(int firstPos, int newPos, int edgeDistance) {
        int distance = newPos - firstPos;
        if (distance < 0) {
            distance *= -1;
        }
        return distance == edgeDistance;
    }

    public static boolean isEdge(int firstPosX, int firstPosZ, int newPosX, int newPosZ, int edgeDistance) {
        if (StructureUtil.getEdgeDistance(firstPosX, newPosX) == edgeDistance && StructureUtil.getEdgeDistance(firstPosZ, newPosZ) <= edgeDistance) {
            return true;
        }
        return StructureUtil.getEdgeDistance(firstPosZ, newPosZ) == edgeDistance && StructureUtil.getEdgeDistance(firstPosX, newPosX) <= edgeDistance;
    }

    public static boolean isCenterEdge(int firstPosX, int firstPosZ, int newPosX, int newPosZ, int edgeDistance) {
        if (StructureUtil.getEdgeDistance(firstPosX, newPosX) == edgeDistance && StructureUtil.getEdgeDistance(firstPosZ, newPosZ) == 0) {
            return true;
        }
        return StructureUtil.getEdgeDistance(firstPosZ, newPosZ) == edgeDistance && StructureUtil.getEdgeDistance(firstPosX, newPosX) == 0;
    }

    public static boolean isCorner(int firstPosX, int firstPosZ, int newPosX, int newPosZ, int cornerDistance) {
        return StructureUtil.getEdgeDistance(firstPosX, newPosX) == cornerDistance && StructureUtil.getEdgeDistance(firstPosZ, newPosZ) == cornerDistance;
    }

    public static void fill(World world, int posX, int posY, int posZ, int length, int height, int width, Block block) {
        for (int x = posX; x < posX + length; ++x) {
            for (int y = posY; y < posY + height; ++y) {
                for (int z = posZ; z < posZ + width; ++z) {
                    StructureUtil.setBlock(world, x, y, z, block);
                }
            }
        }
    }

    public static void fill(World world, int posX, int posY, int posZ, int length, int height, int width, Block block, int meta) {
        for (int x = posX; x < posX + length; ++x) {
            for (int y = posY; y < posY + height; ++y) {
                for (int z = posZ; z < posZ + width; ++z) {
                    StructureUtil.setBlock(world, x, y, z, block, meta);
                }
            }
        }
    }

    public static void fillHollow(World world, int posX, int posY, int posZ, int length, int height, int width, Block block) {
        for (int x = posX; x < posX + length; ++x) {
            for (int y = posY; y < posY + height; ++y) {
                for (int z = posZ; z < posZ + width; ++z) {
                    if (x != posX && x != posX + length - 1 && y != posY && y != posY + height - 1 && z != posZ && z != posZ + width - 1) continue;
                    StructureUtil.setBlock(world, x, y, z, block);
                }
            }
        }
    }

    public static void fillHollow(World world, int posX, int posY, int posZ, int length, int height, int width, Block block, int meta) {
        for (int x = posX; x < posX + length; ++x) {
            for (int y = posY; y < posY + height; ++y) {
                for (int z = posZ; z < posZ + width; ++z) {
                    if (x != posX && x != posX + length - 1 && y != posY && y != posY + height - 1 && z != posZ && z != posZ + width - 1) continue;
                    StructureUtil.setBlock(world, x, y, z, block, meta);
                }
            }
        }
    }

    public static void fillPerimiter(World world, int posX, int posY, int posZ, int length, int height, int width, Block block) {
        for (int x = posX; x < posX + length; ++x) {
            for (int y = posY; y < posY + height; ++y) {
                for (int z = posZ; z < posZ + width; ++z) {
                    if (x != posX && x != posX + length - 1 && z != posZ && z != posZ + width - 1) continue;
                    StructureUtil.setBlock(world, x, y, z, block);
                }
            }
        }
    }

    public static void fillPerimiter(World world, int posX, int posY, int posZ, int length, int height, int width, Block block, int meta) {
        for (int x = posX; x < posX + length; ++x) {
            for (int y = posY; y < posY + height; ++y) {
                for (int z = posZ; z < posZ + width; ++z) {
                    if (x != posX && x != posX + length - 1 && z != posZ && z != posZ + width - 1) continue;
                    StructureUtil.setBlock(world, x, y, z, block, meta);
                }
            }
        }
    }

    public static void fillPerimiterStairs(World world, int posX, int posY, int posZ, int length, int height, int width, BlockStairs block) {
        for (int y = posY; y <= posY + height - 1; ++y) {
            StructureUtil.fill(world, posX + 1, y, posZ, length - 1, 1, 1, (Block)block, 2);
            StructureUtil.fill(world, posX + 1, y, posZ + width - 1, length - 1, 1, 1, (Block)block, 3);
            StructureUtil.fill(world, posX, y, posZ, 1, 1, width, (Block)block, 0);
            StructureUtil.fill(world, posX + length - 1, y, posZ, 1, 1, width, (Block)block, 1);
        }
    }

    public static void fillCorners(World world, int posX, int posY, int posZ, int length, int height, int width, Block block) {
        for (int x = posX; x < posX + length; ++x) {
            for (int y = posY; y < posY + height; ++y) {
                for (int z = posZ; z < posZ + width; ++z) {
                    if (x != posX && x != posX + length - 1 || z != posZ && z != posZ + width - 1) continue;
                    StructureUtil.setBlock(world, x, y, z, block);
                }
            }
        }
    }

    public static void fillCorners(World world, int posX, int posY, int posZ, int length, int height, int width, Block block, int meta) {
        for (int x = posX; x < posX + length; ++x) {
            for (int y = posY; y < posY + height; ++y) {
                for (int z = posZ; z < posZ + width; ++z) {
                    if (x != posX && x != posX + length - 1 || z != posZ && z != posZ + width - 1) continue;
                    StructureUtil.setBlock(world, x, y, z, block, meta);
                }
            }
        }
    }

    public static void makeSign(World world, int posX, int posY, int posZ, Block block, int meta, String[] text) {
        StructureUtil.setBlock(world, posX, posY, posZ, block, meta);
        StructureUtil.setBlock(world, posX, posY + 1, posZ, Blocks.field_150350_a);
        TileEntitySign signEntity = new TileEntitySign();
        for (int a = 0; a < 4; ++a) {
            signEntity.field_145915_a[a] = text[a];
        }
        world.func_147455_a(posX, posY, posZ, (TileEntity)signEntity);
    }

    public static int getSurfacePosY(World world, int posX, int posY, int posZ) {
        int newPosY = posY;
        boolean canAdjust = false;
        Block currBlock = null;
        Block blockAbove = null;
        do {
            if ((currBlock = world.func_147439_a(posX, newPosY, posZ)) != null && blockAbove != null && (currBlock.func_149662_c() && currBlock != Blocks.field_150362_t || currBlock == Blocks.field_150432_aD || currBlock == Blocks.field_150355_j || currBlock == Blocks.field_150358_i || currBlock == Blocks.field_150353_l || currBlock == Blocks.field_150356_k) && !blockAbove.func_149662_c()) {
                canAdjust = true;
                break;
            }
            blockAbove = currBlock;
        } while (--newPosY > 0);
        return !canAdjust ? -1 : ++newPosY;
    }

    public static boolean setBlock(World world, int posX, int posY, int posZ, Block block) {
        try {
            world.func_147465_d(posX, posY, posZ, block, 0, 3);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean setLuckyBlock(World world, int posX, int posY, int posZ, int luck) {
        try {
            world.func_147465_d(posX, posY, posZ, Lucky.lucky_block, 0, 3);
            if (luck != 0) {
                TileEntityLuckyBlock tileEntityLuck = new TileEntityLuckyBlock();
                tileEntityLuck.setLuck(luck);
                tileEntityLuck.func_70296_d();
                world.func_147455_a(posX, posY, posZ, (TileEntity)tileEntityLuck);
                world.func_147471_g(posX, posY, posZ);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean setRandomLuckyBlock(World world, Random random, int posX, int posY, int posZ) {
        try {
            world.func_147465_d(posX, posY, posZ, Lucky.lucky_block, 0, 3);
            int luck = MathHelper.func_76136_a((Random)random, (int)-100, (int)100);
            if (luck != 0) {
                TileEntityLuckyBlock tileEntityLuck = new TileEntityLuckyBlock();
                tileEntityLuck.setLuck(luck);
                tileEntityLuck.func_70296_d();
                world.func_147455_a(posX, posY, posZ, (TileEntity)tileEntityLuck);
                world.func_147471_g(posX, posY, posZ);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean setBlock(World world, int posX, int posY, int posZ, Block block, int meta) {
        try {
            world.func_147465_d(posX, posY, posZ, block, meta, 3);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean setBlockMeta(World world, int posX, int posY, int posZ, int meta) {
        try {
            world.func_72921_c(posX, posY, posZ, meta, 3);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

