/*
 * Decompiled with CFR 0.152.
 */
package sobiohazardous.mods.ec.util;

import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.IGrowable;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import sobiohazardous.mods.ec.lib.ECBlocks;

public class ECUtil {
    public static String getTexture(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null!");
        }
        return "elementalcaves:" + name;
    }

    public static String position(String message, int x, int y, int z) {
        return message + " (" + x + ";" + y + ";" + z + ")";
    }

    public static boolean freeze(World world, int x, int y, int z) {
        return ECUtil.freeze(world, x, y, z, false);
    }

    public static boolean freeze(World world, int x, int y, int z, boolean flag) {
        Block block = world.func_147439_a(x, y, z);
        if (block instanceof BlockBush) {
            world.func_147449_b(x, y, z, Blocks.field_150431_aC);
            flag = true;
        } else if (block instanceof BlockLeavesBase) {
            world.func_147449_b(x, y, z, Blocks.field_150433_aE);
            flag = true;
        } else if (block == Blocks.field_150433_aE || block == Blocks.field_150440_ba || block == Blocks.field_150423_aK || block == Blocks.field_150434_aF || block == Blocks.field_150419_aX || block == Blocks.field_150420_aW) {
            world.func_147449_b(x, y, z, Blocks.field_150432_aD);
            flag = true;
        } else if (block == Blocks.field_150432_aD) {
            world.func_147449_b(x, y, z, Blocks.field_150403_cj);
            flag = true;
        } else if (block == Blocks.field_150424_aL) {
            world.func_147449_b(x, y, z, Blocks.field_150347_e);
            flag = true;
        } else if (block == Blocks.field_150377_bs) {
            world.func_147465_d(x, y, z, ECBlocks.glacierRock, 1, 3);
            flag = true;
        } else if (block == ECBlocks.moltenstone) {
            int metadata = world.func_72805_g(x, y, z);
            if (metadata == 0) {
                world.func_147465_d(x, y, z, ECBlocks.moltenstone, 1, 3);
                flag = true;
            } else if (metadata == 1) {
                world.func_147449_b(x, y, z, Blocks.field_150348_b);
                flag = true;
            }
        } else if (block == Blocks.field_150480_ab) {
            world.func_147468_f(x, y, z);
            flag = true;
        } else if (block == Blocks.field_150353_l) {
            world.func_147449_b(x, y, z, Blocks.field_150343_Z);
            flag = true;
        } else if (block == Blocks.field_150355_j) {
            world.func_147449_b(x, y, z, Blocks.field_150432_aD);
            flag = true;
        } else if (block == ECBlocks.moltenstone && world.func_72805_g(x, y, z) == 0) {
            world.func_147465_d(x, y, z, ECBlocks.moltenstone, 1, 3);
        } else if (block == ECBlocks.moltenstone && world.func_72805_g(x, y, z) == 1) {
            world.func_147465_d(x, y, z, Blocks.field_150348_b, 0, 3);
        }
        if (flag) {
            world.func_72926_e(2001, x, y, z, 80);
        }
        return flag;
    }

    public static boolean melt(World world, int x, int y, int z) {
        return ECUtil.melt(world, x, y, z, false);
    }

    public static boolean melt(World world, int x, int y, int z, boolean flag) {
        Block block = world.func_147439_a(x, y, z);
        if (block.getFlammability((IBlockAccess)world, x, y, z, ForgeDirection.NORTH) > 1) {
            world.func_147449_b(x, y, z, (Block)Blocks.field_150480_ab);
            flag = true;
        } else if (block == Blocks.field_150377_bs) {
            world.func_147465_d(x, y, z, ECBlocks.moltenstone, 1, 3);
            flag = true;
        } else if (block == Blocks.field_150348_b || block == Blocks.field_150446_ar || block == Blocks.field_150390_bg) {
            world.func_147465_d(x, y, z, (Block)Blocks.field_150356_k, 15, 3);
            flag = true;
        } else if (block == Blocks.field_150347_e || block == Blocks.field_150341_Y || block == Blocks.field_150417_aV || block == Blocks.field_150351_n) {
            world.func_147449_b(x, y, z, Blocks.field_150348_b);
            flag = true;
        } else if (block == Blocks.field_150322_A) {
            if (world.func_72805_g(x, y, z) != 1) {
                world.func_72921_c(x, y, z, 1, 3);
            } else {
                world.func_147465_d(x, y, z, (Block)Blocks.field_150356_k, 15, 3);
            }
            flag = true;
        } else if (block == Blocks.field_150463_bK) {
            world.func_147465_d(x, y, z, (Block)Blocks.field_150356_k, 18, 3);
            flag = true;
        } else if (block == Blocks.field_150458_ak || block == Blocks.field_150349_c || block == Blocks.field_150349_c) {
            world.func_147449_b(x, y, z, Blocks.field_150346_d);
            flag = true;
        } else if (block == Blocks.field_150346_d) {
            if (world.func_72805_g(x, y, z) != 0) {
                world.func_72921_c(x, y, z, 0, 3);
                flag = true;
            }
        } else if (block == Blocks.field_150354_m) {
            world.func_147449_b(x, y, z, Blocks.field_150359_w);
            flag = true;
        } else if (block == Blocks.field_150333_U || block == Blocks.field_150334_T) {
            int metadata = world.func_72805_g(x, y, z);
            int type = metadata & 7;
            if (type == 0 || type == 1 || type == 5) {
                world.func_147465_d(x, y, z, (Block)Blocks.field_150356_k, 15, 3);
                flag = true;
            } else if (type == 3) {
                world.func_72921_c(x, y, z, metadata > 7 ? 8 : 0, 3);
                flag = true;
            }
        } else if (block == Blocks.field_150343_Z || block == Blocks.field_150424_aL) {
            world.func_147449_b(x, y, z, Blocks.field_150353_l);
            flag = true;
        } else if (block == Blocks.field_150403_cj) {
            world.func_147449_b(x, y, z, Blocks.field_150432_aD);
            flag = true;
        } else if (block == Blocks.field_150432_aD) {
            world.func_147449_b(x, y, z, Blocks.field_150433_aE);
            flag = true;
        } else if (block == Blocks.field_150433_aE) {
            world.func_147449_b(x, y, z, Blocks.field_150355_j);
            flag = true;
        } else if (block == Blocks.field_150431_aC) {
            world.func_147468_f(x, y, z);
            flag = true;
        }
        if (flag) {
            world.func_72926_e(2004, x, y, z, 0);
            world.func_72926_e(2004, x, y, z, 0);
        }
        return flag;
    }

    public static boolean grow(World world, int x, int y, int z) {
        return ECUtil.grow(world, x, y, z, false);
    }

    public static boolean grow(World world, int x, int y, int z, boolean flag) {
        IGrowable igrowable;
        Block block = world.func_147439_a(x, y, z);
        if (block == Blocks.field_150346_d) {
            if (world.func_72805_g(x, y, z) == 1) {
                world.func_147449_b(x, y, z, (Block)Blocks.field_150391_bh);
            } else {
                world.func_147449_b(x, y, z, (Block)Blocks.field_150349_c);
            }
            flag = true;
        } else if (block == Blocks.field_150347_e) {
            world.func_147449_b(x, y, z, Blocks.field_150341_Y);
            flag = true;
        } else if (block == Blocks.field_150417_aV) {
            if (world.func_72805_g(x, y, z) == 0) {
                world.func_72921_c(x, y, z, 2, 3);
                flag = true;
            }
        } else if (block == Blocks.field_150463_bK) {
            if (world.func_72805_g(x, y, z) == 0) {
                world.func_72921_c(x, y, z, 1, 3);
                flag = true;
            }
        } else if (block == Blocks.field_150354_m) {
            world.func_147449_b(x, y, z, Blocks.field_150435_aG);
            flag = true;
        } else if (block == Blocks.field_150435_aG) {
            world.func_147449_b(x, y, z, Blocks.field_150346_d);
            flag = true;
        } else if (block == Blocks.field_150434_aF || block == Blocks.field_150436_aH) {
            world.func_147449_b(x, y + 1, z, block);
            world.func_147449_b(x, y + 2, z, block);
            flag = true;
        } else if (block instanceof IGrowable && !(block instanceof BlockDoublePlant) && (igrowable = (IGrowable)block).func_149852_a(world, world.field_73012_v, x, y, z)) {
            igrowable.func_149853_b(world, world.field_73012_v, x, y, z);
            flag = true;
        }
        if (flag) {
            world.func_72926_e(2005, x, y, z, 0);
            world.func_72926_e(2001, x, y, z, 18);
        }
        return flag;
    }
}

