/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biomes;

import biomesoplenty.api.BOPBlockHelper;
import biomesoplenty.common.biomes.BOPBiome;
import biomesoplenty.common.configuration.BOPConfigurationMisc;
import biomesoplenty.common.entities.EntityJungleSpider;
import biomesoplenty.common.world.features.WorldGenBOPDoubleFlora;
import biomesoplenty.common.world.features.WorldGenBOPFlora;
import biomesoplenty.common.world.features.WorldGenBOPTallGrass;
import biomesoplenty.common.world.features.trees.WorldGenPalmTree1;
import biomesoplenty.common.world.features.trees.WorldGenTropicsShrub;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenShrub;

public class BiomeGenTropics
extends BOPBiome {
    private static final BiomeGenBase.Height biomeHeight = new BiomeGenBase.Height(0.0f, 0.4f);

    public BiomeGenTropics(int id) {
        super(id);
        this.func_150570_a(biomeHeight);
        this.func_76739_b(2211330);
        this.func_76732_a(2.0f, 2.0f);
        this.field_76762_K.clear();
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityJungleSpider.class, 12, 6, 6));
        this.field_76760_I.field_76832_z = 12;
        this.field_76760_I.field_76803_B = 7;
        this.field_76760_I.field_76802_A = 10;
        this.field_76760_I.field_76801_G = 50;
        this.field_76760_I.field_76805_H = 50;
        this.bopWorldFeatures.setFeature("bopFlowersPerChunk", 30);
        this.bopWorldFeatures.setFeature("shrubsPerChunk", 4);
        this.bopWorldFeatures.setFeature("leafPilesPerChunk", 10);
        this.bopWorldFeatures.setFeature("seaweedPerChunk", 10);
        this.bopWorldFeatures.setFeature("generatePumpkins", false);
        this.bopWorldFeatures.setFeature("bopGrassPerChunk", 7);
        this.bopWorldFeatures.weightedFlowerGen.put(new WorldGenBOPFlora(BOPBlockHelper.get("flowers"), 9), 8);
        this.bopWorldFeatures.weightedFlowerGen.put(new WorldGenBOPFlora(BOPBlockHelper.get("flowers"), 5), 10);
        this.bopWorldFeatures.weightedFlowerGen.put(new WorldGenBOPFlora(BOPBlockHelper.get("flowers2"), 0), 15);
        this.bopWorldFeatures.weightedFlowerGen.put(new WorldGenBOPFlora((Block)Blocks.field_150328_O, 1), 7);
        this.bopWorldFeatures.weightedFlowerGen.put(new WorldGenBOPDoubleFlora(4, 5), 6);
        this.bopWorldFeatures.weightedFlowerGen.put(new WorldGenBOPDoubleFlora(0, 3), 2);
        this.bopWorldFeatures.weightedGrassGen.put(new WorldGenBOPTallGrass(BOPBlockHelper.get("foliage"), 10), 0.5);
        this.bopWorldFeatures.weightedGrassGen.put(new WorldGenBOPTallGrass(BOPBlockHelper.get("foliage"), 11), 0.5);
        this.bopWorldFeatures.weightedGrassGen.put(new WorldGenBOPTallGrass((Block)Blocks.field_150329_H, 1), 1.0);
        this.bopWorldFeatures.weightedGrassGen.put(new WorldGenBOPDoubleFlora(3), 0.25);
    }

    public WorldGenAbstractTree func_150567_a(Random random) {
        return random.nextInt(2) == 0 ? new WorldGenPalmTree1() : (random.nextInt(2) == 0 ? new WorldGenTropicsShrub() : new WorldGenShrub(0, 0));
    }

    @Override
    public void func_76728_a(World world, Random random, int chunkX, int chunkZ) {
        super.func_76728_a(world, random, chunkX, chunkZ);
        int var5 = 12 + random.nextInt(6);
        for (int var6 = 0; var6 < var5; ++var6) {
            int z;
            int y;
            int x = chunkX + random.nextInt(16);
            Block block = world.func_147439_a(x, y = random.nextInt(28) + 4, z = chunkZ + random.nextInt(16));
            if (block == null || !block.isReplaceableOreGen(world, x, y, z, Blocks.field_150348_b)) continue;
            world.func_147465_d(x, y, z, BOPBlockHelper.get("gemOre"), 6, 2);
        }
    }

    public int func_76731_a(float par1) {
        if (BOPConfigurationMisc.skyColors) {
            return 507391;
        }
        return super.func_76731_a(par1);
    }
}

