/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.items;

import biomesoplenty.BiomesOPlenty;
import biomesoplenty.common.network.packet.PacketBiomePosition;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;

public class ItemBiomeFinder
extends Item {
    public IIcon[] biomeRadarIcons = new IIcon[32];
    private double[] currentAngles = new double[BiomeGenBase.func_150565_n().length];
    private double[] angleDeltas = new double[BiomeGenBase.func_150565_n().length];

    public ItemBiomeFinder() {
        this.func_77625_d(1);
        this.func_77637_a(BiomesOPlenty.tabBiomesOPlenty);
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        BiomeGenBase biomeToFind;
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        int biomeIDToFind = itemStack.func_77978_p().func_74762_e("biomeIDToFind");
        if (!world.field_72995_K && !itemStack.func_77978_p().func_74767_n("foundBiome") && (biomeToFind = BiomeGenBase.func_150565_n()[biomeIDToFind]) != null) {
            int radius = 256;
            WorldChunkManager chunkManager = world.func_72959_q();
            ChunkPosition finalFoundPosition1 = null;
            int playerX = MathHelper.func_76128_c((double)player.field_70165_t);
            int playerZ = MathHelper.func_76128_c((double)player.field_70161_v);
            block0: for (int x = 10; x <= 10; ++x) {
                for (int z = -10; z <= 10; ++z) {
                    ChunkPosition foundPosition = chunkManager.func_150795_a(playerX + x * 512, playerZ + z * 512, radius, Arrays.asList(biomeToFind), world.field_73012_v);
                    if (foundPosition == null || world.func_72807_a(foundPosition.field_151329_a, foundPosition.field_151328_c) != biomeToFind) continue;
                    finalFoundPosition1 = foundPosition;
                    continue block0;
                }
            }
            ChunkPosition finalFoundPosition2 = null;
            block2: for (int x = -10; x <= 10; ++x) {
                for (int z = 10; z >= -10; --z) {
                    ChunkPosition foundPosition = chunkManager.func_150795_a(playerX + x * 512, playerZ + z * 512, radius, Arrays.asList(biomeToFind), world.field_73012_v);
                    if (foundPosition == null || world.func_72807_a(foundPosition.field_151329_a, foundPosition.field_151328_c) != biomeToFind) continue;
                    finalFoundPosition2 = foundPosition;
                    continue block2;
                }
            }
            ChunkPosition biomePosition = null;
            if (finalFoundPosition1 != null && finalFoundPosition2 != null) {
                int f1X = finalFoundPosition1.field_151329_a;
                int f1Z = finalFoundPosition1.field_151328_c;
                int f2X = finalFoundPosition2.field_151329_a;
                int f2Z = finalFoundPosition2.field_151328_c;
                biomePosition = Math.sqrt(f1X * f1X + f1Z * f1Z) > Math.sqrt(f2X * f2X + f2Z * f2Z) ? finalFoundPosition2 : finalFoundPosition1;
            } else if (finalFoundPosition1 == null) {
                biomePosition = finalFoundPosition2;
            } else if (finalFoundPosition2 == null) {
                biomePosition = finalFoundPosition1;
            }
            if (biomePosition != null) {
                NBTTagCompound biomeCompound = new NBTTagCompound();
                biomeCompound.func_74768_a("x", biomePosition.field_151329_a);
                biomeCompound.func_74768_a("z", biomePosition.field_151328_c);
                itemStack.func_77978_p().func_74782_a("biomePosition", (NBTBase)biomeCompound);
                itemStack.func_77978_p().func_74757_a("foundBiome", true);
                BiomesOPlenty.packetPipeline.sendTo(new PacketBiomePosition(biomePosition.field_151329_a, biomePosition.field_151328_c, true), (EntityPlayerMP)player);
            }
        }
        return itemStack;
    }

    public void func_94581_a(IIconRegister iconRegister) {
        for (int i = 0; i < 32; ++i) {
            this.biomeRadarIcons[i] = iconRegister.func_94245_a("biomesoplenty:biomeradar/" + i);
        }
        this.field_77791_bV = iconRegister.func_94245_a("biomesoplenty:biomefinder");
    }

    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack itemStack, int renderPass) {
        NBTTagCompound stackCompound;
        Minecraft minecraft = Minecraft.func_71410_x();
        WorldClient world = minecraft.field_71441_e;
        EntityClientPlayerMP player = minecraft.field_71439_g;
        NBTTagCompound nBTTagCompound = stackCompound = itemStack != null ? itemStack.func_77978_p() : null;
        if (world != null && player != null && stackCompound != null && stackCompound.func_74764_b("biomeIDToFind") && stackCompound.func_74764_b("foundBiome")) {
            int biomeID = stackCompound.func_74762_e("biomeIDToFind");
            boolean foundBiome = stackCompound.func_74767_n("foundBiome");
            NBTTagCompound biomePositionCompound = stackCompound.func_74775_l("biomePosition");
            if (foundBiome) {
                return this.biomeRadarIcons[this.getIconIndexFacingBiome((World)world, (EntityPlayer)player, biomePositionCompound.func_74762_e("x"), biomePositionCompound.func_74762_e("z"), biomeID)];
            }
        }
        return this.field_77791_bV;
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List infoList, boolean advancedItemTooltips) {
        BiomeGenBase biome;
        if (itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("biomeIDToFind") && (biome = BiomeGenBase.func_150565_n()[itemStack.func_77978_p().func_74762_e("biomeIDToFind")]) != null) {
            infoList.add("" + EnumChatFormatting.BOLD + "Target: " + EnumChatFormatting.RESET + biome.field_76791_y);
            if (itemStack.func_77978_p().func_74764_b("foundBiome")) {
                boolean foundBiome = itemStack.func_77978_p().func_74767_n("foundBiome");
                if (foundBiome) {
                    infoList.add("" + EnumChatFormatting.DARK_GREEN + EnumChatFormatting.ITALIC + "Found biome!");
                } else {
                    infoList.add("" + EnumChatFormatting.DARK_GRAY + EnumChatFormatting.ITALIC + "Right click to scan for biome");
                }
            }
        }
    }

    public int getIconIndexFacingBiome(World world, EntityPlayer player, int biomePosX, int biomePosZ, int biomeID) {
        double d6;
        double d3 = 0.0;
        if (world != null) {
            double d4 = (double)biomePosX - player.field_70165_t;
            double d5 = (double)biomePosZ - player.field_70161_v;
            player.field_70177_z = (float)((double)player.field_70177_z % 360.0);
            d3 = -(((double)player.field_70177_z - 90.0) * Math.PI / 180.0 - Math.atan2(d5, d4));
        }
        for (d6 = d3 - this.currentAngles[biomeID]; d6 < -Math.PI; d6 += Math.PI * 2) {
        }
        while (d6 >= Math.PI) {
            d6 -= Math.PI * 2;
        }
        if (d6 < -1.0) {
            d6 = -1.0;
        }
        if (d6 > 1.0) {
            d6 = 1.0;
        }
        int n = biomeID;
        this.angleDeltas[n] = this.angleDeltas[n] + d6 * 0.1;
        int n2 = biomeID;
        this.angleDeltas[n2] = this.angleDeltas[n2] * 0.8;
        int n3 = biomeID;
        this.currentAngles[n3] = this.currentAngles[n3] + this.angleDeltas[biomeID];
        int i = (int)((this.currentAngles[biomeID] / (Math.PI * 2) + 1.0) * 32.0) % 32;
        while (i < 0) {
            i = (i + 32) % 32;
        }
        return i;
    }
}

