/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.generation;

import biomesoplenty.api.BOPBlockHelper;
import biomesoplenty.common.world.features.WorldGenBOPBlob;
import biomesoplenty.common.world.features.WorldGenBOPCoral;
import biomesoplenty.common.world.features.WorldGenBOPDoubleFlora;
import biomesoplenty.common.world.features.WorldGenBOPFlora;
import biomesoplenty.common.world.features.WorldGenBOPTallGrass;
import biomesoplenty.common.world.features.WorldGenCobwebNest;
import biomesoplenty.common.world.features.WorldGenGrassSplatter;
import biomesoplenty.common.world.features.WorldGenLavaSpout;
import biomesoplenty.common.world.features.WorldGenLog;
import biomesoplenty.common.world.features.WorldGenRiverCane;
import biomesoplenty.common.world.features.WorldGenSplotches;
import biomesoplenty.common.world.features.WorldGenWasteland;
import biomesoplenty.common.world.features.WorldGenWasteland2;
import biomesoplenty.common.world.features.WorldGenWasteland3;
import biomesoplenty.common.world.features.WorldGenWasteland4;
import biomesoplenty.common.world.features.WorldGenWaterReeds;
import biomesoplenty.common.world.features.WorldGenWaterside;
import biomesoplenty.common.world.features.managers.WorldGenBOPFlowerManager;
import biomesoplenty.common.world.features.managers.WorldGenBOPGrassManager;
import biomesoplenty.common.world.forcedgenerators.LakesForcedGenerator;
import biomesoplenty.common.world.forcedgenerators.MelonForcedGenerator;
import biomesoplenty.common.world.forcedgenerators.PondForcedGenerator;
import biomesoplenty.common.world.generation.ForcedWorldFeatureBOP;
import biomesoplenty.common.world.generation.IBOPWorldGenerator;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.feature.WorldGenLiquids;
import net.minecraft.world.gen.feature.WorldGenMelon;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenFieldAssociation {
    public static HashMap<String, WorldFeature> featureMap = new HashMap();

    public static void init() {
        WorldGenFieldAssociation.associateFeatures();
        WorldGenFieldAssociation.associateFeaturesForced();
    }

    private static void associateFeatures() {
        WorldGenFieldAssociation.associateFeature("generateQuicksand", new WorldGenSplotches(BOPBlockHelper.get("mud"), 1, 24, new Block[]{Blocks.field_150349_c, Blocks.field_150346_d, Blocks.field_150354_m}));
        WorldGenFieldAssociation.associateFeature("generateCanyon", new WorldGenSplotches(BOPBlockHelper.get("redRock"), 0, 48, Blocks.field_150348_b));
        WorldGenFieldAssociation.associateFeature("generateStoneInGrass", new WorldGenSplotches(Blocks.field_150348_b, 0, 32, new Block[]{Blocks.field_150349_c, BOPBlockHelper.get("grass")}));
        WorldGenFieldAssociation.associateFeature("generateStoneInGrass2", new WorldGenSplotches(Blocks.field_150348_b, 0, 48, new Block[]{Blocks.field_150349_c, Blocks.field_150346_d}));
        WorldGenFieldAssociation.associateFeature("generateGrass", new WorldGenSplotches((Block)Blocks.field_150349_c, 0, 48, BOPBlockHelper.get("redRock")));
        WorldGenFieldAssociation.associateFeature("generateSand", new WorldGenSplotches(Blocks.field_150354_m, 0, 32, BOPBlockHelper.get("redRock")));
        WorldGenFieldAssociation.associateFeature("generateQuagmire", new WorldGenSplotches((Block)Blocks.field_150349_c, 0, 48, BOPBlockHelper.get("mud")));
        WorldGenFieldAssociation.associateFeature("generateAsh", new WorldGenSplotches(BOPBlockHelper.get("ash"), 0, 32, BOPBlockHelper.get("ashStone"), Blocks.field_150424_aL));
        WorldGenFieldAssociation.associateFeature("mudPerChunk", new WorldGenWaterside(BOPBlockHelper.get("mud"), 7, new Block[]{Blocks.field_150346_d, Blocks.field_150349_c}));
        WorldGenFieldAssociation.associateFeature("riverCanePerChunk", new WorldGenRiverCane());
        WorldGenFieldAssociation.associateFeature("shrubsPerChunk", new WorldGenBOPFlora(BOPBlockHelper.get("foliage"), 9));
        WorldGenFieldAssociation.associateFeature("bushesPerChunk", new WorldGenBOPFlora(BOPBlockHelper.get("foliage"), 4));
        WorldGenFieldAssociation.associateFeature("cloverPatchesPerChunk", new WorldGenBOPFlora(BOPBlockHelper.get("foliage"), 13, 128));
        WorldGenFieldAssociation.associateFeature("leafPilesPerChunk", new WorldGenBOPFlora(BOPBlockHelper.get("foliage"), 14, 256));
        WorldGenFieldAssociation.associateFeature("deadLeafPilesPerChunk", new WorldGenBOPFlora(BOPBlockHelper.get("foliage"), 15, 256));
        WorldGenFieldAssociation.associateFeature("lavenderPerChunk", new WorldGenBOPFlora(BOPBlockHelper.get("flowers2"), 3));
        WorldGenFieldAssociation.associateFeature("thornsPerChunk", new WorldGenBOPFlora(BOPBlockHelper.get("plants"), 5));
        WorldGenFieldAssociation.associateFeature("stalagmitesPerChunk", new WorldGenBOPTallGrass(BOPBlockHelper.get("stoneFormations"), 0));
        WorldGenFieldAssociation.associateFeature("stalactitesPerChunk", new WorldGenBOPTallGrass(BOPBlockHelper.get("stoneFormations"), 1));
        WorldGenFieldAssociation.associateFeature("desertSproutsPerChunk", new WorldGenBOPFlora(BOPBlockHelper.get("plants"), 2));
        WorldGenFieldAssociation.associateFeature("bromeliadsPerChunk", new WorldGenBOPFlora(BOPBlockHelper.get("flowers"), 12));
        WorldGenFieldAssociation.associateFeature("waterReedsPerChunk", new WorldGenWaterReeds());
        WorldGenFieldAssociation.associateFeature("seaweedPerChunk", new WorldGenBOPCoral(BOPBlockHelper.get("coral"), 8));
        WorldGenFieldAssociation.associateFeature("wildCarrotsPerChunk", new WorldGenBOPFlora(BOPBlockHelper.get("plants"), 11));
        WorldGenFieldAssociation.associateFeature("poisonIvyPerChunk", new WorldGenBOPFlora(BOPBlockHelper.get("foliage"), 7));
        WorldGenFieldAssociation.associateFeature("berryBushesPerChunk", new WorldGenBOPFlora(BOPBlockHelper.get("foliage"), 8));
        WorldGenFieldAssociation.associateFeature("portobellosPerChunk", new WorldGenBOPFlora(BOPBlockHelper.get("mushrooms"), 1));
        WorldGenFieldAssociation.associateFeature("koruPerChunk", new WorldGenBOPFlora(BOPBlockHelper.get("foliage"), 12));
        WorldGenFieldAssociation.associateFeature("toadstoolsPerChunk", new WorldGenBOPFlora(BOPBlockHelper.get("mushrooms"), 0));
        WorldGenFieldAssociation.associateFeature("blueMilksPerChunk", new WorldGenBOPFlora(BOPBlockHelper.get("mushrooms"), 2));
        WorldGenFieldAssociation.associateFeature("cattailsPerChunk", new WorldGenBOPFlora(BOPBlockHelper.get("plants"), 7));
        WorldGenFieldAssociation.associateFeature("highCattailsPerChunk", new WorldGenBOPDoubleFlora(BOPBlockHelper.get("plants"), BOPBlockHelper.get("plants"), 10, 9));
        WorldGenFieldAssociation.associateFeature("algaePerChunk", new WorldGenBOPFlora(BOPBlockHelper.get("foliage"), 0));
        WorldGenFieldAssociation.associateFeature("sproutsPerChunk", new WorldGenBOPFlora(BOPBlockHelper.get("foliage"), 5));
        WorldGenFieldAssociation.associateFeature("tinyCactiPerChunk", new WorldGenBOPFlora(BOPBlockHelper.get("plants"), 12));
        WorldGenFieldAssociation.associateFeature("oasesPerChunk", new WorldGenWaterside((Block)Blocks.field_150349_c, 7, Blocks.field_150354_m, Blocks.field_150405_ch));
        WorldGenFieldAssociation.associateFeature("minersDelightPerChunk", new WorldGenBOPFlora(BOPBlockHelper.get("flowers2"), 6));
        WorldGenFieldAssociation.associateFeature("rootsPerChunk", new WorldGenBOPFlora(BOPBlockHelper.get("plants"), 15));
        WorldGenFieldAssociation.associateFeature("grassSplatterPerChunk", new WorldGenGrassSplatter());
        WorldGenFieldAssociation.associateFeature("rockpilesPerChunk", new WorldGenBOPBlob(Blocks.field_150347_e, 0));
        WorldGenFieldAssociation.associateFeature("wastelandRockPilesPerChunk", new WorldGenBOPBlob(BOPBlockHelper.get("driedDirt"), 0));
        WorldGenFieldAssociation.associateFeature("logsPerChunk", new WorldGenLog());
        WorldGenFieldAssociation.associateFeature("lavaSpoutsPerChunk", new WorldGenLavaSpout());
        WorldGenFieldAssociation.associateFeature("cobwebsPerChunk", new WorldGenBOPFlora(Blocks.field_150321_G, 0));
        WorldGenFieldAssociation.associateFeature("cobwebNestsPerChunk", new WorldGenCobwebNest());
        WorldGenFieldAssociation.associateFeature("wasteland1PerChunk", new WorldGenWasteland());
        WorldGenFieldAssociation.associateFeature("wasteland2PerChunk", new WorldGenWasteland2());
        WorldGenFieldAssociation.associateFeature("wasteland3PerChunk", new WorldGenWasteland3());
        WorldGenFieldAssociation.associateFeature("wasteland4PerChunk", new WorldGenWasteland4());
        WorldGenFieldAssociation.associateFeature("bopFlowersPerChunk", new WorldGenBOPFlowerManager());
        WorldGenFieldAssociation.associateFeature("bopGrassPerChunk", new WorldGenBOPGrassManager());
    }

    private static void associateFeaturesForced() {
        WorldGenFieldAssociation.associateFeatureForced("waterPoolsPerChunk", (WorldGenerator)new WorldGenLiquids((Block)Blocks.field_150358_i), PondForcedGenerator.class);
        WorldGenFieldAssociation.associateFeatureForced("lavaPoolsPerChunk", (WorldGenerator)new WorldGenLiquids((Block)Blocks.field_150356_k), PondForcedGenerator.class);
        WorldGenFieldAssociation.associateFeatureForced("waterLakesPerChunk", (WorldGenerator)new WorldGenLakes(Blocks.field_150355_j), LakesForcedGenerator.class);
        WorldGenFieldAssociation.associateFeatureForced("lavaLakesPerChunk", (WorldGenerator)new WorldGenLakes(Blocks.field_150353_l), LakesForcedGenerator.class);
        WorldGenFieldAssociation.associateFeatureForced("generateMelons", (WorldGenerator)new WorldGenMelon(), MelonForcedGenerator.class);
    }

    public static void associateFeature(String name, WorldFeature feature) {
        featureMap.put(name, feature);
    }

    public static void associateFeature(String name, WorldGenerator generator) {
        featureMap.put(name, new WorldFeature(generator));
    }

    public static void associateFeatureForced(String name, WorldGenerator generator, Class<? extends ForcedWorldFeatureBOP> forcedFeature) {
        WorldGenFieldAssociation.associateFeature(name, new WorldFeature(generator, forcedFeature));
    }

    public static WorldFeature getAssociatedFeature(String name) {
        return featureMap.get(name);
    }

    public static class WorldFeature {
        private WorldGenerator worldGenerator;
        private Class<? extends ForcedWorldFeatureBOP> forcedFeature;

        protected WorldFeature(WorldGenerator worldGenerator, Class<? extends ForcedWorldFeatureBOP> forcedFeature) {
            this.worldGenerator = worldGenerator;
            this.forcedFeature = forcedFeature;
        }

        protected WorldFeature(WorldGenerator worldGenerator) {
            this(worldGenerator, null);
        }

        public IBOPWorldGenerator getBOPWorldGenerator() {
            if (this.worldGenerator instanceof IBOPWorldGenerator) {
                return (IBOPWorldGenerator)this.worldGenerator;
            }
            if (this.forcedFeature != null) {
                try {
                    return this.forcedFeature.getConstructor(WorldGenerator.class).newInstance(this.worldGenerator);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return null;
        }
    }
}

