/*
 * Decompiled with CFR 0.152.
 */
package cubex2.mods.morefurnaces;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cubex2.mods.morefurnaces.MoreFurnaces;
import cubex2.mods.morefurnaces.blocks.BlockMoreFurnaces;
import cubex2.mods.morefurnaces.tileentity.TileEntityDiamondFurnace;
import cubex2.mods.morefurnaces.tileentity.TileEntityGoldFurnace;
import cubex2.mods.morefurnaces.tileentity.TileEntityIronFurnace;
import cubex2.mods.morefurnaces.tileentity.TileEntityNetherrackFurnace;
import cubex2.mods.morefurnaces.tileentity.TileEntityObsidianFurnace;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.util.IIcon;
import net.minecraftforge.oredict.ShapedOreRecipe;

public enum FurnaceType {
    IRON(2, 2, 2, 1, 150, 56, 17, 38, 17, 56, 53, 38, 53, 116, 35, 138, 39, 8, 84, "Iron Furnace", TileEntityIronFurnace.class, "III", "IPI", "III"),
    GOLD(4, 5, 4, 1, 80, 62, 17, 8, 17, 62, 53, 8, 53, 116, 35, 138, 39, 28, 84, "Gold Furnace", TileEntityGoldFurnace.class, "GGG", "GPG", "GGG"),
    DIAMOND(7, 9, 7, 1, 40, 62, 35, 8, 17, 62, 71, 8, 71, 116, 53, 138, 39, 28, 120, "Diamond Furnace", TileEntityDiamondFurnace.class, "DDD", "DPD", "DDD"),
    OBSIDIAN(2, 2, 2, 2, 150, new int[]{56, 56}, new int[]{17, 43}, new int[]{38, 38}, new int[]{17, 43}, 56, 83, 38, 83, new int[]{116, 116}, new int[]{18, 44}, new int[]{138, 138}, new int[]{22, 48}, 8, 114, "Obsidian Furnace", TileEntityObsidianFurnace.class, "OOO", "O1O", "OOO"),
    NETHERRACK(1, 1, 0, 1, 1800, 56, 17, -1, -1, -1, -1, -1, -1, 116, 35, -1, -1, 8, 84, "Netherrack Furnace", TileEntityNetherrackFurnace.class, "NNN", "NFN", "NNN");

    final int inputSlots;
    final int outputSlots;
    public final int fuelSlots;
    public final int parallelSmelting;
    public final int[] inputSlotIds;
    public final int[] outputSlotIds;
    public final int[] fuelSlotIds;
    public final int speed;
    public final int[] mainInputX;
    public final int[] mainInputY;
    public final int[] inputX;
    public final int[] inputY;
    public final int mainFuelX;
    public final int mainFuelY;
    public final int fuelX;
    public final int fuelY;
    public final int[] mainOutputX;
    public final int[] mainOutputY;
    public final int[] outputX;
    public final int[] outputY;
    public final int inventoryX;
    public final int inventoryY;
    public final String friendlyName;
    public final Class<? extends TileEntityIronFurnace> clazz;
    private final String[] recipe;
    @SideOnly(value=Side.CLIENT)
    public IIcon[] icons;
    private static String[] postFixMap;

    private FurnaceType(int inputSlots, int outputSlots, int fuelSlots, int parallelSmelting, int speed, int[] mainInputX, int[] mainInputY, int[] inputX, int[] inputY, int mainFuelX, int mainFuelY, int fuelX, int fuelY, int[] mainOutputX, int[] mainOutputY, int[] outputX, int[] outputY, int inventoryX, int inventoryY, String friendlyName, Class<? extends TileEntityIronFurnace> clazz, String ... recipe) {
        int i;
        this.inputSlots = inputSlots;
        this.outputSlots = outputSlots;
        this.fuelSlots = fuelSlots;
        this.parallelSmelting = parallelSmelting;
        this.inputSlotIds = new int[inputSlots * parallelSmelting];
        this.outputSlotIds = new int[outputSlots * parallelSmelting];
        this.fuelSlotIds = new int[fuelSlots];
        for (i = 0; i < this.inputSlotIds.length; ++i) {
            this.inputSlotIds[i] = i;
        }
        for (i = 0; i < this.fuelSlotIds.length; ++i) {
            this.fuelSlotIds[i] = i + this.inputSlotIds.length;
        }
        for (i = 0; i < this.outputSlotIds.length; ++i) {
            this.outputSlotIds[i] = i + this.inputSlotIds.length + this.fuelSlotIds.length;
        }
        this.speed = speed;
        this.mainInputX = mainInputX;
        this.mainInputY = mainInputY;
        this.inputX = inputX;
        this.inputY = inputY;
        this.mainFuelX = mainFuelX;
        this.mainFuelY = mainFuelY;
        this.fuelX = fuelX;
        this.fuelY = fuelY;
        this.mainOutputX = mainOutputX;
        this.mainOutputY = mainOutputY;
        this.outputX = outputX;
        this.outputY = outputY;
        this.inventoryX = inventoryX;
        this.inventoryY = inventoryY;
        this.friendlyName = friendlyName;
        this.clazz = clazz;
        this.recipe = recipe;
    }

    private FurnaceType(int inputSlots, int outputSlots, int fuelSlots, int parallelSmelting, int speed, int mainInputX, int mainInputY, int inputX, int inputY, int mainFuelX, int mainFuelY, int fuelX, int fuelY, int mainOutputX, int mainOutputY, int outputX, int outputY, int inventoryX, int inventoryY, String friendlyName, Class<? extends TileEntityIronFurnace> clazz, String ... recipe) {
        this(inputSlots, outputSlots, fuelSlots, parallelSmelting, speed, new int[]{mainInputX}, new int[]{mainInputY}, new int[]{inputX}, new int[]{inputY}, mainFuelX, mainFuelY, fuelX, fuelY, new int[]{mainOutputX}, new int[]{mainOutputY}, new int[]{outputX}, new int[]{outputY}, inventoryX, inventoryY, friendlyName, clazz, recipe);
    }

    public static TileEntityIronFurnace makeEntity(int meta) {
        try {
            TileEntityIronFurnace te = FurnaceType.values()[meta].clazz.newInstance();
            return te;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void generateRecipes(BlockMoreFurnaces blockResult) {
        ItemStack previous = new ItemStack(Blocks.field_150460_al);
        for (FurnaceType typ : FurnaceType.values()) {
            ShapedOreRecipe recipe = new ShapedOreRecipe(new ItemStack((Block)blockResult, 1, typ.ordinal()), new Object[]{typ.recipe, Character.valueOf('I'), Items.field_151042_j, Character.valueOf('G'), Items.field_151043_k, Character.valueOf('D'), Items.field_151045_i, Character.valueOf('O'), Blocks.field_150343_Z, Character.valueOf('N'), Blocks.field_150424_aL, Character.valueOf('F'), Blocks.field_150460_al, Character.valueOf('1'), new ItemStack((Block)MoreFurnaces.blockFurnaces, 0), Character.valueOf('P'), previous});
            CraftingManager.func_77594_a().func_77592_b().add(recipe);
            previous = new ItemStack((Block)blockResult, 1, typ.ordinal());
        }
    }

    public int getSpeed() {
        return this.speed;
    }

    public boolean isInputSlot(int slotId) {
        return FurnaceType.arrayContains(this.inputSlotIds, slotId);
    }

    public boolean isFuelSlot(int slotId) {
        return FurnaceType.arrayContains(this.fuelSlotIds, slotId);
    }

    public boolean isOutputSlot(int slotId) {
        return FurnaceType.arrayContains(this.outputSlotIds, slotId);
    }

    public static boolean arrayContains(int[] i, int i1) {
        for (int i2 : i) {
            if (i2 != i1) continue;
            return true;
        }
        return false;
    }

    public int getFirstInputSlot(int id) {
        return 0 + id * this.inputSlots;
    }

    public int getLastInputSlot(int id) {
        return this.getFirstInputSlot(id) + this.inputSlots - 1;
    }

    public int getFirstFuelSlot() {
        return this.getLastInputSlot(this.parallelSmelting - 1) + 1;
    }

    public int getLastFuelSlot() {
        return this.getFirstFuelSlot() + this.fuelSlots - 1;
    }

    public int getFirstOutputSlot(int id) {
        return this.getLastFuelSlot() + 1 + id * this.outputSlots;
    }

    public int getLastOutputSlot(int id) {
        return this.getFirstOutputSlot(id) + this.outputSlots - 1;
    }

    public int getNumSlots() {
        return this.parallelSmelting * (this.inputSlots + this.outputSlots) + this.fuelSlots;
    }

    public int getNumInputRows() {
        int numSlots = this.inputSlots;
        if (numSlots <= 4) {
            return 1;
        }
        return (numSlots - 1) / 3;
    }

    public int getNumFuelRows() {
        return this.fuelSlots <= 4 ? 1 : (this.fuelSlots - 1) / 3;
    }

    public int getNumOutputRows() {
        int numSlots = this.outputSlots;
        if (numSlots <= 4) {
            return 1;
        }
        return (numSlots - 1) / 3;
    }

    public int getInputSlotsPerRow() {
        int numSlots = this.inputSlots;
        return (numSlots - 1) / this.getNumInputRows();
    }

    public int getFuelSlotsPerRow() {
        return (this.fuelSlots - 1) / this.getNumFuelRows();
    }

    public int getOutputSlotsPerRow() {
        int numSlots = this.outputSlots;
        return (numSlots - 1) / this.getNumOutputRows();
    }

    public void makeIcons(IIconRegister iconRegister) {
        this.icons = new IIcon[5];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a("morefurnaces:" + this.name().toLowerCase() + postFixMap[i]);
        }
    }

    static {
        postFixMap = new String[]{"Bottom", "Top", "Side", "FrontOn", "FrontOff"};
    }
}

