/*
 * Decompiled with CFR 0.152.
 */
package cubex2.mods.morefurnaces.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cubex2.mods.morefurnaces.FurnaceType;
import cubex2.mods.morefurnaces.MoreFurnaces;
import cubex2.mods.morefurnaces.tileentity.TileEntityIronFurnace;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockMoreFurnaces
extends BlockContainer {
    private Random random;

    public BlockMoreFurnaces() {
        super(Material.field_151573_f);
        this.func_149663_c("ironFurnace");
        this.func_149711_c(2.5f);
        this.func_149672_a(Block.field_149777_j);
        this.random = new Random();
        this.func_149647_a(CreativeTabs.field_78031_c);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return FurnaceType.makeEntity(meta);
    }

    public int func_149692_a(int i) {
        return i;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof TileEntityIronFurnace) {
            return ((TileEntityIronFurnace)te).isActive() ? 12 : 0;
        }
        return 0;
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        this.setDefaultDirection(world, x, y, z);
        world.func_147471_g(x, y, z);
    }

    private void setDefaultDirection(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            TileEntity te;
            Block blockZNeg = world.func_147439_a(x, y, z - 1);
            Block blockZPos = world.func_147439_a(x, y, z + 1);
            Block blockXNeg = world.func_147439_a(x - 1, y, z);
            Block blockXPos = world.func_147439_a(x + 1, y, z);
            byte facing = 3;
            if (blockZNeg.func_149730_j() && !blockZPos.func_149730_j()) {
                facing = 3;
            }
            if (blockZPos.func_149730_j() && !blockZNeg.func_149730_j()) {
                facing = 2;
            }
            if (blockXNeg.func_149730_j() && !blockXPos.func_149730_j()) {
                facing = 5;
            }
            if (blockXPos.func_149730_j() && !blockXNeg.func_149730_j()) {
                facing = 4;
            }
            if ((te = world.func_147438_o(x, y, z)) != null && te instanceof TileEntityIronFurnace) {
                ((TileEntityIronFurnace)te).setFacing(facing);
                world.func_147471_g(x, y, z);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        int meta = world.func_72805_g(x, y, z);
        if (meta < FurnaceType.values().length) {
            FurnaceType type = FurnaceType.values()[meta];
            if (side == 0) {
                return type.icons[0];
            }
            if (side == 1) {
                return type.icons[1];
            }
            TileEntity te = world.func_147438_o(x, y, z);
            if (te != null && te instanceof TileEntityIronFurnace) {
                TileEntityIronFurnace furnace = (TileEntityIronFurnace)te;
                if (side != furnace.getFacing()) {
                    return type.icons[2];
                }
                return type.icons[furnace.isActive() ? 3 : 4];
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        TileEntityIronFurnace tef;
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof TileEntityIronFurnace && (tef = (TileEntityIronFurnace)te).isActive()) {
            byte facing = tef.getFacing();
            float var7 = (float)x + 0.5f;
            float var8 = (float)y + 0.0f + random.nextFloat() * 6.0f / 16.0f;
            float var9 = (float)z + 0.5f;
            float var10 = 0.52f;
            float var11 = random.nextFloat() * 0.6f - 0.3f;
            if (facing == 4) {
                world.func_72869_a("smoke", (double)(var7 - var10), (double)var8, (double)(var9 + var11), 0.0, 0.0, 0.0);
                world.func_72869_a("flame", (double)(var7 - var10), (double)var8, (double)(var9 + var11), 0.0, 0.0, 0.0);
            } else if (facing == 5) {
                world.func_72869_a("smoke", (double)(var7 + var10), (double)var8, (double)(var9 + var11), 0.0, 0.0, 0.0);
                world.func_72869_a("flame", (double)(var7 + var10), (double)var8, (double)(var9 + var11), 0.0, 0.0, 0.0);
            } else if (facing == 2) {
                world.func_72869_a("smoke", (double)(var7 + var11), (double)var8, (double)(var9 - var10), 0.0, 0.0, 0.0);
                world.func_72869_a("flame", (double)(var7 + var11), (double)var8, (double)(var9 - var10), 0.0, 0.0, 0.0);
            } else if (facing == 3) {
                world.func_72869_a("smoke", (double)(var7 + var11), (double)var8, (double)(var9 + var10), 0.0, 0.0, 0.0);
                world.func_72869_a("flame", (double)(var7 + var11), (double)var8, (double)(var9 + var10), 0.0, 0.0, 0.0);
            }
        }
    }

    public IIcon func_149691_a(int side, int meta) {
        if (meta < FurnaceType.values().length) {
            FurnaceType type = FurnaceType.values()[meta];
            if (side == 0) {
                return type.icons[0];
            }
            if (side == 1) {
                return type.icons[1];
            }
            if (side == 3) {
                return type.icons[4];
            }
            return type.icons[2];
        }
        return null;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float f1, float f2, float f3) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == FurnaceType.NETHERRACK.ordinal() && ForgeDirection.getOrientation((int)side) == ForgeDirection.UP) {
            return false;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (te == null || !(te instanceof TileEntityIronFurnace)) {
            return true;
        }
        if (world.field_72995_K) {
            return true;
        }
        player.openGui((Object)MoreFurnaces.instance, ((TileEntityIronFurnace)te).getType().ordinal(), world, x, y, z);
        return true;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase living, ItemStack stack) {
        TileEntity te;
        byte furnaceFacing = 0;
        int facing = MathHelper.func_76128_c((double)((double)(living.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (facing == 0) {
            furnaceFacing = 2;
        }
        if (facing == 1) {
            furnaceFacing = 5;
        }
        if (facing == 2) {
            furnaceFacing = 3;
        }
        if (facing == 3) {
            furnaceFacing = 4;
        }
        if ((te = world.func_147438_o(x, y, z)) != null && te instanceof TileEntityIronFurnace) {
            ((TileEntityIronFurnace)te).setFacing(furnaceFacing);
            world.func_147471_g(x, y, z);
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof TileEntityIronFurnace) {
            TileEntityIronFurnace furnace = (TileEntityIronFurnace)te;
            for (int i = 0; i < furnace.func_70302_i_(); ++i) {
                ItemStack stack = furnace.func_70301_a(i);
                if (stack == null) continue;
                float var10 = this.random.nextFloat() * 0.8f + 0.1f;
                float var11 = this.random.nextFloat() * 0.8f + 0.1f;
                float var12 = this.random.nextFloat() * 0.8f + 0.1f;
                while (stack.field_77994_a > 0) {
                    int var13 = this.random.nextInt(21) + 10;
                    if (var13 > stack.field_77994_a) {
                        var13 = stack.field_77994_a;
                    }
                    stack.field_77994_a -= var13;
                    EntityItem var14 = new EntityItem(world, (double)((float)x + var10), (double)((float)y + var11), (double)((float)z + var12), new ItemStack(stack.func_77973_b(), var13, stack.func_77960_j()));
                    if (stack.func_77942_o()) {
                        var14.func_92059_d().func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
                    }
                    float var15 = 0.05f;
                    var14.field_70159_w = (float)this.random.nextGaussian() * var15;
                    var14.field_70181_x = (float)this.random.nextGaussian() * var15 + 0.2f;
                    var14.field_70179_y = (float)this.random.nextGaussian() * var15;
                    world.func_72838_d((Entity)var14);
                }
            }
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tabs, List list) {
        for (FurnaceType type : FurnaceType.values()) {
            list.add(new ItemStack((Block)this, 1, type.ordinal()));
        }
    }

    public boolean isFireSource(World world, int x, int y, int z, ForgeDirection side) {
        int metadata = world.func_72805_g(x, y, z);
        return metadata == FurnaceType.NETHERRACK.ordinal() && side == ForgeDirection.UP;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        for (FurnaceType type : FurnaceType.values()) {
            type.makeIcons(iconRegister);
        }
    }
}

