/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.client.gui;

import java.util.Vector;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.millenaire.client.gui.GuiText;
import org.millenaire.common.MLN;
import org.millenaire.common.MillConfig;

public class GuiConfig
extends GuiText {
    int pageId = -1;
    ResourceLocation background = new ResourceLocation("millenaire", "textures/gui/ML_config.png");

    @Override
    protected void customDrawBackground(int i, int j, float f) {
    }

    @Override
    protected void customDrawScreen(int i, int j, float f) {
    }

    @Override
    public int getLineSizeInPx() {
        return 247;
    }

    @Override
    public int getPageSize() {
        return 19;
    }

    @Override
    public ResourceLocation getPNGPath() {
        return this.background;
    }

    @Override
    public int getXSize() {
        return 256;
    }

    @Override
    public int getYSize() {
        return 220;
    }

    @Override
    public void initData() {
        this.descText = this.getData();
    }

    private Vector<Vector<GuiText.Line>> getHomepageData() {
        Vector<Vector<GuiText.Line>> pages = new Vector<Vector<GuiText.Line>>();
        Vector<GuiText.Line> text = new Vector<GuiText.Line>();
        text.add(new GuiText.Line("<darkblue>" + MLN.string("config.pagetitle"), false));
        text.add(new GuiText.Line("", false));
        for (int i = 0; i < MLN.configPages.size(); ++i) {
            text.add(new GuiText.Line(new ConfigPageButton(i)));
            text.add(new GuiText.Line(false));
            text.add(new GuiText.Line());
        }
        pages.add(text);
        return this.adjustText(pages);
    }

    private Vector<Vector<GuiText.Line>> getData() {
        if (this.pageId == -1) {
            return this.getHomepageData();
        }
        return this.getPageData();
    }

    private Vector<Vector<GuiText.Line>> getPageData() {
        Vector<Vector<GuiText.Line>> pages = new Vector<Vector<GuiText.Line>>();
        Vector<GuiText.Line> text = new Vector<GuiText.Line>();
        text.add(new GuiText.Line("<darkblue>" + MLN.string(MLN.configPageTitles.get(this.pageId)), false));
        text.add(new GuiText.Line());
        if (MLN.configPageDesc.get(this.pageId) != null) {
            text.add(new GuiText.Line(MLN.string(MLN.configPageDesc.get(this.pageId)), false));
            text.add(new GuiText.Line());
        }
        for (int j = 0; j < MLN.configPages.get(this.pageId).size(); ++j) {
            MillConfig config = MLN.configPages.get(this.pageId).get(j);
            if (!config.displayConfig && (!config.displayConfigDev || !MLN.DEV)) continue;
            if (config.getDesc().length() > 0) {
                text.add(new GuiText.Line(config.getDesc(), false));
            }
            if (config.hasTextField()) {
                GuiText.MillGuiTextField textField = new GuiText.MillGuiTextField(this.field_146289_q, 0, 0, 0, 0, config.key);
                textField.func_146180_a(config.getStringValue());
                textField.func_146203_f(config.strLimit);
                textField.func_146193_g(-1);
                text.add(new GuiText.Line(config.getLabel() + ":", textField));
                text.add(new GuiText.Line(false));
                text.add(new GuiText.Line());
                continue;
            }
            text.add(new GuiText.Line(new ConfigButton(config)));
            text.add(new GuiText.Line(false));
            text.add(new GuiText.Line());
        }
        pages.add(text);
        return this.adjustText(pages);
    }

    @Override
    protected void handleTextFieldPress(GuiText.MillGuiTextField textField) {
        if (MLN.configs.containsKey(textField.fieldKey)) {
            MillConfig config = MLN.configs.get(textField.fieldKey);
            config.setValueFromString(textField.func_146179_b(), false);
            MLN.writeConfigFile();
        }
    }

    @Override
    public boolean func_73868_f() {
        return true;
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_73876_c() {
    }

    protected void func_146284_a(GuiButton guibutton) {
        if (guibutton instanceof ConfigButton) {
            ConfigButton configButton = (ConfigButton)guibutton;
            int valPos = -1;
            for (int i = 0; i < configButton.config.getPossibleVals().length; ++i) {
                Object o = configButton.config.getPossibleVals()[i];
                if (!o.equals(configButton.config.getValue())) continue;
                valPos = i;
            }
            if (++valPos >= configButton.config.getPossibleVals().length) {
                valPos = 0;
            }
            configButton.config.setValue(configButton.config.getPossibleVals()[valPos]);
            configButton.refreshLabel();
            MLN.writeConfigFile();
        } else if (guibutton instanceof ConfigPageButton) {
            ConfigPageButton configPageButton = (ConfigPageButton)guibutton;
            this.pageId = configPageButton.pageId;
            this.pageNum = 0;
            this.descText = this.getData();
            this.buttonPagination();
        }
    }

    @Override
    protected void func_73869_a(char c, int i) {
        if (i == 1) {
            if (this.pageId == -1) {
                this.field_146297_k.func_147108_a(null);
                this.field_146297_k.func_71381_h();
            } else {
                this.pageId = -1;
                this.pageNum = 0;
                this.descText = this.getData();
                this.buttonPagination();
            }
        } else {
            super.func_73869_a(c, i);
        }
    }

    public static class ConfigPageButton
    extends GuiText.MillGuiButton {
        public int pageId;

        public ConfigPageButton(int pageId) {
            super(0, 0, 0, 0, 0, MLN.string(MLN.configPageTitles.get(pageId)));
            this.pageId = pageId;
        }
    }

    public static class ConfigButton
    extends GuiText.MillGuiButton {
        public MillConfig config;

        public ConfigButton(MillConfig config) {
            super(0, 0, 0, 0, 0, config.getLabel());
            this.config = config;
            this.refreshLabel();
        }

        public void refreshLabel() {
            this.field_146126_j = this.config.getLabel() + ": " + this.config.getStringValue();
        }
    }
}

