/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common;

import java.util.HashMap;
import java.util.Vector;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import org.millenaire.common.Building;
import org.millenaire.common.Culture;
import org.millenaire.common.MLN;
import org.millenaire.common.MillVillager;
import org.millenaire.common.MillWorld;
import org.millenaire.common.Point;
import org.millenaire.common.VillagerType;
import org.millenaire.common.core.MillCommonUtilities;
import org.millenaire.common.forge.Mill;

public class VillagerRecord
implements Cloneable {
    public Culture culture;
    public String fathersName = "";
    public String mothersName = "";
    public String spousesName = "";
    public String maidenName = "";
    public boolean flawedRecord = false;
    public boolean killed = false;
    public boolean raidingVillage = false;
    public boolean awayraiding = false;
    public boolean awayhired = false;
    public Point housePos;
    public Point townHallPos;
    public Point originalVillagePos;
    public long id;
    public long raiderSpawn = 0L;
    public int nb;
    public int gender;
    public int villagerSize;
    public HashMap<MillVillager.InvItem, Integer> inventory = new HashMap();
    public Vector<String> questTags = new Vector();
    public String type;
    public String firstName;
    public String familyName;
    public String nameKey;
    public String occupation;
    public ResourceLocation texture;
    private Building house;
    private Building townHall;
    private Building originalVillage;
    public MillWorld mw;

    public static VillagerRecord read(MillWorld mw, Culture thCulture, Point th, NBTTagCompound nbttagcompound, String label) {
        NBTTagCompound nbttagcompound1;
        int i;
        if (!nbttagcompound.func_74764_b(label + "_id") && !nbttagcompound.func_74764_b(label + "_lid")) {
            return null;
        }
        VillagerRecord vr = nbttagcompound.func_74764_b(label + "_culture") ? new VillagerRecord(mw, Culture.getCultureByName(nbttagcompound.func_74779_i(label + "_culture"))) : new VillagerRecord(mw, thCulture);
        if (nbttagcompound.func_74764_b(label + "_lid")) {
            vr.id = Math.abs(nbttagcompound.func_74763_f(label + "_lid"));
        }
        vr.nb = nbttagcompound.func_74762_e(label + "_nb");
        vr.gender = nbttagcompound.func_74762_e(label + "_gender");
        vr.type = nbttagcompound.func_74779_i(label + "_type").toLowerCase();
        if (vr.gender > 0 && MillVillager.oldVillagers.containsKey(vr.type)) {
            vr.type = vr.gender == 1 ? MillVillager.oldVillagers.get(vr.type)[0] : MillVillager.oldVillagers.get(vr.type)[1];
        }
        vr.raiderSpawn = nbttagcompound.func_74763_f(label + "_raiderSpawn");
        vr.firstName = nbttagcompound.func_74779_i(label + "_firstName");
        vr.familyName = nbttagcompound.func_74779_i(label + "_familyName");
        vr.nameKey = nbttagcompound.func_74779_i(label + "_propertype");
        vr.occupation = nbttagcompound.func_74779_i(label + "_occupation");
        vr.texture = new ResourceLocation("millenaire", nbttagcompound.func_74779_i(label + "_texture"));
        vr.housePos = Point.read(nbttagcompound, label + "_housePos");
        vr.townHallPos = Point.read(nbttagcompound, label + "_townHallPos");
        vr.originalVillagePos = Point.read(nbttagcompound, label + "_originalVillagePos");
        if (vr.townHallPos == null) {
            vr.townHallPos = th;
        }
        vr.villagerSize = nbttagcompound.func_74762_e(label + "_size");
        vr.fathersName = nbttagcompound.func_74779_i(label + "_fathersName");
        vr.mothersName = nbttagcompound.func_74779_i(label + "_mothersName");
        vr.maidenName = nbttagcompound.func_74779_i(label + "_maidenName");
        vr.spousesName = nbttagcompound.func_74779_i(label + "_spousesName");
        vr.killed = nbttagcompound.func_74767_n(label + "_killed");
        vr.raidingVillage = nbttagcompound.func_74767_n(label + "_raidingVillage");
        vr.awayraiding = nbttagcompound.func_74767_n(label + "_awayraiding");
        vr.awayhired = nbttagcompound.func_74767_n(label + "_awayhired");
        NBTTagList nbttaglist = nbttagcompound.func_150295_c(label + "questTags", 10);
        for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
            nbttagcompound1 = nbttaglist.func_150305_b(i);
            vr.questTags.add(nbttagcompound1.func_74779_i("tag"));
        }
        nbttaglist = nbttagcompound.func_150295_c(label + "_inventory", 10);
        for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
            nbttagcompound1 = nbttaglist.func_150305_b(i);
            vr.inventory.put(new MillVillager.InvItem(Item.func_150899_d((int)nbttagcompound1.func_74762_e("item")), nbttagcompound1.func_74762_e("meta")), nbttagcompound1.func_74762_e("amount"));
        }
        if (vr.getType() == null) {
            MLN.error(vr, "Could not find type " + vr.type + " for VR. Skipping.");
            return null;
        }
        return vr;
    }

    public VillagerRecord(MillWorld mw) {
        this.mw = mw;
    }

    private VillagerRecord(MillWorld mw, Culture c) {
        this.culture = c;
        this.mw = mw;
    }

    public VillagerRecord(MillWorld mw, MillVillager v) {
        this.mw = mw;
        this.culture = v.getCulture();
        this.id = v.villager_id;
        if (v.vtype != null) {
            this.type = v.vtype.key;
        }
        this.firstName = v.firstName;
        this.familyName = v.familyName;
        this.nameKey = v.getNameKey();
        this.occupation = v.getNativeOccupationName();
        this.gender = v.gender;
        this.nb = 1;
        this.texture = v.getTexture();
        this.housePos = v.housePoint;
        this.townHallPos = v.townHallPoint;
        this.villagerSize = v.size;
        this.raidingVillage = v.isRaider;
        for (MillVillager.InvItem iv : v.getInventoryKeys()) {
            this.inventory.put(iv, v.countInv(iv));
        }
        if (this.housePos == null) {
            MLN.error(this, "Creation constructor: House position in record is null.");
            this.flawedRecord = true;
        }
    }

    public VillagerRecord clone() {
        try {
            return (VillagerRecord)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int countInv(Item item) {
        return this.countInv(item, 0);
    }

    public int countInv(Item item, int meta) {
        MillVillager.InvItem key = new MillVillager.InvItem(item, meta);
        if (this.inventory.containsKey(key)) {
            return this.inventory.get(key);
        }
        return 0;
    }

    public int countInv(MillVillager.InvItem key) {
        if (this.inventory.containsKey(key)) {
            return this.inventory.get(key);
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VillagerRecord)) {
            return false;
        }
        VillagerRecord other = (VillagerRecord)obj;
        return other.id == this.id;
    }

    public ItemStack getArmourPiece(int type) {
        if (type == 0) {
            for (Item weapon : MillVillager.helmets) {
                if (this.countInv(weapon) <= 0) continue;
                return new ItemStack(weapon, 1);
            }
            return null;
        }
        if (type == 1) {
            for (Item weapon : MillVillager.chestplates) {
                if (this.countInv(weapon) <= 0) continue;
                return new ItemStack(weapon, 1);
            }
            return null;
        }
        if (type == 2) {
            for (Item weapon : MillVillager.legs) {
                if (this.countInv(weapon) <= 0) continue;
                return new ItemStack(weapon, 1);
            }
            return null;
        }
        if (type == 3) {
            for (Item weapon : MillVillager.boots) {
                if (this.countInv(weapon) <= 0) continue;
                return new ItemStack(weapon, 1);
            }
            return null;
        }
        return null;
    }

    public Item getBestMeleeWeapon() {
        double max = 1.0;
        Item best = null;
        for (MillVillager.InvItem item : this.inventory.keySet()) {
            if (this.inventory.get(item) <= 0) continue;
            if (item.getItem() == null) {
                MLN.error(this, "Attempting to check null melee weapon with id: " + this.inventory.get(item));
                continue;
            }
            if (!(MillCommonUtilities.getItemWeaponDamage(item.getItem()) > max)) continue;
            max = MillCommonUtilities.getItemWeaponDamage(item.getItem());
            best = item.getItem();
        }
        if (this.getType() != null && this.getType().startingWeapon != null && MillCommonUtilities.getItemWeaponDamage(this.getType().startingWeapon.getItem()) > max) {
            max = MillCommonUtilities.getItemWeaponDamage(this.getType().startingWeapon.getItem());
            best = this.getType().startingWeapon.getItem();
        }
        return best;
    }

    public String getGameOccupation(String username) {
        String game;
        if (this.culture == null || this.culture.getVillagerType(this.nameKey) == null) {
            return "";
        }
        String s = this.culture.getVillagerType((String)this.nameKey).name;
        if (this.culture.canReadVillagerNames(username) && !(game = this.culture.getCultureString("villager." + this.nameKey)).equals("")) {
            s = s + " (" + game + ")";
        }
        return s;
    }

    public Building getHouse() {
        if (this.house != null) {
            return this.house;
        }
        if (MLN.LogVillager >= 3) {
            MLN.debug(this, "Seeking uncached house");
        }
        this.house = this.mw.getBuilding(this.housePos);
        return this.house;
    }

    public int getMaxHealth() {
        if (this.getType() == null) {
            return 20;
        }
        if (this.getType().isChild) {
            return 10 + this.villagerSize / 2;
        }
        return this.getType().health;
    }

    public int getMilitaryStrength() {
        int strength = this.getMaxHealth() / 2;
        int attack = this.getType().baseAttackStrength;
        Item bestMelee = this.getBestMeleeWeapon();
        if (bestMelee != null) {
            attack = (int)((double)attack + MillCommonUtilities.getItemWeaponDamage(bestMelee));
        }
        strength += attack * 2;
        if (this.getType().isArcher && this.countInv((Item)Items.field_151031_f) > 0 || this.countInv(Mill.yumiBow) > 0) {
            strength += 10;
        }
        return strength += this.getTotalArmorValue() * 2;
    }

    public String getName() {
        return this.firstName + " " + this.familyName;
    }

    public String getNativeOccupationName() {
        if (this.getType().isChild && this.villagerSize == 20) {
            return this.getType().altname;
        }
        return this.getType().name;
    }

    public Building getOriginalVillage() {
        if (this.originalVillage != null) {
            return this.originalVillage;
        }
        if (MLN.LogVillager >= 3) {
            MLN.debug(this, "Seeking uncached originalVillage");
        }
        this.originalVillage = this.mw.getBuilding(this.originalVillagePos);
        return this.originalVillage;
    }

    public int getTotalArmorValue() {
        int total = 0;
        for (int i = 0; i < 4; ++i) {
            ItemStack armour = this.getArmourPiece(i);
            if (armour == null || !(armour.func_77973_b() instanceof ItemArmor)) continue;
            total += ((ItemArmor)armour.func_77973_b()).field_77879_b;
        }
        return total;
    }

    public Building getTownHall() {
        if (this.townHall != null) {
            return this.townHall;
        }
        if (MLN.LogVillager >= 3) {
            MLN.debug(this, "Seeking uncached townHall");
        }
        this.townHall = this.mw.getBuilding(this.townHallPos);
        return this.townHall;
    }

    public VillagerType getType() {
        if (this.culture.getVillagerType(this.type) == null) {
            for (Culture c : Culture.vectorCultures) {
                if (c.getVillagerType(this.type) == null) continue;
                MLN.error(this, "Could not find villager type " + this.type + " in culture " + this.culture.key + " but could in " + c.key + " so switching.");
                this.culture = c;
            }
        }
        return this.culture.getVillagerType(this.type);
    }

    public boolean matches(MillVillager v) {
        return this.id == v.villager_id;
    }

    public String toString() {
        return this.firstName + " " + this.familyName + "/" + this.type + "/" + this.nameKey + "/" + this.texture + "/" + this.id;
    }

    public void updateRecord(MillVillager v) {
        this.id = v.villager_id;
        if (v.vtype != null) {
            this.type = v.vtype.key;
        }
        this.firstName = v.firstName;
        this.familyName = v.familyName;
        this.nameKey = v.getNameKey();
        this.occupation = v.getNativeOccupationName();
        this.gender = v.gender;
        this.nb = 1;
        this.texture = v.getTexture();
        this.housePos = v.housePoint;
        this.townHallPos = v.townHallPoint;
        this.villagerSize = v.size;
        this.raidingVillage = v.isRaider;
        this.killed = v.field_70128_L;
        if (this.housePos == null) {
            MLN.error(this, "updateRecord(): House position in record is null.");
            this.flawedRecord = true;
        }
        this.inventory.clear();
        for (MillVillager.InvItem iv : v.getInventoryKeys()) {
            this.inventory.put(iv, v.countInv(iv));
        }
    }

    public void write(NBTTagCompound nbttagcompound, String label) {
        NBTTagCompound nbttagcompound1;
        nbttagcompound.func_74772_a(label + "_lid", this.id);
        nbttagcompound.func_74768_a(label + "_nb", this.nb);
        nbttagcompound.func_74778_a(label + "_type", this.type);
        nbttagcompound.func_74778_a(label + "_firstName", this.firstName);
        nbttagcompound.func_74778_a(label + "_familyName", this.familyName);
        nbttagcompound.func_74778_a(label + "_propertype", this.nameKey);
        nbttagcompound.func_74778_a(label + "_occupation", this.occupation);
        if (this.fathersName != null && this.fathersName.length() > 0) {
            nbttagcompound.func_74778_a(label + "_fathersName", this.fathersName);
        }
        if (this.mothersName != null && this.mothersName.length() > 0) {
            nbttagcompound.func_74778_a(label + "_mothersName", this.mothersName);
        }
        if (this.maidenName != null && this.maidenName.length() > 0) {
            nbttagcompound.func_74778_a(label + "_maidenName", this.maidenName);
        }
        if (this.spousesName != null && this.spousesName.length() > 0) {
            nbttagcompound.func_74778_a(label + "_spousesName", this.spousesName);
        }
        nbttagcompound.func_74768_a(label + "_gender", this.gender);
        nbttagcompound.func_74778_a(label + "_texture", this.texture.func_110623_a());
        nbttagcompound.func_74757_a(label + "_killed", this.killed);
        nbttagcompound.func_74757_a(label + "_raidingVillage", this.raidingVillage);
        nbttagcompound.func_74757_a(label + "_awayraiding", this.awayraiding);
        nbttagcompound.func_74757_a(label + "_awayhired", this.awayhired);
        nbttagcompound.func_74772_a(label + "_raiderSpawn", this.raiderSpawn);
        if (this.housePos != null) {
            this.housePos.write(nbttagcompound, label + "_housePos");
        }
        if (this.townHallPos != null) {
            this.townHallPos.write(nbttagcompound, label + "_townHallPos");
        }
        if (this.originalVillagePos != null) {
            this.originalVillagePos.write(nbttagcompound, label + "_originalVillagePos");
        }
        nbttagcompound.func_74768_a(label + "_size", this.villagerSize);
        NBTTagList nbttaglist = new NBTTagList();
        for (String tag : this.questTags) {
            nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74778_a("tag", tag);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a(label + "questTags", (NBTBase)nbttaglist);
        nbttaglist = new NBTTagList();
        for (MillVillager.InvItem key : this.inventory.keySet()) {
            nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74768_a("item", Item.func_150891_b((Item)key.getItem()));
            nbttagcompound1.func_74768_a("meta", key.meta);
            nbttagcompound1.func_74768_a("amount", this.inventory.get(key).intValue());
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a(label + "_inventory", (NBTBase)nbttaglist);
        nbttagcompound.func_74778_a(label + "_culture", this.culture.key);
    }
}

