/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.block;

import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.millenaire.common.core.MillCommonUtilities;
import org.millenaire.common.forge.Mill;

public class BlockDecorative
extends Block {
    private static final int EXPLOSION_RADIUS = 32;
    HashMap<Integer, String> textureSideNames = new HashMap();
    HashMap<Integer, String> textureTopNames = new HashMap();
    HashMap<Integer, String> textureBottomNames = new HashMap();
    HashMap<Integer, IIcon> texturesSide = new HashMap();
    HashMap<Integer, IIcon> texturesTop = new HashMap();
    HashMap<Integer, IIcon> texturesBottom = new HashMap();
    HashMap<Integer, String> names = new HashMap();

    public static int getBlockFromDye(int i) {
        return i;
    }

    public static int getDyeFromBlock(int i) {
        return i;
    }

    public BlockDecorative(Material material) {
        super(material);
        this.func_149675_a(true);
        this.func_149647_a(Mill.tabMillenaire);
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        if (this.func_149688_o() == Material.field_151575_d) {
            return 150;
        }
        return 0;
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        if (this.func_149688_o() == Material.field_151575_d) {
            return 5;
        }
        return 0;
    }

    public int func_149692_a(int i) {
        return i;
    }

    public void alchemistExplosion(World world, int i, int j, int k) {
        MillCommonUtilities.setBlockAndMetadata(world, i, j, k, null, 0, true, false);
        for (int y = 32; y >= -32; --y) {
            if (y + j < 0 || y + j >= 128) continue;
            for (int x = -32; x <= 32; ++x) {
                for (int z = -32; z <= 32; ++z) {
                    Block block;
                    if (x * x + y * y + z * z > 1024 || (block = world.func_147439_a(i + x, j + y, k + z)) == Blocks.field_150350_a) continue;
                    MillCommonUtilities.setBlockAndMetadata(world, i + x, j + y, k + z, null, 0, true, false);
                }
            }
        }
    }

    public void func_149690_a(World par1World, int i, int j, int k, int meta, float par6, int par7) {
        if (this == Mill.stone_decoration && meta == 3) {
            boolean isExplosion = false;
            StackTraceElement[] trace = Thread.currentThread().getStackTrace();
            for (int id = 0; id < trace.length; ++id) {
                String className = trace[id].getClassName();
                if (!className.equals(Explosion.class.getName())) continue;
                isExplosion = true;
            }
            if (isExplosion) {
                this.alchemistExplosion(par1World, i, j, k);
                return;
            }
        }
        super.func_149690_a(par1World, i, j, k, meta, par6, par7);
    }

    public IIcon func_149691_a(int side, int meta) {
        if (side == 1) {
            if (this.texturesTop.containsKey(meta)) {
                return this.texturesTop.get(meta);
            }
            return this.texturesTop.get(0);
        }
        if (side == 0) {
            if (this.texturesBottom.containsKey(meta)) {
                return this.texturesBottom.get(meta);
            }
            return this.texturesBottom.get(0);
        }
        if (this.texturesSide.containsKey(meta)) {
            return this.texturesSide.get(meta);
        }
        return this.texturesSide.get(0);
    }

    public void func_149666_a(Item item, CreativeTabs par2CreativeTabs, List par3List) {
        for (int meta : this.texturesSide.keySet()) {
            par3List.add(new ItemStack(item, 1, meta));
        }
    }

    public void registerName(int meta, String name) {
        this.names.put(meta, name);
    }

    public void registerTexture(int meta, String name) {
        this.textureTopNames.put(meta, name);
        this.textureBottomNames.put(meta, name);
        this.textureSideNames.put(meta, name);
    }

    public void registerTexture(int meta, String top, String bottom, String side) {
        this.textureTopNames.put(meta, top);
        this.textureBottomNames.put(meta, bottom);
        this.textureSideNames.put(meta, side);
    }

    public void func_149651_a(IIconRegister iconRegister) {
        for (int meta : this.textureTopNames.keySet()) {
            this.texturesTop.put(meta, MillCommonUtilities.getIcon(iconRegister, this.textureTopNames.get(meta)));
        }
        for (int meta : this.textureBottomNames.keySet()) {
            this.texturesBottom.put(meta, MillCommonUtilities.getIcon(iconRegister, this.textureBottomNames.get(meta)));
        }
        for (int meta : this.textureSideNames.keySet()) {
            this.texturesSide.put(meta, MillCommonUtilities.getIcon(iconRegister, this.textureSideNames.get(meta)));
        }
    }

    public void func_149674_a(World world, int i, int j, int k, Random random) {
        int meta = world.func_72805_g(i, j, k);
        if (this == Mill.earth_decoration && meta == 0) {
            if (world.func_72957_l(i, j + 1, k) >= 15 && MillCommonUtilities.chanceOn(5)) {
                MillCommonUtilities.setBlockAndMetadata(world, i, j, k, Mill.stone_decoration, 1, true, false);
            }
        } else if (this == Mill.wood_decoration && meta == 3 && world.func_72957_l(i, j + 1, k) < 7 && MillCommonUtilities.chanceOn(5)) {
            MillCommonUtilities.setBlockAndMetadata(world, i, j, k, Mill.wood_decoration, 4, true, false);
        }
    }

    public static class ItemDecorative
    extends ItemBlock {
        BlockDecorative block;

        public ItemDecorative(Block b) {
            super(b);
            this.func_77656_e(0);
            this.func_77627_a(true);
            this.block = (BlockDecorative)b;
        }

        public IIcon func_77617_a(int i) {
            return this.block.func_149691_a(2, i);
        }

        public String func_77667_c(ItemStack itemstack) {
            return super.func_77658_a() + "." + itemstack.func_77960_j();
        }

        public int func_77647_b(int i) {
            return i;
        }
    }
}

