/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.construction;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import org.millenaire.common.BuildingLocation;
import org.millenaire.common.MLN;
import org.millenaire.common.construction.BuildingPlan;
import org.millenaire.common.construction.BuildingPlanSet;
import org.millenaire.common.core.MillCommonUtilities;

public class BuildingProject
implements MillCommonUtilities.WeightedChoice {
    public BuildingPlanSet planSet = null;
    public BuildingLocation location = null;
    public String key;

    public static BuildingProject getRandomProject(List<BuildingProject> possibleProjects) {
        return (BuildingProject)MillCommonUtilities.getWeightedChoice(possibleProjects, null);
    }

    public BuildingProject() {
    }

    public BuildingProject(BuildingPlanSet planSet) {
        this.planSet = planSet;
        try {
            this.key = planSet.plans.get((int)0)[0].buildingKey;
        }
        catch (Exception e) {
            MLN.printException("Error when getting projet for " + this.key + ", " + planSet + ":", e);
        }
    }

    @Override
    public int getChoiceWeight(EntityPlayer player) {
        if (this.location == null || this.location.level < 0) {
            return this.planSet.plans.get((int)0)[0].priority;
        }
        if (this.location.level + 1 < this.planSet.plans.get(this.location.getVariation()).length) {
            return this.planSet.plans.get((int)this.location.getVariation())[this.location.level + 1].priority;
        }
        return 0;
    }

    public String getFullName(EntityPlayer player) {
        return this.planSet.getFullName(player);
    }

    public String getGameName() {
        return this.planSet.getGameName();
    }

    public int getLevelsNumber(int variation) {
        if (variation >= this.planSet.plans.size()) {
            return 1;
        }
        return this.planSet.plans.get(variation).length;
    }

    public String getNativeName() {
        return this.planSet.getNativeName();
    }

    public BuildingPlan getNextBuildingPlan() {
        if (this.location == null) {
            return this.planSet.getRandomStartingPlan();
        }
        if (this.location.level < this.planSet.plans.get(this.location.getVariation()).length) {
            return this.planSet.plans.get(this.location.getVariation())[this.location.level + 1];
        }
        return null;
    }

    public BuildingPlan getPlan(int variation, int level) {
        if (variation >= this.planSet.plans.size()) {
            return null;
        }
        if (level >= this.planSet.plans.get(variation).length) {
            return null;
        }
        return this.planSet.plans.get(variation)[level];
    }

    public String toString() {
        return "Project " + this.key + " location: " + this.location;
    }
}

