/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.goal;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.millenaire.common.MLN;
import org.millenaire.common.MillVillager;
import org.millenaire.common.Point;
import org.millenaire.common.core.MillCommonUtilities;
import org.millenaire.common.forge.Mill;
import org.millenaire.common.goal.Goal;
import org.millenaire.common.pathing.atomicstryker.AStarConfig;

public class GoalClearOldPath
extends Goal {
    public GoalClearOldPath() {
        this.maxSimultaneousTotal = 1;
    }

    @Override
    public Goal.GoalInformation getDestination(MillVillager villager) throws Exception {
        Point p = villager.getTownHall().getCurrentClearPathPoint();
        if (p != null) {
            return this.packDest(p);
        }
        return null;
    }

    @Override
    public int actionDuration(MillVillager villager) {
        int toolEfficiency = (int)villager.getBestShovel().getDigSpeed(new ItemStack((Item)villager.getBestShovel(), 1), Blocks.field_150346_d, 0);
        return 100 - toolEfficiency * 5;
    }

    @Override
    public boolean performAction(MillVillager villager) throws Exception {
        Point p = villager.getTownHall().getCurrentClearPathPoint();
        if (p == null) {
            return true;
        }
        if (MLN.LogVillagePaths >= 3) {
            MLN.debug(villager, "Clearing old path block: " + p);
        }
        Block block = p.getBlock(villager.field_70170_p);
        int meta = p.getMeta(villager.field_70170_p);
        if (meta < 8) {
            if (block == Mill.pathSlab) {
                p.setBlock(villager.field_70170_p, Blocks.field_150350_a, 0, true, false);
            } else if (block == Mill.path) {
                Block blockBelow = p.getBelow().getBlock(villager.field_70170_p);
                if (MillCommonUtilities.getBlockIdValidGround(blockBelow, true) != null) {
                    p.setBlock(villager.field_70170_p, MillCommonUtilities.getBlockIdValidGround(blockBelow, true), 0, true, false);
                } else {
                    p.setBlock(villager.field_70170_p, Blocks.field_150346_d, 0, true, false);
                }
            }
        }
        ++villager.getTownHall().oldPathPointsToClearIndex;
        p = villager.getTownHall().getCurrentClearPathPoint();
        villager.func_71038_i();
        if (p != null) {
            villager.setGoalDestPoint(p);
            return false;
        }
        return true;
    }

    @Override
    public int priority(MillVillager villager) throws Exception {
        return 40;
    }

    @Override
    public int range(MillVillager villager) {
        return ACTIVATION_RANGE + 2;
    }

    @Override
    public boolean stopMovingWhileWorking() {
        return false;
    }

    @Override
    public boolean unreachableDestination(MillVillager villager) throws Exception {
        this.performAction(villager);
        return true;
    }

    @Override
    public boolean lookAtGoal() {
        return true;
    }

    @Override
    public AStarConfig getPathingConfig() {
        return JPS_CONFIG_BUILDING;
    }

    @Override
    public boolean isPossibleSpecific(MillVillager villager) {
        return MLN.BuildVillagePaths && villager.getTownHall().getCurrentClearPathPoint() != null;
    }

    @Override
    public boolean isStillValidSpecific(MillVillager villager) throws Exception {
        return villager.getTownHall().getCurrentClearPathPoint() != null;
    }

    @Override
    public ItemStack[] getHeldItemsTravelling(MillVillager villager) {
        return villager.getBestShovelStack();
    }
}

