/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.goal;

import net.minecraft.item.Item;
import org.millenaire.common.Building;
import org.millenaire.common.MillVillager;
import org.millenaire.common.goal.Goal;

public class GoalGetTool
extends Goal {
    private static final Item[][] classes = new Item[][]{MillVillager.axes, MillVillager.pickaxes, MillVillager.shovels, MillVillager.hoes, MillVillager.helmets, MillVillager.chestplates, MillVillager.legs, MillVillager.boots, MillVillager.weaponsSwords, MillVillager.weaponsRanged};

    public GoalGetTool() {
        this.maxSimultaneousInBuilding = 2;
    }

    @Override
    public Goal.GoalInformation getDestination(MillVillager villager) throws Exception {
        for (Building shop : villager.getTownHall().getShops()) {
            for (MillVillager.InvItem key : villager.getToolsNeeded()) {
                if (villager.countInv(key.getItem(), key.meta) != 0 || shop.countGoods(key.getItem(), key.meta) <= 0 || this.hasBetterTool(villager, key) || !this.validateDest(villager, shop)) continue;
                return this.packDest(shop.getSellingPos(), shop);
            }
        }
        return null;
    }

    private boolean hasBetterTool(MillVillager villager, MillVillager.InvItem key) {
        if (key.meta > 0) {
            return false;
        }
        for (Item[] toolclass : classes) {
            int i;
            int targetPos = -1;
            for (i = 0; i < toolclass.length && targetPos == -1; ++i) {
                if (toolclass[i] != key.getItem()) continue;
                targetPos = i;
            }
            if (targetPos == -1) continue;
            for (i = 0; i < targetPos; ++i) {
                if (villager.countInv(toolclass[i], 0) <= 0) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isPossibleSpecific(MillVillager villager) throws Exception {
        if (villager.getToolsNeeded().length == 0) {
            return false;
        }
        for (Building shop : villager.getTownHall().getShops()) {
            for (MillVillager.InvItem key : villager.getToolsNeeded()) {
                if (villager.countInv(key.getItem(), key.meta) != 0 || shop.countGoods(key.getItem(), key.meta) <= 0 || this.hasBetterTool(villager, key) || !this.validateDest(villager, shop)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean lookAtGoal() {
        return true;
    }

    @Override
    public boolean performAction(MillVillager villager) throws Exception {
        Building shop = villager.getGoalBuildingDest();
        if (shop == null) {
            return true;
        }
        for (MillVillager.InvItem key : villager.getToolsNeeded()) {
            if (villager.countInv(key.getItem(), key.meta) != 0 || shop.countGoods(key.getItem(), key.meta) <= 0 || this.hasBetterTool(villager, key)) continue;
            villager.takeFromBuilding(shop, key.getItem(), key.meta, 1);
        }
        return true;
    }

    @Override
    public int priority(MillVillager villager) throws Exception {
        return 100;
    }
}

