/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.goal;

import java.util.Vector;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import org.millenaire.common.Building;
import org.millenaire.common.MillVillager;
import org.millenaire.common.Point;
import org.millenaire.common.goal.Goal;

public class GoalIndianHarvestSugarCane
extends Goal {
    @Override
    public Goal.GoalInformation getDestination(MillVillager villager) {
        Vector<Point> vp = new Vector<Point>();
        Vector<Point> buildingp = new Vector<Point>();
        for (Building plantation : villager.getTownHall().getBuildingsWithTag("sugarplantation")) {
            Point p = plantation.getSugarCaneHarvestLocation();
            if (p == null) continue;
            vp.add(p);
            buildingp.add(plantation.getPos());
        }
        if (vp.isEmpty()) {
            return null;
        }
        Point p = (Point)vp.firstElement();
        Point buildingP = (Point)buildingp.firstElement();
        for (int i = 1; i < vp.size(); ++i) {
            if (!(((Point)vp.get(i)).horizontalDistanceToSquared((Entity)villager) < p.horizontalDistanceToSquared((Entity)villager))) continue;
            p = (Point)vp.get(i);
            buildingP = (Point)buildingp.get(i);
        }
        return this.packDest(p, buildingP);
    }

    @Override
    public ItemStack[] getHeldItemsTravelling(MillVillager villager) {
        return villager.getBestHoeStack();
    }

    @Override
    public boolean isPossibleSpecific(MillVillager villager) {
        int nbsimultaneous = 0;
        for (MillVillager v : villager.getTownHall().villagers) {
            if (v == villager || !this.key.equals(v.goalKey)) continue;
            ++nbsimultaneous;
        }
        if (nbsimultaneous > 2) {
            return false;
        }
        boolean delayOver = !villager.lastGoalTime.containsKey(this) ? true : villager.field_70170_p.func_72820_D() > villager.lastGoalTime.get(this) + 2000L;
        for (Building kiln : villager.getTownHall().getBuildingsWithTag("sugarplantation")) {
            int nb = kiln.getNbSugarCaneHarvestLocation();
            if (nb > 0 && delayOver) {
                return true;
            }
            if (nb <= 4) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean lookAtGoal() {
        return true;
    }

    @Override
    public boolean performAction(MillVillager villager) {
        double rand;
        float irrigation;
        int nbcrop;
        Point cropPoint = villager.getGoalDestPoint().getRelative(0.0, 3.0, 0.0);
        if (villager.getBlock(cropPoint) == Blocks.field_150436_aH) {
            villager.setBlockAndMetadata(cropPoint, Blocks.field_150350_a, 0);
            nbcrop = 1;
            irrigation = villager.getTownHall().getVillageIrrigation();
            rand = Math.random();
            if (rand < (double)(irrigation / 100.0f)) {
                ++nbcrop;
            }
            villager.addToInv(Items.field_151120_aE, nbcrop);
        }
        if (villager.getBlock(cropPoint = villager.getGoalDestPoint().getRelative(0.0, 2.0, 0.0)) == Blocks.field_150436_aH) {
            villager.setBlockAndMetadata(cropPoint, Blocks.field_150350_a, 0);
            nbcrop = 1;
            irrigation = villager.getTownHall().getVillageIrrigation();
            rand = Math.random();
            if (rand < (double)(irrigation / 100.0f)) {
                ++nbcrop;
            }
            villager.func_71038_i();
            villager.addToInv(Items.field_151120_aE, nbcrop);
        }
        return true;
    }

    @Override
    public int priority(MillVillager villager) {
        int p = 200 - villager.getTownHall().nbGoodAvailable(Items.field_151120_aE, 0, false, false) * 4;
        for (MillVillager v : villager.getTownHall().villagers) {
            if (!this.key.equals(v.goalKey)) continue;
            p /= 2;
        }
        return p;
    }
}

