/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.goal;

import java.util.HashMap;
import java.util.Vector;
import net.minecraft.item.ItemStack;
import org.millenaire.common.Building;
import org.millenaire.common.MLN;
import org.millenaire.common.MillVillager;
import org.millenaire.common.goal.Goal;
import org.millenaire.common.item.Goods;

public class GoalMerchantVisitBuilding
extends Goal {
    @Override
    public Goal.GoalInformation getDestination(MillVillager villager) throws Exception {
        for (Goods good : villager.getTownHall().culture.goodsVector) {
            if (villager.countInv(good.item.getItem(), good.item.meta) <= 0 || villager.getTownHall().nbGoodNeeded(good.item.getItem(), good.item.meta) <= 0) continue;
            if (MLN.LogMerchant >= 3) {
                MLN.debug(villager, "TH needs " + villager.getTownHall().nbGoodNeeded(good.item.getItem(), good.item.meta) + " good " + good.item.getName() + ", merchant has " + villager.countInv(good.item.getItem(), good.item.meta));
            }
            return this.packDest(villager.getTownHall().getSellingPos(), villager.getTownHall());
        }
        HashMap<Goods, Integer> neededGoods = villager.getTownHall().getImportsNeededbyOtherVillages();
        for (Building shop : villager.getTownHall().getBuildings()) {
            for (Goods good : villager.getTownHall().culture.goodsVector) {
                if (shop.isInn || shop.nbGoodAvailable(good.item.getItem(), good.item.meta, true, false) <= 0 || !neededGoods.containsKey(good) || neededGoods.get(good) <= villager.getHouse().countGoods(good.item.getItem(), good.item.meta) + villager.countInv(good.item.getItem(), good.item.meta)) continue;
                if (MLN.LogMerchant >= 3) {
                    MLN.debug(villager, "Shop " + shop + " has " + shop.nbGoodAvailable(good.item.getItem(), good.item.meta, true, false) + " good to pick up.");
                }
                return this.packDest(shop.getSellingPos(), shop);
            }
        }
        return null;
    }

    @Override
    public ItemStack[] getHeldItemsTravelling(MillVillager villager) {
        Vector<ItemStack> items = new Vector<ItemStack>();
        for (MillVillager.InvItem item : villager.getInventoryKeys()) {
            if (villager.countInv(item) <= 0) continue;
            items.add(new ItemStack(item.getItem(), 1, item.meta));
        }
        return items.toArray(new ItemStack[items.size()]);
    }

    @Override
    public boolean isPossibleSpecific(MillVillager villager) throws Exception {
        return this.getDestination(villager) != null;
    }

    @Override
    public boolean performAction(MillVillager villager) throws Exception {
        Building shop = villager.getGoalBuildingDest();
        HashMap<Goods, Integer> neededGoods = villager.getTownHall().getImportsNeededbyOtherVillages();
        if (shop == null || shop.isInn) {
            return true;
        }
        if (shop.isTownhall) {
            for (Goods good : villager.getTownHall().culture.goodsVector) {
                int nb;
                int nbNeeded = shop.nbGoodNeeded(good.item.getItem(), good.item.meta);
                if (nbNeeded <= 0 || (nb = villager.putInBuilding(shop, good.item.getItem(), good.item.meta, nbNeeded)) <= 0 || MLN.LogMerchant < 2) continue;
                MLN.minor(shop, villager + " delivered " + nb + " " + good.getName() + ".");
            }
        }
        for (Goods good : villager.getTownHall().culture.goodsVector) {
            if (!neededGoods.containsKey(good) || shop.nbGoodAvailable(good.item.getItem(), good.item.meta, true, false) <= 0 || villager.getHouse().countGoods(good.item.getItem(), good.item.meta) + villager.countInv(good.item.getItem(), good.item.meta) >= neededGoods.get(good)) continue;
            int nb = Math.min(shop.nbGoodAvailable(good.item.getItem(), good.item.meta, true, false), neededGoods.get(good) - villager.getHouse().countGoods(good.item.getItem(), good.item.meta) - villager.countInv(good.item.getItem(), good.item.meta));
            nb = villager.takeFromBuilding(shop, good.item.getItem(), good.item.meta, nb);
            if (MLN.LogMerchant < 2) continue;
            MLN.minor(shop, villager + " took " + nb + " " + good.getName() + " for trading.");
        }
        return true;
    }

    @Override
    public int priority(MillVillager villager) throws Exception {
        return 100;
    }
}

