/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.network;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import io.netty.buffer.ByteBufInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import org.millenaire.common.Building;
import org.millenaire.common.Culture;
import org.millenaire.common.GuiActions;
import org.millenaire.common.MLN;
import org.millenaire.common.MillVillager;
import org.millenaire.common.MillWorld;
import org.millenaire.common.Point;
import org.millenaire.common.construction.BuildingPlan;
import org.millenaire.common.construction.BuildingProject;
import org.millenaire.common.core.DevModUtilities;
import org.millenaire.common.forge.Mill;
import org.millenaire.common.network.ServerSender;
import org.millenaire.common.network.StreamReadWrite;

public class ServerReceiver {
    public static final String PACKET_CHANNEL = "millenaire";
    public static final int PACKET_BUILDING = 2;
    public static final int PACKET_VILLAGER = 3;
    public static final int PACKET_MILLCHEST = 5;
    public static final int PACKET_MAPINFO = 7;
    public static final int PACKET_VILLAGELIST = 9;
    public static final int PACKET_SERVER_CONTENT = 10;
    public static final int PACKET_SHOP = 11;
    public static final int PACKET_TRANSLATED_CHAT = 100;
    public static final int PACKET_PROFILE = 101;
    public static final int PACKET_QUESTINSTANCE = 102;
    public static final int PACKET_QUESTINSTANCEDELETE = 103;
    public static final int PACKET_OPENGUI = 104;
    public static final int PACKET_PANELUPDATE = 106;
    public static final int PACKET_ANIMALBREED = 107;
    public static final int PACKET_VILLAGER_SENTENCE = 108;
    public static final int PACKET_GUIACTION = 200;
    public static final int PACKET_VILLAGELIST_REQUEST = 201;
    public static final int PACKET_DECLARERELEASENUMBER = 202;
    public static final int PACKET_MAPINFO_REQUEST = 203;
    public static final int PACKET_VILLAGERINTERACT_REQUEST = 204;
    public static final int PACKET_AVAILABLECONTENT = 205;
    public static final int PACKET_DEVCOMMAND = 206;
    public static final int GUIACTION_CHIEF_BUILDING = 1;
    public static final int GUIACTION_CHIEF_CROP = 2;
    public static final int GUIACTION_CHIEF_CONTROL = 3;
    public static final int GUIACTION_CHIEF_DIPLOMACY = 4;
    public static final int GUIACTION_CHIEF_SCROLL = 5;
    public static final int GUIACTION_QUEST_COMPLETESTEP = 10;
    public static final int GUIACTION_QUEST_REFUSE = 11;
    public static final int GUIACTION_NEWVILLAGE = 20;
    public static final int GUIACTION_HIRE_HIRE = 30;
    public static final int GUIACTION_HIRE_EXTEND = 31;
    public static final int GUIACTION_HIRE_RELEASE = 32;
    public static final int GUIACTION_NEGATION_WAND = 40;
    public static final int GUIACTION_NEW_BUILDING_PROJECT = 50;
    public static final int GUIACTION_PUJAS_CHANGE_ENCHANTMENT = 60;
    public static final int GUIACTION_CONTROLLEDBUILDING_TOGGLEALLOWED = 70;
    public static final int GUIACTION_CONTROLLEDBUILDING_FORGET = 71;
    public static final int GUIACTION_SUMMONINGWANDUSE = 80;
    public static final int GUIACTION_MILLCHESTACTIVATE = 81;
    public static final int GUIACTION_IMPORTBUILDING = 82;
    public static final int GUIACTION_MILITARY_RELATIONS = 90;
    public static final int GUIACTION_MILITARY_RAID = 91;
    public static final int GUIACTION_MILITARY_CANCEL_RAID = 92;
    public static final int DEV_COMMAND_TOGGLE_AUTO_MOVE = 1;
    public static final int DEV_COMMAND_TEST_PATH = 2;

    @SubscribeEvent
    public void onPacketData(FMLNetworkEvent.ServerCustomPacketEvent event) {
        if (Mill.serverWorlds.size() == 0) {
            return;
        }
        ByteBufInputStream dataStream = new ByteBufInputStream(event.packet.payload());
        EntityPlayerMP sender = ((NetHandlerPlayServer)event.handler).field_147369_b;
        MillWorld mw = Mill.getMillWorld(sender.field_70170_p);
        if (mw == null) {
            mw = Mill.serverWorlds.firstElement();
        }
        if (mw == null) {
            MLN.error(this, "ServerReceiver.onPacketData: could not find MillWorld.");
        }
        try {
            int packettype = dataStream.read();
            if (MLN.LogNetwork >= 3) {
                MLN.debug(this, "Receiving packet type " + packettype);
            }
            if (packettype == 200) {
                this.readGuiActionPacket((EntityPlayer)sender, dataStream);
            } else if (packettype == 203) {
                this.readMapInfoRequestPacket((EntityPlayer)sender, dataStream);
            } else if (packettype == 201) {
                mw.displayVillageList((EntityPlayer)sender, dataStream.readBoolean());
            } else if (packettype == 202) {
                mw.getProfile(sender.getDisplayName()).receiveDeclareReleaseNumberPacket(dataStream);
            } else if (packettype == 204) {
                this.readVillagerInteractRequestPacket((EntityPlayer)sender, dataStream);
            } else if (packettype == 205) {
                this.readAvailableContentPacket((EntityPlayer)sender, dataStream);
            } else if (packettype == 206) {
                this.readDevCommandPacket((EntityPlayer)sender, dataStream);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readAvailableContentPacket(EntityPlayer player, ByteBufInputStream ds) {
        HashMap<String, Integer> nbStrings = new HashMap<String, Integer>();
        HashMap<String, Integer> nbBuildingNames = new HashMap<String, Integer>();
        HashMap<String, Integer> nbSentences = new HashMap<String, Integer>();
        HashMap<String, Integer> nbFallbackStrings = new HashMap<String, Integer>();
        HashMap<String, Integer> nbFallbackBuildingNames = new HashMap<String, Integer>();
        HashMap<String, Integer> nbFallbackSentences = new HashMap<String, Integer>();
        HashMap planSets = new HashMap();
        HashMap villagers = new HashMap();
        HashMap villages = new HashMap();
        HashMap lonebuildings = new HashMap();
        try {
            String clientMainLanguage = ds.readUTF();
            String clientFallbackLanguage = ds.readUTF();
            int nbCultures = ds.readShort();
            for (int i = 0; i < nbCultures; ++i) {
                int j;
                String key = ds.readUTF();
                nbStrings.put(key, Integer.valueOf(ds.readShort()));
                nbBuildingNames.put(key, Integer.valueOf(ds.readShort()));
                nbSentences.put(key, Integer.valueOf(ds.readShort()));
                nbFallbackStrings.put(key, Integer.valueOf(ds.readShort()));
                nbFallbackBuildingNames.put(key, Integer.valueOf(ds.readShort()));
                nbFallbackSentences.put(key, Integer.valueOf(ds.readShort()));
                Vector<String> v = new Vector<String>();
                int nb = ds.readShort();
                for (j = 0; j < nb; ++j) {
                    v.add(ds.readUTF());
                }
                planSets.put(key, v);
                v = new Vector();
                nb = ds.readShort();
                for (j = 0; j < nb; ++j) {
                    v.add(ds.readUTF());
                }
                villagers.put(key, v);
                v = new Vector();
                nb = ds.readShort();
                for (j = 0; j < nb; ++j) {
                    v.add(ds.readUTF());
                }
                villages.put(key, v);
                v = new Vector();
                nb = ds.readShort();
                for (j = 0; j < nb; ++j) {
                    v.add(ds.readUTF());
                }
                lonebuildings.put(key, v);
            }
            DataOutput data = ServerSender.getNewByteBufOutputStream();
            data.write(10);
            data.writeShort(Culture.vectorCultures.size());
            for (Culture culture : Culture.vectorCultures) {
                if (!nbStrings.containsKey(culture.key)) {
                    culture.writeCultureMissingContentPackPacket(data, clientMainLanguage, clientFallbackLanguage, 0, 0, 0, 0, 0, 0, null, null, null, null);
                    continue;
                }
                culture.writeCultureMissingContentPackPacket(data, clientMainLanguage, clientFallbackLanguage, (Integer)nbStrings.get(culture.key), (Integer)nbBuildingNames.get(culture.key), (Integer)nbSentences.get(culture.key), (Integer)nbFallbackStrings.get(culture.key), (Integer)nbFallbackBuildingNames.get(culture.key), (Integer)nbFallbackSentences.get(culture.key), (Vector)planSets.get(culture.key), (Vector)villagers.get(culture.key), (Vector)villages.get(culture.key), (Vector)lonebuildings.get(culture.key));
            }
            ServerSender.createAndSendPacketToPlayer(data, player);
        }
        catch (IOException e) {
            MLN.printException("Error in readAvailableContentPacket: ", e);
        }
    }

    private void readDevCommandPacket(EntityPlayer player, ByteBufInputStream data) {
        try {
            int commandId = data.read();
            if (commandId == 1) {
                DevModUtilities.toggleAutoMove(player);
            } else if (commandId == 2) {
                DevModUtilities.testPaths(player);
            }
        }
        catch (IOException e) {
            MLN.printException(e);
        }
    }

    private void readGuiActionPacket(EntityPlayer player, ByteBufInputStream data) {
        MillWorld mw = Mill.getMillWorld(player.field_70170_p);
        try {
            int guiActionId = data.read();
            if (guiActionId == 1) {
                MillVillager v = mw.villagers.get(data.readLong());
                if (v != null) {
                    GuiActions.villageChiefPerformBuilding(player, v, data.readUTF());
                } else {
                    MLN.error(this, "Unknown villager id in readGUIPacket: " + guiActionId);
                }
            } else if (guiActionId == 2) {
                MillVillager v = mw.villagers.get(data.readLong());
                if (v != null) {
                    GuiActions.villageChiefPerformCrop(player, v, data.readUTF());
                } else {
                    MLN.error(this, "Unknown villager id in readGUIPacket: " + guiActionId);
                }
            } else if (guiActionId == 3) {
                MillVillager v = mw.villagers.get(data.readLong());
                if (v != null) {
                    GuiActions.villageChiefPerformCultureControl(player, v);
                } else {
                    MLN.error(this, "Unknown villager id in readGUIPacket: " + guiActionId);
                }
            } else if (guiActionId == 4) {
                MillVillager v = mw.villagers.get(data.readLong());
                if (v != null) {
                    GuiActions.villageChiefPerformDiplomacy(player, v, StreamReadWrite.readNullablePoint((DataInput)data), data.readBoolean());
                } else {
                    MLN.error(this, "Unknown villager id in readGUIPacket: " + guiActionId);
                }
            } else if (guiActionId == 5) {
                long vid = data.readLong();
                MillVillager v = mw.villagers.get(vid);
                if (v != null) {
                    GuiActions.villageChiefPerformVillageScroll(player, v);
                } else {
                    MLN.error(this, "Unknown villager id in readGUIPacket: " + vid);
                }
            } else if (guiActionId == 10) {
                long vid = data.readLong();
                MillVillager v = mw.villagers.get(vid);
                if (v != null) {
                    GuiActions.questCompleteStep(player, v);
                } else {
                    MLN.error(this, "Unknown villager id in readGUIPacket: " + vid);
                }
            } else if (guiActionId == 11) {
                long vid = data.readLong();
                MillVillager v = mw.villagers.get(vid);
                if (v != null) {
                    GuiActions.questRefuse(player, v);
                } else {
                    MLN.error(this, "Unknown villager id in readGUIPacket: " + vid);
                }
            } else if (guiActionId == 20) {
                String cultureKey = data.readUTF();
                String villageType = data.readUTF();
                Point pos = StreamReadWrite.readNullablePoint((DataInput)data);
                GuiActions.newVillageCreation(player, pos, cultureKey, villageType);
            } else if (guiActionId == 40) {
                Point pos = StreamReadWrite.readNullablePoint((DataInput)data);
                Building th = mw.getBuilding(pos);
                if (th != null) {
                    GuiActions.useNegationWand(player, th);
                }
            } else if (guiActionId == 80) {
                Point pos = StreamReadWrite.readNullablePoint((DataInput)data);
                GuiActions.useSummoningWand(player, pos);
            } else if (guiActionId == 82) {
                Point pos = StreamReadWrite.readNullablePoint((DataInput)data);
                EntityPlayerMP playerMP = (EntityPlayerMP)player;
                if (!Mill.proxy.isTrueServer() || playerMP.field_71133_b.func_71203_ab().func_72353_e(playerMP.getDisplayName())) {
                    BuildingPlan.importBuilding(player, Mill.serverWorlds.firstElement().world, pos);
                } else {
                    ServerSender.sendTranslatedSentence(player, '4', "ui.serverimportforbidden", new String[0]);
                }
            } else if (guiActionId == 81) {
                Point pos = StreamReadWrite.readNullablePoint((DataInput)data);
                GuiActions.activateMillChest(player, pos);
            } else if (guiActionId == 60) {
                Point pos = StreamReadWrite.readNullablePoint((DataInput)data);
                Building temple = mw.getBuilding(pos);
                if (temple != null && temple.pujas != null) {
                    GuiActions.pujasChangeEnchantment(player, temple, data.readShort());
                }
            } else if (guiActionId == 50) {
                Point thPos = StreamReadWrite.readNullablePoint((DataInput)data);
                Point pos = StreamReadWrite.readNullablePoint((DataInput)data);
                String planKey = data.readUTF();
                Building th = mw.getBuilding(thPos);
                if (th != null) {
                    GuiActions.newBuilding(player, th, pos, planKey);
                }
            } else if (guiActionId == 70) {
                Point thPos = StreamReadWrite.readNullablePoint((DataInput)data);
                String projectKey = data.readUTF();
                Point projectPos = StreamReadWrite.readNullablePoint((DataInput)data);
                boolean allow = data.readBoolean();
                Building th = mw.getBuilding(thPos);
                if (th != null) {
                    BuildingProject project = null;
                    for (BuildingProject p : th.getFlatProjectList()) {
                        if (!p.key.equals(projectKey) || p.location == null || !p.location.pos.equals(projectPos)) continue;
                        project = p;
                    }
                    if (project != null) {
                        GuiActions.controlledBuildingsToggleUpgrades(player, th, project, allow);
                    }
                }
            } else if (guiActionId == 71) {
                Point thPos = StreamReadWrite.readNullablePoint((DataInput)data);
                String projectKey = data.readUTF();
                Point projectPos = StreamReadWrite.readNullablePoint((DataInput)data);
                Building th = mw.getBuilding(thPos);
                if (th != null) {
                    BuildingProject project = null;
                    for (BuildingProject p : th.getFlatProjectList()) {
                        if (!p.key.equals(projectKey) || p.location == null || !p.location.pos.equals(projectPos)) continue;
                        project = p;
                    }
                    if (project != null) {
                        GuiActions.controlledBuildingsForgetBuilding(player, th, project);
                    }
                }
            } else if (guiActionId == 30) {
                long vid = data.readLong();
                MillVillager v = mw.villagers.get(vid);
                if (v != null) {
                    GuiActions.hireHire(player, v);
                } else {
                    MLN.error(this, "Unknown villager id in readGUIPacket: " + vid);
                }
            } else if (guiActionId == 31) {
                long vid = data.readLong();
                MillVillager v = mw.villagers.get(vid);
                if (v != null) {
                    GuiActions.hireExtend(player, v);
                } else {
                    MLN.error(this, "Unknown villager id in readGUIPacket: " + vid);
                }
            } else if (guiActionId == 32) {
                long vid = data.readLong();
                MillVillager v = mw.villagers.get(vid);
                if (v != null) {
                    GuiActions.hireRelease(player, v);
                } else {
                    MLN.error(this, "Unknown villager id in readGUIPacket: " + vid);
                }
            } else if (guiActionId == 90) {
                Point thPos = StreamReadWrite.readNullablePoint((DataInput)data);
                Point targetpos = StreamReadWrite.readNullablePoint((DataInput)data);
                int amount = data.readInt();
                Building th = mw.getBuilding(thPos);
                if (th != null) {
                    GuiActions.controlledMilitaryDiplomacy(player, th, targetpos, amount);
                }
            } else if (guiActionId == 91) {
                Point thPos = StreamReadWrite.readNullablePoint((DataInput)data);
                Point targetpos = StreamReadWrite.readNullablePoint((DataInput)data);
                Building th = mw.getBuilding(thPos);
                Building target = mw.getBuilding(targetpos);
                if (th != null) {
                    GuiActions.controlledMilitaryPlanRaid(player, th, target);
                }
            } else if (guiActionId == 92) {
                Point thPos = StreamReadWrite.readNullablePoint((DataInput)data);
                Building th = mw.getBuilding(thPos);
                if (th != null) {
                    GuiActions.controlledMilitaryCancelRaid(player, th);
                }
            } else {
                MLN.error(null, "Unknown Gui action: " + guiActionId);
            }
        }
        catch (IOException e) {
            MLN.printException(e);
        }
    }

    private void readMapInfoRequestPacket(EntityPlayer player, ByteBufInputStream data) {
        MillWorld mw = Mill.getMillWorld(player.field_70170_p);
        try {
            Point p = StreamReadWrite.readNullablePoint((DataInput)data);
            Building townhall = mw.getBuilding(p);
            if (townhall != null) {
                townhall.sendMapInfo(player);
            }
        }
        catch (IOException e) {
            MLN.printException(e);
        }
    }

    private void readVillagerInteractRequestPacket(EntityPlayer player, ByteBufInputStream data) {
        MillWorld mw = Mill.getMillWorld(player.field_70170_p);
        try {
            long vid = data.readLong();
            if (mw.villagers.containsKey(vid)) {
                mw.villagers.get(vid).interactSpecial(player);
            }
        }
        catch (IOException e) {
            MLN.printException(e);
        }
    }
}

