/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.network;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Random;
import java.util.Vector;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.millenaire.common.Building;
import org.millenaire.common.BuildingLocation;
import org.millenaire.common.Culture;
import org.millenaire.common.MillVillager;
import org.millenaire.common.MillWorld;
import org.millenaire.common.Point;
import org.millenaire.common.PujaSacrifice;
import org.millenaire.common.Quest;
import org.millenaire.common.UserProfile;
import org.millenaire.common.VillagerRecord;
import org.millenaire.common.construction.BuildingPlan;
import org.millenaire.common.construction.BuildingProject;
import org.millenaire.common.core.MillCommonUtilities;
import org.millenaire.common.item.Goods;

public class StreamReadWrite {
    public static Random random;

    public static BuildingPlan readBuildingPlanInfo(DataInput ds, Culture culture) throws IOException {
        String key = ds.readUTF();
        int level = ds.readInt();
        int variation = ds.readInt();
        BuildingPlan plan = new BuildingPlan(key, level, variation, culture);
        plan.planName = StreamReadWrite.readNullableString(ds);
        plan.nativeName = StreamReadWrite.readNullableString(ds);
        plan.requiredTag = StreamReadWrite.readNullableString(ds);
        plan.shop = StreamReadWrite.readNullableString(ds);
        plan.type = StreamReadWrite.readNullableString(ds);
        plan.price = ds.readInt();
        plan.reputation = ds.readInt();
        plan.maleResident = StreamReadWrite.readStringVector(ds);
        plan.femaleResident = StreamReadWrite.readStringVector(ds);
        plan.startingSubBuildings = StreamReadWrite.readStringVector(ds);
        plan.subBuildings = StreamReadWrite.readStringVector(ds);
        plan.tags = StreamReadWrite.readStringVector(ds);
        return plan;
    }

    public static HashMap<MillVillager.InvItem, Integer> readInventory(DataInput ds) throws IOException {
        HashMap<MillVillager.InvItem, Integer> inv = new HashMap<MillVillager.InvItem, Integer>();
        int nb = ds.readInt();
        for (int i = 0; i < nb; ++i) {
            MillVillager.InvItem item = new MillVillager.InvItem(Item.func_150899_d((int)ds.readInt()), ds.readInt());
            inv.put(item, ds.readInt());
        }
        return inv;
    }

    private static ItemStack readItemStack(DataInput par1DataInput) throws IOException {
        ItemStack is = null;
        int id = par1DataInput.readInt();
        if (id >= 0) {
            byte nb = par1DataInput.readByte();
            short meta = par1DataInput.readShort();
            is = new ItemStack(Item.func_150899_d((int)id), (int)nb, (int)meta);
            if (is.func_77973_b().func_77645_m()) {
                is.field_77990_d = StreamReadWrite.readNBTTagCompound(par1DataInput);
            }
        }
        return is;
    }

    private static NBTTagCompound readNBTTagCompound(DataInput par1DataInput) throws IOException {
        short var2 = par1DataInput.readShort();
        if (var2 < 0) {
            return null;
        }
        byte[] var3 = new byte[var2];
        par1DataInput.readFully(var3);
        return CompressedStreamTools.func_74792_a((byte[])var3);
    }

    public static BuildingLocation readNullableBuildingLocation(DataInput ds) throws IOException {
        boolean isnull = ds.readBoolean();
        if (isnull) {
            return null;
        }
        BuildingLocation bl = new BuildingLocation();
        bl.key = StreamReadWrite.readNullableString(ds);
        bl.shop = StreamReadWrite.readNullableString(ds);
        bl.maleResident = StreamReadWrite.readStringVector(ds);
        bl.femaleResident = StreamReadWrite.readStringVector(ds);
        bl.minx = ds.readInt();
        bl.maxx = ds.readInt();
        bl.minz = ds.readInt();
        bl.maxz = ds.readInt();
        bl.minxMargin = ds.readInt();
        bl.maxxMargin = ds.readInt();
        bl.minzMargin = ds.readInt();
        bl.maxzMargin = ds.readInt();
        bl.orientation = ds.readInt();
        bl.length = ds.readInt();
        bl.width = ds.readInt();
        bl.areaToClear = ds.readInt();
        bl.level = ds.readInt();
        bl.setVariation(ds.readInt());
        bl.reputation = ds.readInt();
        bl.price = ds.readInt();
        bl.pos = StreamReadWrite.readNullablePoint(ds);
        bl.chestPos = StreamReadWrite.readNullablePoint(ds);
        bl.sleepingPos = StreamReadWrite.readNullablePoint(ds);
        bl.sellingPos = StreamReadWrite.readNullablePoint(ds);
        bl.craftingPos = StreamReadWrite.readNullablePoint(ds);
        bl.shelterPos = StreamReadWrite.readNullablePoint(ds);
        bl.defendingPos = StreamReadWrite.readNullablePoint(ds);
        String cultureKey = StreamReadWrite.readNullableString(ds);
        bl.culture = Culture.getCultureByName(cultureKey);
        bl.tags = StreamReadWrite.readStringVector(ds);
        bl.subBuildings = StreamReadWrite.readStringVector(ds);
        bl.showTownHallSigns = ds.readBoolean();
        bl.upgradesAllowed = ds.readBoolean();
        bl.bedrocklevel = ds.readBoolean();
        return bl;
    }

    public static BuildingProject readNullableBuildingProject(DataInput ds, Culture culture) throws IOException {
        boolean isnull = ds.readBoolean();
        if (isnull) {
            return null;
        }
        BuildingProject bp = new BuildingProject();
        bp.key = StreamReadWrite.readNullableString(ds);
        bp.location = StreamReadWrite.readNullableBuildingLocation(ds);
        if (culture != null) {
            bp.planSet = culture.getBuildingPlanSet(bp.key);
        }
        return bp;
    }

    public static ItemStack readNullableItemStack(DataInput ds) throws IOException {
        boolean isnull = ds.readBoolean();
        if (isnull) {
            return null;
        }
        return StreamReadWrite.readItemStack(ds);
    }

    public static Point readNullablePoint(DataInput ds) throws IOException {
        boolean isnull = ds.readBoolean();
        if (isnull) {
            return null;
        }
        int x = ds.readInt();
        int y = ds.readInt();
        int z = ds.readInt();
        return new Point(x, y, z);
    }

    public static Quest.QuestInstance readNullableQuestInstance(MillWorld mw, DataInput ds) throws IOException {
        boolean isnull = ds.readBoolean();
        if (isnull) {
            return null;
        }
        long id = ds.readLong();
        String questKey = ds.readUTF();
        if (!Quest.quests.containsKey(questKey)) {
            return null;
        }
        Quest quest = Quest.quests.get(questKey);
        UserProfile profile = mw.getProfile(ds.readUTF());
        int currentStep = ds.readUnsignedByte();
        long startTime = ds.readLong();
        long currentStepStart = ds.readLong();
        HashMap<String, Quest.QuestInstanceVillager> villagers = new HashMap<String, Quest.QuestInstanceVillager>();
        int nb = ds.readUnsignedByte();
        for (int i = 0; i < nb; ++i) {
            String key = ds.readUTF();
            villagers.put(key, StreamReadWrite.readNullableQuestVillager(mw, ds));
        }
        Quest.QuestInstance qi = new Quest.QuestInstance(mw, quest, profile, villagers, startTime, currentStep, currentStepStart);
        qi.uniqueid = id;
        return qi;
    }

    public static Quest.QuestInstanceVillager readNullableQuestVillager(MillWorld mw, DataInput ds) throws IOException {
        boolean isnull = ds.readBoolean();
        if (isnull) {
            return null;
        }
        return new Quest.QuestInstanceVillager(mw, StreamReadWrite.readNullablePoint(ds), ds.readLong());
    }

    public static String readNullableString(DataInput ds) throws IOException {
        boolean isnull = ds.readBoolean();
        if (isnull) {
            return null;
        }
        return ds.readUTF();
    }

    public static ResourceLocation readNullableResourceLocation(DataInput ds) throws IOException {
        boolean isnull = ds.readBoolean();
        if (isnull) {
            return null;
        }
        return new ResourceLocation("millenaire", ds.readUTF());
    }

    public static VillagerRecord readNullableVillagerRecord(MillWorld mw, DataInput ds) throws IOException {
        boolean isnull = ds.readBoolean();
        if (isnull) {
            return null;
        }
        VillagerRecord vr = new VillagerRecord(mw);
        vr.id = ds.readLong();
        vr.type = StreamReadWrite.readNullableString(ds);
        vr.firstName = StreamReadWrite.readNullableString(ds);
        vr.familyName = StreamReadWrite.readNullableString(ds);
        vr.nameKey = StreamReadWrite.readNullableString(ds);
        vr.occupation = StreamReadWrite.readNullableString(ds);
        vr.texture = StreamReadWrite.readNullableResourceLocation(ds);
        vr.nb = ds.readInt();
        vr.gender = ds.readInt();
        vr.villagerSize = ds.readInt();
        vr.culture = Culture.getCultureByName(StreamReadWrite.readNullableString(ds));
        vr.fathersName = StreamReadWrite.readNullableString(ds);
        vr.mothersName = StreamReadWrite.readNullableString(ds);
        vr.spousesName = StreamReadWrite.readNullableString(ds);
        vr.maidenName = StreamReadWrite.readNullableString(ds);
        vr.killed = ds.readBoolean();
        vr.raidingVillage = ds.readBoolean();
        vr.awayraiding = ds.readBoolean();
        vr.awayhired = ds.readBoolean();
        vr.housePos = StreamReadWrite.readNullablePoint(ds);
        vr.townHallPos = StreamReadWrite.readNullablePoint(ds);
        vr.originalVillagePos = StreamReadWrite.readNullablePoint(ds);
        vr.raiderSpawn = ds.readLong();
        vr.inventory = StreamReadWrite.readInventory(ds);
        vr.questTags = StreamReadWrite.readStringVector(ds);
        return vr;
    }

    public static PujaSacrifice readOrUpdateNullablePuja(DataInput ds, Building b, PujaSacrifice puja) throws IOException {
        boolean isnull = ds.readBoolean();
        if (isnull) {
            return null;
        }
        short type = ds.readShort();
        if (puja == null) {
            puja = new PujaSacrifice(b, type);
        }
        short enchantmentId = ds.readShort();
        for (int i = 0; i < puja.getTargets().size(); ++i) {
            if (puja.getTargets().get((int)i).enchantment.field_77352_x != enchantmentId) continue;
            puja.currentTarget = puja.getTargets().get(i);
        }
        puja.pujaProgress = ds.readShort();
        puja.offeringNeeded = ds.readShort();
        puja.offeringProgress = ds.readShort();
        return puja;
    }

    public static HashMap<Point, Integer> readPointIntegerMap(DataInput ds) throws IOException {
        HashMap<Point, Integer> map = new HashMap<Point, Integer>();
        int nb = ds.readInt();
        for (int i = 0; i < nb; ++i) {
            Point p = StreamReadWrite.readNullablePoint(ds);
            map.put(p, ds.readInt());
        }
        return map;
    }

    public static Vector<Point> readPointVector(DataInput ds) throws IOException {
        Vector<Point> v = new Vector<Point>();
        int nb = ds.readInt();
        for (int i = 0; i < nb; ++i) {
            v.add(StreamReadWrite.readNullablePoint(ds));
        }
        return v;
    }

    public static Vector<Vector<BuildingProject>> readProjectVectorVector(DataInput ds, Culture culture) throws IOException {
        Vector<Vector<BuildingProject>> v = new Vector<Vector<BuildingProject>>();
        int nb = ds.readInt();
        for (int i = 0; i < nb; ++i) {
            int nb2 = ds.readInt();
            Vector<BuildingProject> v2 = new Vector<BuildingProject>();
            for (int j = 0; j < nb2; ++j) {
                v2.add(StreamReadWrite.readNullableBuildingProject(ds, culture));
            }
            v.add(v2);
        }
        return v;
    }

    public static String[][] readStringStringArray(DataInput ds) throws IOException {
        String[][] strings = new String[ds.readInt()][];
        for (int i = 0; i < strings.length; ++i) {
            String[] array = new String[ds.readInt()];
            for (int j = 0; j < array.length; ++j) {
                array[j] = StreamReadWrite.readNullableString(ds);
            }
            strings[i] = array;
        }
        return strings;
    }

    public static HashMap<String, String> readStringStringMap(DataInput ds) throws IOException {
        HashMap<String, String> v = new HashMap<String, String>();
        int nb = ds.readInt();
        for (int i = 0; i < nb; ++i) {
            String key = ds.readUTF();
            v.put(key, StreamReadWrite.readNullableString(ds));
        }
        return v;
    }

    public static HashMap<String, Vector<String>> readStringStringVectorMap(DataInput ds) throws IOException {
        HashMap<String, Vector<String>> v = new HashMap<String, Vector<String>>();
        int nb = ds.readInt();
        for (int i = 0; i < nb; ++i) {
            String key = ds.readUTF();
            v.put(key, StreamReadWrite.readStringVector(ds));
        }
        return v;
    }

    public static Vector<String> readStringVector(DataInput ds) throws IOException {
        Vector<String> v = new Vector<String>();
        int nb = ds.readInt();
        for (int i = 0; i < nb; ++i) {
            v.add(StreamReadWrite.readNullableString(ds));
        }
        return v;
    }

    public static Vector<VillagerRecord> readVillagerRecordVector(MillWorld mw, DataInput ds) throws IOException {
        Vector<VillagerRecord> v = new Vector<VillagerRecord>();
        int nb = ds.readInt();
        for (int i = 0; i < nb; ++i) {
            v.add(StreamReadWrite.readNullableVillagerRecord(mw, ds));
        }
        return v;
    }

    public static void writeBuildingPlanInfo(BuildingPlan plan, DataOutput data) throws IOException {
        data.writeUTF(plan.buildingKey);
        data.writeInt(plan.level);
        data.writeInt(plan.variation);
        StreamReadWrite.writeNullableString(plan.planName, data);
        StreamReadWrite.writeNullableString(plan.nativeName, data);
        StreamReadWrite.writeNullableString(plan.requiredTag, data);
        StreamReadWrite.writeNullableString(plan.shop, data);
        StreamReadWrite.writeNullableString(plan.type, data);
        data.writeInt(plan.price);
        data.writeInt(plan.reputation);
        StreamReadWrite.writeStringVector(plan.maleResident, data);
        StreamReadWrite.writeStringVector(plan.femaleResident, data);
        StreamReadWrite.writeStringVector(plan.startingSubBuildings, data);
        StreamReadWrite.writeStringVector(plan.subBuildings, data);
        StreamReadWrite.writeStringVector(plan.tags, data);
    }

    public static void writeInventory(HashMap<MillVillager.InvItem, Integer> inventory, DataOutput data) throws IOException {
        data.writeInt(inventory.size());
        for (MillVillager.InvItem key : inventory.keySet()) {
            data.writeInt(Item.func_150891_b((Item)key.getItem()));
            data.writeInt(key.meta);
            data.writeInt(inventory.get(key));
        }
    }

    private static void writeItemStack(ItemStack par1ItemStack, DataOutput par2DataOutput) throws IOException {
        if (par1ItemStack == null) {
            par2DataOutput.writeShort(-1);
        } else {
            par2DataOutput.writeInt(Item.func_150891_b((Item)par1ItemStack.func_77973_b()));
            par2DataOutput.writeByte(par1ItemStack.field_77994_a);
            par2DataOutput.writeShort(par1ItemStack.func_77960_j());
            if (par1ItemStack.func_77973_b().func_77645_m()) {
                StreamReadWrite.writeNBTTagCompound(par1ItemStack.field_77990_d, par2DataOutput);
            }
        }
    }

    private static void writeNBTTagCompound(NBTTagCompound par1NBTTagCompound, DataOutput par2DataOutput) throws IOException {
        if (par1NBTTagCompound == null) {
            par2DataOutput.writeShort(-1);
        } else {
            byte[] var3 = CompressedStreamTools.func_74798_a((NBTTagCompound)par1NBTTagCompound);
            par2DataOutput.writeShort((short)var3.length);
            par2DataOutput.write(var3);
        }
    }

    public static void writeNullableBuildingLocation(BuildingLocation bl, DataOutput data) throws IOException {
        data.writeBoolean(bl == null);
        if (bl != null) {
            StreamReadWrite.writeNullableString(bl.key, data);
            StreamReadWrite.writeNullableString(bl.shop, data);
            StreamReadWrite.writeStringVector(bl.maleResident, data);
            StreamReadWrite.writeStringVector(bl.femaleResident, data);
            data.writeInt(bl.minx);
            data.writeInt(bl.maxx);
            data.writeInt(bl.minz);
            data.writeInt(bl.maxz);
            data.writeInt(bl.minxMargin);
            data.writeInt(bl.maxxMargin);
            data.writeInt(bl.minzMargin);
            data.writeInt(bl.maxzMargin);
            data.writeInt(bl.orientation);
            data.writeInt(bl.length);
            data.writeInt(bl.width);
            data.writeInt(bl.areaToClear);
            data.writeInt(bl.level);
            data.writeInt(bl.getVariation());
            data.writeInt(bl.reputation);
            data.writeInt(bl.price);
            StreamReadWrite.writeNullablePoint(bl.pos, data);
            StreamReadWrite.writeNullablePoint(bl.chestPos, data);
            StreamReadWrite.writeNullablePoint(bl.sleepingPos, data);
            StreamReadWrite.writeNullablePoint(bl.sellingPos, data);
            StreamReadWrite.writeNullablePoint(bl.craftingPos, data);
            StreamReadWrite.writeNullablePoint(bl.shelterPos, data);
            StreamReadWrite.writeNullablePoint(bl.defendingPos, data);
            StreamReadWrite.writeNullableString(bl.culture.key, data);
            StreamReadWrite.writeStringVector(bl.tags, data);
            StreamReadWrite.writeStringVector(bl.subBuildings, data);
            data.writeBoolean(bl.showTownHallSigns);
            data.writeBoolean(bl.upgradesAllowed);
            data.writeBoolean(bl.bedrocklevel);
        }
    }

    public static void writeNullableBuildingProject(BuildingProject bp, DataOutput data) throws IOException {
        data.writeBoolean(bp == null);
        if (bp != null) {
            StreamReadWrite.writeNullableString(bp.key, data);
            StreamReadWrite.writeNullableBuildingLocation(bp.location, data);
        }
    }

    public static void writeNullableItemStack(ItemStack is, DataOutput data) throws IOException {
        data.writeBoolean(is == null);
        if (is != null) {
            StreamReadWrite.writeItemStack(is, data);
        }
    }

    public static void writeNullablePoint(Point p, DataOutput data) throws IOException {
        data.writeBoolean(p == null);
        if (p != null) {
            data.writeInt(p.getiX());
            data.writeInt(p.getiY());
            data.writeInt(p.getiZ());
        }
    }

    public static void writeNullableGoods(Goods g, DataOutput data) throws IOException {
        data.writeBoolean(g == null);
        if (g != null) {
            data.writeInt(Item.func_150891_b((Item)g.item.getItem()));
            data.writeByte(g.item.meta);
            StreamReadWrite.writeNullableString(g.requiredTag, data);
            StreamReadWrite.writeNullableString(g.desc, data);
            data.writeBoolean(g.autoGenerate);
            data.writeInt(g.minReputation);
        }
    }

    public static Goods readNullableGoods(DataInput ds) throws IOException {
        boolean isnull = ds.readBoolean();
        if (isnull) {
            return null;
        }
        MillVillager.InvItem iv = new MillVillager.InvItem(MillCommonUtilities.getItemById(ds.readInt()), (int)ds.readByte());
        Goods g = new Goods(iv);
        g.requiredTag = StreamReadWrite.readNullableString(ds);
        g.desc = StreamReadWrite.readNullableString(ds);
        g.autoGenerate = ds.readBoolean();
        g.minReputation = ds.readInt();
        return g;
    }

    public static void writeNullablePuja(PujaSacrifice puja, DataOutput data) throws IOException {
        data.writeBoolean(puja == null);
        if (puja != null) {
            data.writeShort(puja.type);
            if (puja.currentTarget != null) {
                data.writeShort(puja.currentTarget.enchantment.field_77352_x);
            } else {
                data.writeShort(0);
            }
            data.writeShort(puja.pujaProgress);
            data.writeShort(puja.offeringNeeded);
            data.writeShort(puja.offeringProgress);
        }
    }

    public static void writeNullableQuestInstance(Quest.QuestInstance qi, DataOutput ds) throws IOException {
        ds.writeBoolean(qi == null);
        if (qi != null) {
            ds.writeLong(qi.uniqueid);
            ds.writeUTF(qi.quest.key);
            ds.writeUTF(qi.profile.key);
            ds.writeByte(qi.currentStep);
            ds.writeLong(qi.startTime);
            ds.writeLong(qi.currentStepStart);
            ds.writeByte(qi.villagers.size());
            for (String key : qi.villagers.keySet()) {
                ds.writeUTF(key);
                StreamReadWrite.writeNullableQuestVillager(qi.villagers.get(key), ds);
            }
        }
    }

    public static void writeNullableQuestVillager(Quest.QuestInstanceVillager v, DataOutput data) throws IOException {
        data.writeBoolean(v == null);
        if (v != null) {
            StreamReadWrite.writeNullablePoint(v.townHall, data);
            data.writeLong(v.id);
        }
    }

    public static void writeNullableString(String s, DataOutput data) throws IOException {
        data.writeBoolean(s == null);
        if (s != null) {
            data.writeUTF(s);
        }
    }

    public static void writeNullableResourceLocation(ResourceLocation rs, DataOutput data) throws IOException {
        data.writeBoolean(rs == null);
        if (rs != null) {
            data.writeUTF(rs.func_110623_a());
        }
    }

    public static void writeNullableVillagerRecord(VillagerRecord vr, DataOutput data) throws IOException {
        data.writeBoolean(vr == null);
        if (vr != null) {
            data.writeLong(vr.id);
            StreamReadWrite.writeNullableString(vr.type, data);
            StreamReadWrite.writeNullableString(vr.firstName, data);
            StreamReadWrite.writeNullableString(vr.familyName, data);
            StreamReadWrite.writeNullableString(vr.nameKey, data);
            StreamReadWrite.writeNullableString(vr.occupation, data);
            StreamReadWrite.writeNullableResourceLocation(vr.texture, data);
            data.writeInt(vr.nb);
            data.writeInt(vr.gender);
            data.writeInt(vr.villagerSize);
            StreamReadWrite.writeNullableString(vr.culture.key, data);
            StreamReadWrite.writeNullableString(vr.fathersName, data);
            StreamReadWrite.writeNullableString(vr.mothersName, data);
            StreamReadWrite.writeNullableString(vr.spousesName, data);
            StreamReadWrite.writeNullableString(vr.maidenName, data);
            data.writeBoolean(vr.killed);
            data.writeBoolean(vr.raidingVillage);
            data.writeBoolean(vr.awayraiding);
            data.writeBoolean(vr.awayhired);
            StreamReadWrite.writeNullablePoint(vr.housePos, data);
            StreamReadWrite.writeNullablePoint(vr.townHallPos, data);
            StreamReadWrite.writeNullablePoint(vr.originalVillagePos, data);
            data.writeLong(vr.raiderSpawn);
            StreamReadWrite.writeInventory(vr.inventory, data);
            StreamReadWrite.writeStringVector(vr.questTags, data);
        }
    }

    public static void writePointIntegerMap(HashMap<Point, Integer> map, DataOutput data) throws IOException {
        data.writeInt(map.size());
        for (Point p : map.keySet()) {
            StreamReadWrite.writeNullablePoint(p, data);
            data.writeInt(map.get(p));
        }
    }

    public static void writePointVector(Vector<Point> points, DataOutput data) throws IOException {
        data.writeInt(points.size());
        for (Point p : points) {
            StreamReadWrite.writeNullablePoint(p, data);
        }
    }

    public static void writeProjectVectorVector(Vector<Vector<BuildingProject>> projects, DataOutput data) throws IOException {
        data.writeInt(projects.size());
        for (Vector<BuildingProject> vp : projects) {
            data.writeInt(vp.size());
            for (BuildingProject bp : vp) {
                StreamReadWrite.writeNullableBuildingProject(bp, data);
            }
        }
    }

    public static void writeStringStringArray(String[][] strings, DataOutput data) throws IOException {
        data.writeInt(strings.length);
        for (String[] array : strings) {
            data.writeInt(array.length);
            for (String s : array) {
                StreamReadWrite.writeNullableString(s, data);
            }
        }
    }

    public static void writeStringStringMap(HashMap<String, String> strings, DataOutput data) throws IOException {
        if (strings == null) {
            data.writeInt(0);
            return;
        }
        data.writeInt(strings.size());
        for (String s : strings.keySet()) {
            data.writeUTF(s);
            StreamReadWrite.writeNullableString(strings.get(s), data);
        }
    }

    public static void writeStringStringVectorMap(HashMap<String, Vector<String>> strings, DataOutput data) throws IOException {
        if (strings == null) {
            data.writeInt(0);
            return;
        }
        data.writeInt(strings.size());
        for (String key : strings.keySet()) {
            data.writeUTF(key);
            StreamReadWrite.writeStringVector(strings.get(key), data);
        }
    }

    public static void writeStringVector(Vector<String> strings, DataOutput data) throws IOException {
        data.writeInt(strings.size());
        for (String s : strings) {
            StreamReadWrite.writeNullableString(s, data);
        }
    }

    public static void writeVillagerRecordVector(Vector<VillagerRecord> vrecords, DataOutput data) throws IOException {
        data.writeInt(vrecords.size());
        for (VillagerRecord vr : vrecords) {
            StreamReadWrite.writeNullableVillagerRecord(vr, data);
        }
    }
}

