/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.pathing;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.world.World;
import org.millenaire.common.Building;
import org.millenaire.common.MLN;
import org.millenaire.common.MillVillager;
import org.millenaire.common.Point;
import org.millenaire.common.core.MillCommonUtilities;
import org.millenaire.common.forge.Mill;
import org.millenaire.common.pathing.PathingPathCalcTile;
import org.millenaire.common.pathing.PathingSurface;

public class PathingBinary {
    private PathingSurface surface;
    private int surfaceXstart;
    private int surfaceYstart;
    private int surfaceZstart;
    private final World world;
    private final HashMap<PathKey, CachedPath> cache;
    private static final String EOL = System.getProperty("line.separator");

    public PathingBinary(World world) {
        this.world = world;
        this.cache = new HashMap();
    }

    public List<PathPoint> calculatePath(Building building, MillVillager villager, Point start, Point dest, boolean extraLog) throws Exception {
        long startTime = System.nanoTime();
        PathKey key = new PathKey(start.getPathPoint(), dest.getPathPoint());
        if (this.cache.containsKey(key)) {
            if (this.cache.get(key) == null) {
                return null;
            }
            return this.cache.get((Object)key).path;
        }
        short[] startCoord = new short[]{(short)(start.getiX() - this.surfaceXstart), (short)(building.getAltitude(start.getiX(), start.getiZ()) - this.surfaceYstart - 1), (short)(start.getiZ() - this.surfaceZstart)};
        short[] endCoord = new short[]{(short)(dest.getiX() - this.surfaceXstart), (short)(building.getAltitude(dest.getiX(), dest.getiZ()) - this.surfaceYstart - 1), (short)(dest.getiZ() - this.surfaceZstart)};
        if ((startCoord = this.validatePoint(startCoord)) == null) {
            if (MLN.LogConnections >= 1) {
                MLN.major(this, "No valid start found from " + start + " to " + dest + " for " + villager + ": " + (double)(System.nanoTime() - startTime) / 1000000.0);
            }
            this.cache.put(key, null);
            return null;
        }
        if ((endCoord = this.validatePoint(endCoord)) == null) {
            if (MLN.LogConnections >= 1) {
                MLN.major(this, "No valid dest found from " + start + " to " + dest + " for " + villager + ": " + (double)(System.nanoTime() - startTime) / 1000000.0);
            }
            this.cache.put(key, null);
            return null;
        }
        if (MLN.LogConnections >= 1) {
            MLN.major(this, "Time to find start and end: " + (double)(System.nanoTime() - startTime) / 1000000.0);
        }
        startTime = System.nanoTime();
        if (MLN.DEV) {
            File file = new File(Mill.proxy.getBaseDir(), "paths_" + this.hashCode() + ".txt");
            FileWriter writer = new FileWriter(file, true);
            writer.write(startCoord[0] + "/" + startCoord[1] + "/" + startCoord[2] + ";" + endCoord[0] + "/" + endCoord[1] + "/" + endCoord[2] + EOL);
            writer.flush();
            writer.close();
        }
        LinkedList<short[]> binaryPath = this.surface.getPath(startCoord, endCoord);
        if (MLN.DEV) {
            File file = new File(Mill.proxy.getBaseDir(), "paths_" + this.hashCode() + ".txt");
            FileWriter writer = new FileWriter(file, true);
            writer.write("//result of getPath: " + (binaryPath == null ? "null" : Integer.valueOf(binaryPath.size())) + " time: " + (double)(System.nanoTime() - startTime) / 1000000.0 + EOL);
            writer.flush();
            writer.close();
        }
        if (MLN.LogConnections >= 1) {
            MLN.major(this, "Time to calculate path from " + start + " to " + dest + " for " + villager + " with binary pathing (result: " + (binaryPath == null ? "null" : Integer.valueOf(binaryPath.size())) + "): " + (double)(System.nanoTime() - startTime) / 1000000.0);
        }
        if (binaryPath == null || binaryPath.size() == 0) {
            this.cache.put(key, null);
            return null;
        }
        Vector<PathPoint> path = new Vector<PathPoint>();
        for (short[] p : binaryPath) {
            path.add(new PathPoint(p[0] + this.surfaceXstart, p[1] + this.surfaceYstart + 1, p[2] + this.surfaceZstart));
        }
        this.cache.put(key, new CachedPath(path));
        for (int i = 0; i < path.size() - 1; ++i) {
            this.cache.put(new PathKey(path.get(i), path.get(path.size() - 1)), new CachedPath(path.subList(i, path.size())));
        }
        return path;
    }

    public boolean isReady() {
        return this.surface != null;
    }

    public void updatePathing(Point centre, int hradius, int vradius) {
        long startTime = System.nanoTime();
        PathingPathCalcTile[][][] region = new PathingPathCalcTile[hradius * 2][vradius * 2][hradius * 2];
        this.surfaceXstart = centre.getiX() - hradius;
        this.surfaceYstart = centre.getiY() - vradius;
        this.surfaceZstart = centre.getiZ() - hradius;
        for (short i = 0; i < region.length; i = (short)((short)(i + 1))) {
            for (short j = 0; j < region[0].length; j = (short)((short)(j + 1))) {
                for (short k = 0; k < region[0][0].length; k = (short)((short)(k + 1))) {
                    Block block = this.world.func_147439_a(this.surfaceXstart + i, this.surfaceYstart + j, this.surfaceZstart + k);
                    region[i][j][k] = block == Blocks.field_150358_i || block == Blocks.field_150355_j || block == Blocks.field_150353_l || block == Blocks.field_150356_k || block == Blocks.field_150422_aJ ? new PathingPathCalcTile(false, false, new short[]{i, j, k}) : (block == Blocks.field_150350_a || !block.func_149637_q() ? null : new PathingPathCalcTile(true, false, new short[]{i, j, k}));
                }
            }
        }
        if (MLN.LogConnections >= 1) {
            MLN.major(this, "Time to generate region: " + (double)(System.nanoTime() - startTime) / 1000000.0);
        }
        startTime = System.nanoTime();
        this.surface = new PathingSurface(region, region[hradius][vradius][hradius]);
        if (MLN.LogConnections >= 1) {
            MLN.major(this, "Time taken to compute surface: " + (double)(System.nanoTime() - startTime) / 1000000.0);
        }
        if (MLN.DEV) {
            File file = new File(Mill.proxy.getBaseDir(), "region_" + this.hashCode() + ".txt");
            try {
                BufferedWriter writer = MillCommonUtilities.getWriter(file);
                writer.write(region.length + "/" + region[0].length + "/" + region[0][0].length + EOL);
                for (int j = 0; j < region[0].length; j = (int)((short)(j + 1))) {
                    writer.write(EOL);
                    for (int i = 0; i < region.length; i = (int)((short)(i + 1))) {
                        String s = "";
                        for (int k = 0; k < region[0][0].length; k = (int)((short)(k + 1))) {
                            s = region[i][j][k] == null ? s + "-" : (region[i][j][k].ladder ? s + "l" : (region[i][j][k].isWalkable ? s + "w" : s + "x"));
                        }
                        writer.write(s + EOL);
                    }
                }
                writer.flush();
                writer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.cache.clear();
    }

    private short[] validatePoint(short[] p) {
        int i;
        if (MLN.LogConnections >= 1) {
            MLN.major(this, "Validating point: " + p[0] + "/" + p[1] + "/" + p[2]);
        }
        this.writeLine(p[0] + "/" + p[1] + "/" + p[2]);
        boolean res = this.surface.contains(p);
        this.writeLine("//result of surface.contains: " + res);
        if (res) {
            return p;
        }
        short[] newP = new short[]{p[0], p[1], p[2]};
        for (i = 10; i > -10; i = (int)((short)(i - 1))) {
            newP[1] = (short)(p[1] + i);
            if (MLN.DEV) {
                this.writeLine(newP[0] + "/" + newP[1] + "/" + newP[2]);
            }
            res = this.surface.contains(newP);
            this.writeLine("//result of surface.contains: " + res);
            if (!res) continue;
            if (MLN.LogConnections >= 1) {
                MLN.major(this, "Found valid point. offset: " + i);
            }
            return newP;
        }
        for (i = -2; i < 3; i = (int)((short)(i + 1))) {
            newP[0] = (short)(p[0] + i);
            for (int j = -2; j < 3; j = (int)((short)(j + 1))) {
                newP[2] = (short)(p[2] + j);
                if (i == 0 && j == 0) continue;
                for (int k = 10; k > -10; k = (int)((short)(k - 1))) {
                    if (!MillCommonUtilities.isBlockIdSolid(this.world.func_147439_a(p[0] + i, p[1] + k, p[2] + j)) || MillCommonUtilities.isBlockIdSolid(this.world.func_147439_a(p[0] + i, p[1] + k + 1, p[2] + j)) || MillCommonUtilities.isBlockIdSolid(this.world.func_147439_a(p[0] + i, p[1] + k + 2, p[2] + j))) continue;
                    newP[1] = (short)(p[1] + k);
                    if (MLN.DEV) {
                        this.writeLine(newP[0] + "/" + newP[1] + "/" + newP[2]);
                        res = this.surface.contains(newP);
                        this.writeLine("//result of surface.contains: " + res);
                    }
                    if (!res) continue;
                    if (MLN.LogConnections >= 1) {
                        MLN.major(this, "Found valid point. offset: " + i + "/" + k + "/" + j);
                    }
                    return newP;
                }
            }
        }
        return null;
    }

    private void writeLine(String s) {
        try {
            File file = new File(Mill.proxy.getBaseDir(), "paths_" + this.hashCode() + ".txt");
            FileWriter writer = new FileWriter(file, true);
            writer.write(s + EOL);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class PathKey {
        static boolean log = false;
        PathPoint start;
        PathPoint end;
        int hash;

        PathKey(PathPoint start, PathPoint end) {
            this.start = start;
            this.end = end;
            this.hash = start.hashCode() + (end.hashCode() << 16);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof PathKey)) {
                return false;
            }
            PathKey p = (PathKey)obj;
            return this.hash == p.hash && this.start.equals((Object)p.start) && this.end.equals((Object)p.end);
        }

        public int hashCode() {
            return this.hash;
        }

        public String toString() {
            return this.start + ", " + this.end;
        }
    }

    public static class CachedPath {
        PathKey key;
        List<PathPoint> path;

        CachedPath(List<PathPoint> path) {
            this.path = path;
            this.key = new PathKey(path.get(0), path.get(path.size() - 1));
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CachedPath other = (CachedPath)obj;
            return this.key.equals(other.key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }
}

