/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.client;

import cpw.mods.fml.client.FMLClientHandler;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import org.millenaire.client.gui.DisplayActions;
import org.millenaire.client.gui.GuiPanelParchment;
import org.millenaire.client.gui.GuiText;
import org.millenaire.client.network.ClientSender;
import org.millenaire.common.Building;
import org.millenaire.common.Culture;
import org.millenaire.common.MLN;
import org.millenaire.common.MillVillager;
import org.millenaire.common.Point;
import org.millenaire.common.Quest;
import org.millenaire.common.TileEntityPanel;
import org.millenaire.common.UserProfile;
import org.millenaire.common.core.DevModUtilities;
import org.millenaire.common.core.MillCommonUtilities;
import org.millenaire.common.forge.Mill;
import org.millenaire.common.item.Goods;

public class MillClientUtilities {
    private static long lastPing = 0L;
    private static long lastFreeRes = 0L;
    private static final ResourceLocation textureTest = new ResourceLocation("millenaire", "textures/blocks/blockGold.png");

    public static void checkTextSize() {
        ITextureObject texture = Minecraft.func_71410_x().field_71446_o.func_110581_b(textureTest);
        if (texture == null) {
            return;
        }
        GL11.glBindTexture((int)3553, (int)texture.func_110552_b());
        int textSize = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
        if (textSize != MLN.textureSize) {
            MLN.textureSize = textSize;
            Minecraft.func_71410_x().field_71446_o.func_110550_d();
        }
    }

    public static void displayChunkPanel(World world, EntityPlayer player) {
        Vector<Vector<String>> pages = new Vector<Vector<String>>();
        Vector<String> page = new Vector<String>();
        page.add(MLN.string("chunk.chunkmap"));
        pages.add(page);
        page = new Vector();
        page.add(MLN.string("chunk.caption"));
        page.add(MLN.string(""));
        page.add(MLN.string("chunk.captiongeneral"));
        page.add(MLN.string("chunk.captiongreen"));
        page.add(MLN.string("chunk.captionblue"));
        page.add(MLN.string("chunk.captionpurple"));
        page.add(MLN.string("chunk.captionwhite"));
        page.add(MLN.string(""));
        page.add(MLN.string("chunk.playerposition", (int)player.field_70165_t + "/" + (int)player.field_70161_v));
        page.add(MLN.string(""));
        page.add(MLN.string("chunk.settings", "" + MLN.KeepActiveRadius, "" + ForgeChunkManager.getMaxTicketLengthFor((String)"millenaire")));
        page.add(MLN.string(""));
        page.add(MLN.string("chunk.explanations"));
        pages.add(page);
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiPanelParchment(player, pages, null, 2, true));
    }

    public static void displayTradeHelp(Building shop, EntityPlayer player) {
        Iterator i$;
        Vector<String> vprices;
        int p;
        Iterator i$2;
        Vector<String> vprices2;
        Vector<Integer> prices;
        Vector<Object> stacks;
        String lastDesc;
        Vector<Vector<GuiText.Line>> pages = new Vector<Vector<GuiText.Line>>();
        Vector<GuiText.Line> page = new Vector<GuiText.Line>();
        page.add(new GuiText.Line("<darkblue>" + MLN.string("tradehelp.title", shop.getNativeBuildingName())));
        page.add(new GuiText.Line(""));
        page.add(new GuiText.Line("<darkblue>" + MLN.string("tradehelp.goodssold")));
        page.add(new GuiText.Line(""));
        Vector<Goods> goods = shop.calculateSellingGoods(null);
        if (goods != null) {
            lastDesc = null;
            stacks = new Vector<ItemStack>();
            prices = new Vector<Integer>();
            for (Goods g : goods) {
                if (lastDesc != null && !lastDesc.equals(g.desc)) {
                    vprices2 = new Vector<String>();
                    i$2 = prices.iterator();
                    while (i$2.hasNext()) {
                        p = (Integer)i$2.next();
                        vprices2.add(MLN.string("tradehelp.sellingprice") + " " + MillCommonUtilities.getShortPrice(p));
                    }
                    page.add(new GuiText.Line(stacks, vprices2, MLN.string(lastDesc), 72));
                    page.add(new GuiText.Line());
                    stacks = new Vector();
                    prices = new Vector();
                }
                stacks.add(new ItemStack(g.item.item, 1, g.item.meta));
                prices.add(g.getBasicSellingPrice(shop));
                if (g.desc != null) {
                    lastDesc = g.desc;
                    continue;
                }
                lastDesc = "";
            }
            if (lastDesc != null) {
                vprices = new Vector<String>();
                i$ = prices.iterator();
                while (i$.hasNext()) {
                    int p2 = (Integer)i$.next();
                    vprices.add(MLN.string("tradehelp.sellingprice") + " " + MillCommonUtilities.getShortPrice(p2));
                }
                page.add(new GuiText.Line(stacks, vprices, MLN.string(lastDesc), 72));
                page.add(new GuiText.Line());
            }
        }
        page.add(new GuiText.Line("<darkblue>" + MLN.string("tradehelp.goodsbought")));
        page.add(new GuiText.Line(""));
        goods = shop.calculateBuyingGoods(null);
        if (goods != null) {
            lastDesc = null;
            stacks = new Vector();
            prices = new Vector();
            for (Goods g : goods) {
                if (lastDesc != null && !lastDesc.equals(g.desc)) {
                    vprices2 = new Vector();
                    i$2 = prices.iterator();
                    while (i$2.hasNext()) {
                        p = (Integer)i$2.next();
                        vprices2.add(MLN.string("tradehelp.buyingprice") + " " + MillCommonUtilities.getShortPrice(p));
                    }
                    page.add(new GuiText.Line(stacks, vprices2, MLN.string(lastDesc), 72));
                    page.add(new GuiText.Line());
                    stacks = new Vector();
                    prices = new Vector();
                }
                stacks.add(new ItemStack(g.item.item, 1, g.item.meta));
                prices.add(g.getBasicBuyingPrice(shop));
                if (g.desc != null) {
                    lastDesc = g.desc;
                    continue;
                }
                lastDesc = "";
            }
            if (lastDesc != null) {
                vprices = new Vector();
                i$ = prices.iterator();
                while (i$.hasNext()) {
                    int p3 = (Integer)i$.next();
                    vprices.add(MLN.string("tradehelp.buyingprice") + " " + MillCommonUtilities.getShortPrice(p3));
                }
                page.add(new GuiText.Line(stacks, vprices, MLN.string(lastDesc), 72));
                page.add(new GuiText.Line());
            }
        }
        pages.add(page);
        page = new Vector();
        page.add(new GuiText.Line("<darkblue>" + MLN.string("tradehelp.helptitle")));
        page.add(new GuiText.Line());
        page.add(new GuiText.Line(MLN.string("tradehelp.helptext")));
        pages.add(page);
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiPanelParchment(player, null, pages, 0, true));
    }

    public static void displayInfoPanel(World world, EntityPlayer player) {
        Vector<Vector<String>> pages = new Vector<Vector<String>>();
        Vector<String> page = new Vector<String>();
        page.add("<help_gui_button>");
        page.add("");
        page.add("");
        page.add("<config_gui_button>");
        page.add("");
        page.add("");
        if (!Mill.serverWorlds.isEmpty()) {
            page.add("<chunk_gui_button>");
            page.add("");
            page.add("");
        }
        page.add(MLN.string("info.culturetitle"));
        page.add("");
        for (Culture culture : Culture.vectorCultures) {
            page.add(MLN.string("info.culture", culture.getCultureGameName()));
            page.add(MLN.string("info.culturereputation", culture.getReputationString()));
            if (MLN.languageLearning) {
                page.add(MLN.string("info.culturelanguage", culture.getLanguageLevelString()));
            }
            page.add("");
        }
        pages.add(page);
        page = new Vector();
        page.add(MLN.string("quest.creationqueststatus"));
        page.add("");
        for (String s : Mill.proxy.getClientProfile().getWorldQuestStatus()) {
            page.add(s);
        }
        page.add("");
        page.add(MLN.string("quest.questlist"));
        page.add("");
        boolean questShown = false;
        UserProfile profile = Mill.proxy.getClientProfile();
        for (Quest.QuestInstance qi : profile.questInstances) {
            String s = qi.getListing(profile);
            if (s == null) continue;
            questShown = true;
            page.add(s);
            long timeLeft = qi.currentStepStart + (long)(qi.getCurrentStep().duration * 1000) - world.func_72820_D();
            timeLeft = Math.round(timeLeft / 1000L);
            if (timeLeft == 0L) {
                page.add(MLN.string("quest.lessthananhourleft"));
                continue;
            }
            page.add(MLN.string("quest.timeremaining") + ": " + timeLeft + " " + MLN.string("quest.hours"));
        }
        if (!questShown) {
            page.add(MLN.string("quest.noquestsvisible"));
        }
        pages.add(page);
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiPanelParchment(player, pages, null, 0, true));
    }

    public static void displayPanel(World world, EntityPlayer player, Point p) {
        TileEntityPanel panel = p.getPanel(world);
        if (panel == null || panel.buildingPos == null) {
            return;
        }
        Building building = Mill.clientWorld.getBuilding(panel.buildingPos);
        if (building == null) {
            return;
        }
        Vector<Vector<String>> fullText = panel.getFullText(player);
        if (fullText != null) {
            DisplayActions.displayParchmentPanelGUI(player, fullText, building, panel.getMapType(), false);
        }
    }

    public static void displayStartupText(boolean error) {
        if (error) {
            Mill.proxy.sendChatAdmin(MLN.string("startup.loadproblem", "Mill\u221a\u00a9naire 5.2.0b5"));
            Mill.proxy.sendChatAdmin(MLN.string("startup.checkload"));
            MLN.error(null, "There was an error when trying to load Mill\u221a\u00a9naire 5.2.0b5.");
        } else {
            if (MLN.displayStart) {
                String bonus = "";
                if (MLN.bonusEnabled) {
                    bonus = " " + MLN.string("startup.bonus");
                }
                Mill.proxy.sendChatAdmin(MLN.string("startup.millenaireloaded", "Mill\u221a\u00a9naire 5.2.0b5", Keyboard.getKeyName((int)MLN.keyVillageList)));
                Mill.proxy.sendChatAdmin(MLN.string("startup.bonus", "Mill\u221a\u00a9naire 5.2.0b5", bonus), EnumChatFormatting.BLUE);
            }
            if (MLN.VillageRadius > 70) {
                Mill.proxy.sendChatAdmin(MLN.string("startup.radiuswarning"));
            }
        }
    }

    public static void displayVillageBook(World world, EntityPlayer player, Point p) {
        Building townHall = Mill.clientWorld.getBuilding(p);
        if (townHall == null) {
            return;
        }
        Vector<Vector<String>> pages = new Vector<Vector<String>>();
        Vector<String> page = new Vector<String>();
        page.add(MLN.string("panels.villagescroll") + ": " + townHall.getVillageQualifiedName());
        page.add("");
        pages.add(page);
        Vector<Vector<String>> newPages = TileEntityPanel.generateSummary(player, townHall);
        for (Vector<String> newPage : newPages) {
            pages.add(newPage);
        }
        newPages = TileEntityPanel.generateEtatCivil(player, townHall);
        for (Vector<String> newPage : newPages) {
            pages.add(newPage);
        }
        newPages = TileEntityPanel.generateConstructions(player, townHall);
        for (Vector<String> newPage : newPages) {
            pages.add(newPage);
        }
        newPages = TileEntityPanel.generateProjects(player, townHall);
        for (Vector<String> newPage : newPages) {
            pages.add(newPage);
        }
        newPages = TileEntityPanel.generateResources(player, townHall);
        for (Vector<String> newPage : newPages) {
            pages.add(newPage);
        }
        newPages = TileEntityPanel.generateMarketGoods(townHall);
        for (Vector<String> newPage : newPages) {
            pages.add(newPage);
        }
        DisplayActions.displayParchmentPanelGUI(player, pages, townHall, 1, true);
    }

    public static void handleKeyPress(World world) {
        Minecraft minecraft = FMLClientHandler.instance().getClient();
        if (minecraft.field_71462_r != null) {
            return;
        }
        EntityClientPlayerMP player = minecraft.field_71439_g;
        if (System.currentTimeMillis() - lastPing > 2000L && player.field_71093_bK == 0) {
            if (Keyboard.isKeyDown((int)MLN.keyVillageList)) {
                ClientSender.displayVillageList(false);
                lastPing = System.currentTimeMillis();
            }
            if (!world.field_72995_K && Keyboard.isKeyDown((int)42) && Keyboard.isKeyDown((int)25)) {
                if (!MillVillager.usingCustomPathing) {
                    MillVillager.usingCustomPathing = true;
                    Mill.proxy.sendChatAdmin(MLN.string("command.astarpathing"));
                } else {
                    MillVillager.usingCustomPathing = false;
                    Mill.proxy.sendChatAdmin(MLN.string("command.minecraftpathing"));
                }
                lastPing = System.currentTimeMillis();
            }
            if (Keyboard.isKeyDown((int)MLN.keyAggressiveEscorts)) {
                boolean stance = !Keyboard.isKeyDown((int)42);
                List list = world.func_72872_a(MillVillager.class, AxisAlignedBB.func_72330_a((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (double)(player.field_70165_t + 1.0), (double)(player.field_70163_u + 1.0), (double)(player.field_70161_v + 1.0)).func_72314_b(16.0, 8.0, 16.0));
                for (Object o : list) {
                    MillVillager villager = (MillVillager)o;
                    if (!player.getDisplayName().equals(villager.hiredBy)) continue;
                    villager.aggressiveStance = stance;
                }
                lastPing = System.currentTimeMillis();
            }
            if (Keyboard.isKeyDown((int)MLN.keyInfoPanelList)) {
                MillClientUtilities.displayInfoPanel(world, (EntityPlayer)player);
                lastPing = System.currentTimeMillis();
            }
            if (Keyboard.isKeyDown((int)25)) {
                boolean bl = MLN.jpsPathing = !MLN.jpsPathing;
                if (MLN.jpsPathing) {
                    Mill.proxy.sendChatAdmin("Chemins JPS / JPS pathing");
                } else {
                    Mill.proxy.sendChatAdmin("Chemins classiques / classic pathing");
                }
                lastPing = System.currentTimeMillis();
            }
            if (MLN.DEV) {
                if (Keyboard.isKeyDown((int)42) && Keyboard.isKeyDown((int)19) && System.currentTimeMillis() - lastFreeRes > 5000L) {
                    DevModUtilities.fillInFreeGoods((EntityPlayer)player);
                    lastFreeRes = System.currentTimeMillis();
                }
                if (Keyboard.isKeyDown((int)42) && Keyboard.isKeyDown((int)203)) {
                    player.func_70107_b(player.field_70165_t + 10000.0, player.field_70163_u + 10.0, player.field_70161_v);
                    lastPing = System.currentTimeMillis();
                }
                if (Keyboard.isKeyDown((int)42) && Keyboard.isKeyDown((int)205)) {
                    player.func_70107_b(player.field_70165_t - 10000.0, player.field_70163_u + 10.0, player.field_70161_v);
                    lastPing = System.currentTimeMillis();
                }
                if (Keyboard.isKeyDown((int)38)) {
                    ClientSender.displayVillageList(true);
                    lastPing = System.currentTimeMillis();
                }
                if (Keyboard.isKeyDown((int)50) && Keyboard.isKeyDown((int)42)) {
                    ClientSender.devCommand(1);
                    lastPing = System.currentTimeMillis();
                }
                if (Keyboard.isKeyDown((int)21) && Keyboard.isKeyDown((int)29)) {
                    Mill.proxy.sendChatAdmin("Sending test path request.");
                    ClientSender.devCommand(2);
                    lastPing = System.currentTimeMillis();
                }
                if (Keyboard.isKeyDown((int)20)) {
                    Mill.clientWorld.displayTagActionData((EntityPlayer)player);
                    lastPing = System.currentTimeMillis();
                }
            }
        }
    }

    public static void updateBowIcon(Goods.ItemMillenaireBow bow, EntityPlayer entityplayer) {
        ItemStack itemstack1 = entityplayer.field_71071_by.func_70448_g();
        if (entityplayer.func_71039_bw() && itemstack1.func_77973_b() == bow) {
            int k = itemstack1.func_77988_m() - entityplayer.func_71052_bv();
            if (k >= 18) {
                bow.setBowIcon(3);
            } else if (k > 13) {
                bow.setBowIcon(2);
            } else if (k > 0) {
                bow.setBowIcon(1);
            } else {
                bow.setBowIcon(0);
            }
        } else {
            bow.setBowIcon(0);
        }
    }

    public static void updatePanel(Point p, String[][] lines, int type, Point buildingPos, long villager_id) {
        if (lines == null) {
            return;
        }
        TileEntityPanel panel = p.getPanel(Mill.clientWorld.world);
        if (panel == null) {
            TileEntityPanel.PanelPacketInfo pinfo = new TileEntityPanel.PanelPacketInfo(p, lines, buildingPos, type, villager_id);
            Mill.clientWorld.panelPacketInfos.add(pinfo);
            return;
        }
        panel.panelType = type;
        panel.buildingPos = buildingPos;
        panel.villager_id = villager_id;
        for (int i = 0; i < lines.length && i < panel.field_145915_a.length; ++i) {
            panel.field_145915_a[i] = MLN.string(lines[i]);
        }
    }

    public static void putVillagerSentenceInChat(MillVillager v) {
        if (v.dialogueTargetFirstName != null && !v.dialogueChat) {
            return;
        }
        int radius = 0;
        radius = Mill.proxy.isTrueClient() ? MLN.VillagersSentenceInChatDistanceClient : MLN.VillagersSentenceInChatDistanceSP;
        EntityPlayer player = Mill.proxy.getTheSinglePlayer();
        if (v.getPos().distanceTo((Entity)player) > (double)radius) {
            return;
        }
        String gameSpeech = MillCommonUtilities.getVillagerSentence(v, player.getDisplayName(), false);
        String nativeSpeech = MillCommonUtilities.getVillagerSentence(v, player.getDisplayName(), true);
        if (nativeSpeech != null || gameSpeech != null) {
            String s = v.dialogueTargetFirstName != null ? MLN.string("other.chattosomeone", v.getName(), v.dialogueTargetFirstName + " " + v.dialogueTargetLastName) + ": " : v.getName() + ": ";
            if (nativeSpeech != null) {
                s = s + "\u00a79" + nativeSpeech;
            }
            if (nativeSpeech != null && gameSpeech != null) {
                s = s + " ";
            }
            if (gameSpeech != null) {
                s = s + "\u00a74" + gameSpeech;
            }
            Mill.proxy.sendLocalChat(Mill.proxy.getTheSinglePlayer(), v.dialogueColour, s);
        }
    }
}

