/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.client.gui;

import java.util.Vector;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.millenaire.client.gui.GuiText;
import org.millenaire.client.network.ClientSender;
import org.millenaire.common.MLN;
import org.millenaire.common.MillVillager;
import org.millenaire.common.core.MillCommonUtilities;

public class GuiHire
extends GuiText {
    private static final int REPUTATION_NEEDED = 4096;
    public static final int BUTTON_CLOSE = 0;
    public static final int BUTTON_HIRE = 1;
    public static final int BUTTON_EXTEND = 2;
    public static final int BUTTON_RELEASE = 3;
    private final MillVillager villager;
    private final EntityPlayer player;
    ResourceLocation background = new ResourceLocation("millenaire", "textures/gui/ML_quest.png");

    public GuiHire(EntityPlayer player, MillVillager villager) {
        this.villager = villager;
        this.player = player;
    }

    protected void func_146284_a(GuiButton guibutton) {
        if (!guibutton.field_146124_l) {
            return;
        }
        if (guibutton.field_146127_k == 0) {
            this.field_146297_k.func_147108_a(null);
            this.field_146297_k.func_71381_h();
        } else if (guibutton.field_146127_k == 1) {
            ClientSender.hireHire(this.player, this.villager);
            this.refreshContent();
        } else if (guibutton.field_146127_k == 2) {
            ClientSender.hireExtend(this.player, this.villager);
            this.refreshContent();
        } else if (guibutton.field_146127_k == 3) {
            ClientSender.hireRelease(this.player, this.villager);
            this.refreshContent();
        }
    }

    @Override
    public void buttonPagination() {
        super.buttonPagination();
        int xStart = (this.field_146294_l - this.getXSize()) / 2;
        int yStart = (this.field_146295_m - this.getYSize()) / 2;
        if (this.villager.hiredBy != null) {
            if (MillCommonUtilities.countMoney((IInventory)this.player.field_71071_by) >= this.villager.getHireCost(this.player)) {
                this.field_146292_n.add(new GuiButton(2, xStart + this.getXSize() / 2 - 100, yStart + this.getYSize() - 40, 63, 20, MLN.string("hire.extend")));
            }
            this.field_146292_n.add(new GuiButton(3, xStart + this.getXSize() / 2 - 32, yStart + this.getYSize() - 40, 64, 20, MLN.string("hire.release")));
            this.field_146292_n.add(new GuiButton(0, xStart + this.getXSize() / 2 + 37, yStart + this.getYSize() - 40, 63, 20, MLN.string("hire.close")));
        } else {
            if (this.villager.getTownHall().getReputation(this.player.getDisplayName()) >= 4096 && MillCommonUtilities.countMoney((IInventory)this.player.field_71071_by) >= this.villager.getHireCost(this.player)) {
                this.field_146292_n.add(new GuiButton(1, xStart + this.getXSize() / 2 - 100, yStart + this.getYSize() - 40, 95, 20, MLN.string("hire.hire")));
            }
            this.field_146292_n.add(new GuiButton(0, xStart + this.getXSize() / 2 + 5, yStart + this.getYSize() - 40, 95, 20, MLN.string("hire.close")));
        }
    }

    @Override
    protected void customDrawBackground(int i, int j, float f) {
    }

    @Override
    protected void customDrawScreen(int i, int j, float f) {
    }

    @Override
    public boolean func_73868_f() {
        return false;
    }

    private Vector<Vector<GuiText.Line>> getData() {
        Vector<GuiText.Line> text = new Vector<GuiText.Line>();
        text.add(new GuiText.Line(this.villager.getName() + ", " + this.villager.getNativeOccupationName()));
        text.add(new GuiText.Line());
        if (this.villager.hiredBy != null) {
            text.add(new GuiText.Line(MLN.string("hire.hiredvillager", "" + Math.round((this.villager.hiredUntil - this.villager.field_70170_p.func_72820_D()) / 1000L), Keyboard.getKeyName((int)MLN.keyAggressiveEscorts))));
        } else if (this.villager.getTownHall().getReputation(this.player.getDisplayName()) >= 4096) {
            text.add(new GuiText.Line(MLN.string("hire.hireablevillager")));
        } else {
            text.add(new GuiText.Line(MLN.string("hire.hireablevillagernoreputation")));
        }
        text.add(new GuiText.Line());
        text.add(new GuiText.Line(MLN.string("hire.health") + ": " + (double)this.villager.func_110143_aJ() * 0.5 + "/" + (double)this.villager.func_110138_aP() * 0.5));
        text.add(new GuiText.Line(MLN.string("hire.strength") + ": " + this.villager.getAttackStrength()));
        text.add(new GuiText.Line(MLN.string("hire.cost") + ": " + MillCommonUtilities.getShortPrice(this.villager.getHireCost(this.player))));
        Vector<Vector<GuiText.Line>> ftext = new Vector<Vector<GuiText.Line>>();
        ftext.add(text);
        return this.adjustText(ftext);
    }

    @Override
    public int getLineSizeInPx() {
        return 240;
    }

    @Override
    public int getPageSize() {
        return 16;
    }

    @Override
    public ResourceLocation getPNGPath() {
        return this.background;
    }

    @Override
    public int getXSize() {
        return 256;
    }

    @Override
    public int getYSize() {
        return 220;
    }

    @Override
    public void initData() {
        this.refreshContent();
    }

    private void refreshContent() {
        this.descText = this.getData();
        this.buttonPagination();
    }
}

