/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.client.gui;

import java.util.Vector;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import org.millenaire.client.gui.GuiText;
import org.millenaire.client.network.ClientSender;
import org.millenaire.common.Building;
import org.millenaire.common.MLN;
import org.millenaire.common.Point;
import org.millenaire.common.construction.BuildingPlanSet;

public class GuiNewBuildingProject
extends GuiText {
    private static final int NBBUTTONLINE = 6;
    private final Building townhall;
    private Vector<BuildingPlanSet> possibleBuildings = new Vector();
    private final Point pos;
    private int nbbuttonpages;
    private final EntityPlayer player;
    ResourceLocation background = new ResourceLocation("millenaire", "textures/gui/ML_panel.png");

    public GuiNewBuildingProject(EntityPlayer player, Building th, Point p) {
        this.townhall = th;
        this.pos = p;
        this.player = player;
    }

    protected void func_146284_a(GuiButton guibutton) {
        if (!guibutton.field_146124_l) {
            return;
        }
        ClientSender.newBuilding(this.player, this.townhall, this.pos, this.possibleBuildings.get((int)guibutton.field_146127_k).key);
        this.closeWindow();
    }

    @Override
    public void buttonPagination() {
        super.buttonPagination();
        int xStart = (this.field_146294_l - this.getXSize()) / 2;
        int yStart = (this.field_146295_m - this.getYSize()) / 2;
        int line = 0;
        for (int i = this.pageNum * 6; i < (this.pageNum + 1) * 6 && i < this.possibleBuildings.size(); ++i) {
            this.field_146292_n.add(new GuiButton(i, xStart + this.getXSize() / 2 - 100, yStart + 40 + 25 * line, 200, 20, this.possibleBuildings.get(i).getFullName(this.player)));
            ++line;
        }
    }

    @Override
    protected void customDrawBackground(int i, int j, float f) {
    }

    @Override
    protected void customDrawScreen(int i, int j, float f) {
    }

    @Override
    public void decrementPage() {
        super.decrementPage();
        this.buttonPagination();
    }

    @Override
    public int getLineSizeInPx() {
        return 195;
    }

    @Override
    protected int getNbPage() {
        return Math.max(this.descText.size(), this.nbbuttonpages);
    }

    @Override
    public int getPageSize() {
        return 19;
    }

    @Override
    public ResourceLocation getPNGPath() {
        return this.background;
    }

    @Override
    public int getXSize() {
        return 204;
    }

    @Override
    public int getYSize() {
        return 220;
    }

    @Override
    public void incrementPage() {
        super.incrementPage();
        this.buttonPagination();
    }

    @Override
    public void initData() {
        Vector<GuiText.Line> text = new Vector<GuiText.Line>();
        text.add(new GuiText.Line(this.townhall.getVillageQualifiedName()));
        text.add(new GuiText.Line());
        text.add(new GuiText.Line(MLN.string("ui.selectabuildingproject")));
        Vector<Vector<GuiText.Line>> pages = new Vector<Vector<GuiText.Line>>();
        pages.add(text);
        this.descText = pages;
        this.possibleBuildings = (Vector)this.townhall.villageType.coreBuildings.clone();
        for (int i = this.possibleBuildings.size() - 1; i >= 0; --i) {
            if (this.townhall.isValidProject(this.possibleBuildings.get(i).getBuildingProject())) continue;
            this.possibleBuildings.remove(i);
        }
        this.nbbuttonpages = (int)Math.ceil((double)this.possibleBuildings.size() * 1.0 / 6.0);
    }
}

