/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.client.gui;

import java.util.Vector;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import org.millenaire.client.gui.GuiText;
import org.millenaire.client.network.ClientSender;
import org.millenaire.common.Culture;
import org.millenaire.common.MLN;
import org.millenaire.common.Point;
import org.millenaire.common.UserProfile;
import org.millenaire.common.VillageType;
import org.millenaire.common.forge.Mill;

public class GuiNewVillage
extends GuiText {
    private Vector<VillageType> possibleVillages = new Vector();
    private final Point pos;
    private final EntityPlayer player;
    ResourceLocation background = new ResourceLocation("millenaire", "textures/gui/ML_panel.png");

    public GuiNewVillage(EntityPlayer player, Point p) {
        this.pos = p;
        this.player = player;
    }

    protected void func_146284_a(GuiButton guibutton) {
        if (!guibutton.field_146124_l) {
            return;
        }
        VillageType village = this.possibleVillages.get(guibutton.field_146127_k);
        ClientSender.newVillageCreation(this.player, this.pos, village.culture.key, village.key);
        this.closeWindow();
    }

    @Override
    protected void customDrawBackground(int i, int j, float f) {
    }

    @Override
    protected void customDrawScreen(int i, int j, float f) {
    }

    @Override
    public int getLineSizeInPx() {
        return 195;
    }

    @Override
    public int getPageSize() {
        return 19;
    }

    @Override
    public ResourceLocation getPNGPath() {
        return this.background;
    }

    @Override
    public int getXSize() {
        return 204;
    }

    @Override
    public int getYSize() {
        return 220;
    }

    @Override
    public void initData() {
        Vector<GuiText.Line> text = new Vector<GuiText.Line>();
        text.add(new GuiText.Line(MLN.string("ui.selectavillage"), false));
        text.add(new GuiText.Line(false));
        text.add(new GuiText.Line(MLN.string("ui.leadershipstatus") + ":"));
        text.add(new GuiText.Line());
        boolean notleader = false;
        UserProfile profile = Mill.proxy.getClientProfile();
        for (Culture culture : Culture.vectorCultures) {
            if (profile.isTagSet("culturecontrol_" + culture.key)) {
                text.add(new GuiText.Line(MLN.string("ui.leaderin", culture.getCultureGameName())));
                continue;
            }
            text.add(new GuiText.Line(MLN.string("ui.notleaderin", culture.getCultureGameName())));
            notleader = true;
        }
        if (notleader) {
            text.add(new GuiText.Line());
            text.add(new GuiText.Line(MLN.string("ui.leaderinstruction")));
        }
        text.add(new GuiText.Line());
        this.possibleVillages = VillageType.spawnableVillages(this.player);
        for (int i = 0; i < this.possibleVillages.size(); ++i) {
            String controlled = "";
            if (this.possibleVillages.get((int)i).playerControlled) {
                controlled = ", " + MLN.string("ui.controlled");
            }
            text.add(new GuiText.Line(new GuiText.MillGuiButton(i, 0, 0, 0, 0, this.possibleVillages.get((int)i).name + " (" + this.possibleVillages.get((int)i).culture.getCultureGameName() + controlled + ")")));
            text.add(new GuiText.Line(false));
            text.add(new GuiText.Line());
        }
        Vector<Vector<GuiText.Line>> pages = new Vector<Vector<GuiText.Line>>();
        pages.add(text);
        this.descText = this.adjustText(pages);
    }
}

