/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import org.millenaire.common.MLN;
import org.millenaire.common.Point;
import org.millenaire.common.core.MillCommonUtilities;
import org.millenaire.common.forge.Mill;

public class EntityMillDecoration
extends EntityPainting
implements IEntityAdditionalSpawnData {
    public static final int NORMAN_TAPESTRY = 1;
    public static final int INDIAN_STATUE = 2;
    public static final int MAYAN_STATUE = 3;
    public static final int BYZANTINE_ICON_SMALL = 4;
    public static final int BYZANTINE_ICON_MEDIUM = 5;
    public static final int BYZANTINE_ICON_LARGE = 6;
    public EnumWallDecoration field_70522_e;
    public double clientX;
    public double clientY;
    public double clientZ;
    public int type;

    public static EntityMillDecoration createTapestry(World world, Point p, int type) {
        int orientation = EntityMillDecoration.guessOrientation(world, p);
        if (orientation == 0) {
            p = p.getWest();
        } else if (orientation == 1) {
            p = p.getSouth();
        } else if (orientation == 2) {
            p = p.getEast();
        } else if (orientation == 3) {
            p = p.getNorth();
        }
        return new EntityMillDecoration(world, p.getiX(), p.getiY(), p.getiZ(), orientation, type, true);
    }

    public static int guessOrientation(World world, Point p) {
        int k;
        int j;
        int i = p.getiX();
        if (MillCommonUtilities.isBlockIdSolid(world.func_147439_a(i - 1, j = p.getiY(), k = p.getiZ()))) {
            return 3;
        }
        if (MillCommonUtilities.isBlockIdSolid(world.func_147439_a(i + 1, j, k))) {
            return 1;
        }
        if (MillCommonUtilities.isBlockIdSolid(world.func_147439_a(i, j, k - 1))) {
            return 2;
        }
        if (MillCommonUtilities.isBlockIdSolid(world.func_147439_a(i, j, k + 1))) {
            return 0;
        }
        return 0;
    }

    public EntityMillDecoration(World par1World) {
        super(par1World);
    }

    public EntityMillDecoration(World par1World, int par2, int par3, int par4, int par5) {
        this(par1World);
        this.field_70165_t = par2;
        this.field_70163_u = par3;
        this.field_70161_v = par4;
    }

    public EntityMillDecoration(World world, int type) {
        this(world);
        this.type = type;
    }

    public EntityMillDecoration(World world, int x, int y, int z, int orientation, int type, boolean largestPossible) {
        this(world, x, y, z, orientation);
        this.type = type;
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        ArrayList<EnumWallDecoration> arraylist = new ArrayList<EnumWallDecoration>();
        EnumWallDecoration[] aenumart = EnumWallDecoration.values();
        int maxSize = 0;
        for (EnumWallDecoration enumart : aenumart) {
            if (enumart.type != type || largestPossible && enumart.sizeX * enumart.sizeY < maxSize) continue;
            this.field_70522_e = enumart;
            this.func_82328_a(orientation);
            if (!this.func_70518_d()) continue;
            if (largestPossible && enumart.sizeX * enumart.sizeY > maxSize) {
                arraylist.clear();
            }
            arraylist.add(enumart);
            maxSize = enumart.sizeX * enumart.sizeY;
        }
        if (arraylist.size() > 0) {
            this.field_70522_e = (EnumWallDecoration)((Object)arraylist.get(this.field_70146_Z.nextInt(arraylist.size())));
        }
        if (MLN.LogBuildingPlan >= 1) {
            MLN.major((Object)this, "Creating wall decoration: " + x + "/" + y + "/" + z + "/" + orientation + "/" + type + "/" + largestPossible + ". Result: " + this.field_70522_e.title + " picked amoung " + arraylist.size());
        }
        this.func_82328_a(orientation);
    }

    public EntityMillDecoration(World world, int i, int j, int k, int l, int type, String s) {
        super(world, i, j, k, l);
        this.type = type;
        for (EnumWallDecoration enumart : EnumWallDecoration.values()) {
            if (!enumart.title.equals(s)) continue;
            this.field_70522_e = enumart;
            break;
        }
        this.func_82328_a(l);
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("Type", this.type);
        nbttagcompound.func_74778_a("Motive", this.field_70522_e.title);
        nbttagcompound.func_74774_a("Direction", (byte)this.field_82332_a);
        nbttagcompound.func_74780_a("TileX", this.field_70165_t);
        nbttagcompound.func_74780_a("TileY", this.field_70163_u);
        nbttagcompound.func_74780_a("TileZ", this.field_70161_v);
        switch (this.field_82332_a) {
            case 0: {
                nbttagcompound.func_74774_a("Dir", (byte)2);
                break;
            }
            case 1: {
                nbttagcompound.func_74774_a("Dir", (byte)1);
                break;
            }
            case 2: {
                nbttagcompound.func_74774_a("Dir", (byte)0);
                break;
            }
            case 3: {
                nbttagcompound.func_74774_a("Dir", (byte)3);
            }
        }
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        this.type = nbttagcompound.func_74762_e("Type");
        String s = nbttagcompound.func_74779_i("Motive");
        for (EnumWallDecoration enumart : EnumWallDecoration.values()) {
            if (!enumart.title.equals(s)) continue;
            this.field_70522_e = enumart;
        }
        if (this.field_70522_e == null) {
            this.field_70522_e = EnumWallDecoration.Griffon;
        }
        if (this.type == 0) {
            this.type = 1;
        }
        if (nbttagcompound.func_74764_b("Direction")) {
            this.field_82332_a = nbttagcompound.func_74771_c("Direction");
        } else {
            switch (nbttagcompound.func_74771_c("Dir")) {
                case 0: {
                    this.field_82332_a = 2;
                    break;
                }
                case 1: {
                    this.field_82332_a = 1;
                    break;
                }
                case 2: {
                    this.field_82332_a = 0;
                    break;
                }
                case 3: {
                    this.field_82332_a = 3;
                }
            }
        }
        this.field_70165_t = nbttagcompound.func_74762_e("TileX");
        this.field_70163_u = nbttagcompound.func_74762_e("TileY");
        this.field_70161_v = nbttagcompound.func_74762_e("TileZ");
        this.func_82328_a(this.field_82332_a);
    }

    public String toString() {
        return "Tapestry (" + this.field_70522_e.title + ")";
    }

    public void dropItemStack() {
        if (this.type == 1) {
            this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(Mill.tapestry)));
        } else if (this.type == 2) {
            this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(Mill.indianstatue)));
        } else if (this.type == 3) {
            this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(Mill.mayanstatue)));
        } else if (this.type == 4) {
            this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(Mill.byzantineiconsmall)));
        } else if (this.type == 5) {
            this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(Mill.byzantineiconmedium)));
        } else if (this.type == 6) {
            this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(Mill.byzantineiconlarge)));
        }
    }

    public int func_82329_d() {
        return this.field_70522_e.sizeX;
    }

    public int func_82330_g() {
        return this.field_70522_e.sizeY;
    }

    public void writeSpawnData(ByteBuf ds) {
        ByteBufOutputStream data = new ByteBufOutputStream(ds);
        try {
            data.write(this.type);
            data.write(this.field_82332_a);
            data.writeDouble(this.field_70165_t);
            data.writeDouble(this.field_70163_u);
            data.writeDouble(this.field_70161_v);
            data.writeUTF(this.field_70522_e.title);
            data.writeDouble(this.field_70165_t);
            data.writeDouble(this.field_70163_u);
            data.writeDouble(this.field_70161_v);
            data.close();
        }
        catch (IOException e) {
            MLN.printException("Exception for painting " + (Object)((Object)this), e);
        }
    }

    public void readSpawnData(ByteBuf ds) {
        ByteBufInputStream data = new ByteBufInputStream(ds);
        try {
            this.type = data.readByte();
            this.field_82332_a = data.readByte();
            this.field_70165_t = data.readInt();
            this.field_70163_u = data.readInt();
            this.field_70161_v = data.readInt();
            String title = data.readUTF();
            for (EnumWallDecoration enumart : EnumWallDecoration.values()) {
                if (!enumart.title.equals(title)) continue;
                this.field_70522_e = enumart;
            }
            this.clientX = data.readDouble();
            this.clientY = data.readDouble();
            this.clientZ = data.readDouble();
            data.close();
        }
        catch (IOException e) {
            MLN.printException("Exception for villager " + (Object)((Object)this), e);
        }
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            this.field_70165_t = this.clientX;
            this.field_70163_u = this.clientY;
            this.field_70161_v = this.clientZ;
            this.field_70181_x = 0.0;
        }
        super.func_70071_h_();
    }

    public static enum EnumWallDecoration {
        Griffon("Griffon", 16, 16, 0, 0, 1),
        Oiseau("Oiseau", 16, 16, 16, 0, 1),
        CorbeauRenard("CorbeauRenard", 32, 16, 32, 0, 1),
        Serment("Serment", 80, 48, 0, 16, 1),
        MortHarold("MortHarold", 64, 48, 80, 16, 1),
        Drakar("Drakar", 96, 48, 144, 16, 1),
        MontStMichel("MontStMichel", 48, 32, 0, 64, 1),
        Bucherons("Bucherons", 48, 32, 48, 64, 1),
        Cuisine("Cuisine", 48, 32, 96, 64, 1),
        Flotte("Flotte", 240, 48, 0, 96, 1),
        Chasse("Chasse", 96, 48, 0, 144, 1),
        Siege("Siege", 256, 48, 0, 192, 1),
        Ganesh("Ganesh", 32, 48, 0, 0, 2),
        Kali("Kali", 32, 48, 32, 0, 2),
        Shiva("Shiva", 32, 48, 64, 0, 2),
        Osiyan("Osiyan", 32, 48, 96, 0, 2),
        Durga("Durga", 32, 48, 128, 0, 2),
        MayanTeal("MayanTeal", 32, 32, 0, 48, 3),
        MayanGold("MayanGold", 32, 32, 32, 48, 3),
        LargeJesus("LargeJesus", 32, 48, 0, 80, 6),
        LargeVirgin("LargeVirgin", 32, 48, 32, 80, 6),
        MediumVirgin1("MediumVirgin1", 32, 32, 0, 128, 5),
        MediumVirgin2("MediumVirgin2", 32, 32, 32, 128, 5),
        SmallJesus("SmallJesus", 16, 16, 0, 160, 4),
        SmallVirgin1("SmallVirgin1", 16, 16, 16, 160, 4),
        SmallVirgin2("SmallVirgin2", 16, 16, 32, 160, 4),
        SmallVirgin3("SmallVirgin3", 16, 16, 48, 160, 4);

        public static final int maxArtTitleLength;
        public final String title;
        public final int sizeX;
        public final int sizeY;
        public final int offsetX;
        public final int offsetY;
        public final int type;

        private EnumWallDecoration(String s1, int j, int k, int l, int i1, int type) {
            this.title = s1;
            this.sizeX = j;
            this.sizeY = k;
            this.offsetX = l;
            this.offsetY = i1;
            this.type = type;
        }

        static {
            maxArtTitleLength = "SkullAndRoses".length();
        }
    }
}

