/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.Vector;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import org.millenaire.common.Building;
import org.millenaire.common.BuildingLocation;
import org.millenaire.common.Culture;
import org.millenaire.common.MLN;
import org.millenaire.common.MillWorld;
import org.millenaire.common.MillWorldInfo;
import org.millenaire.common.Point;
import org.millenaire.common.UserProfile;
import org.millenaire.common.VillageType;
import org.millenaire.common.construction.BuildingPlan;
import org.millenaire.common.construction.BuildingPlanSet;
import org.millenaire.common.core.MillCommonUtilities;
import org.millenaire.common.forge.Mill;
import org.millenaire.common.network.ServerSender;
import org.millenaire.common.pathing.AStarPathing;

public class WorldGenVillage
implements IWorldGenerator {
    private static final double MINIMUM_USABLE_BLOCK_PERC = 0.7;
    public static HashSet<Integer> coordsTried = new HashSet();

    public static boolean generateBedrockLoneBuilding(Point p, World world, VillageType village, Random random, int minDistance, int maxDistance, EntityPlayer player) throws MLN.MillenaireException {
        if (world.field_72995_K) {
            return false;
        }
        if (p.horizontalDistanceTo(world.func_72861_E()) < (double)MLN.spawnProtectionRadius) {
            return false;
        }
        if (MLN.LogWorldGeneration >= 1) {
            MLN.major(null, "Generating bedrockbuilding: " + village);
        }
        BuildingPlan plan = village.centreBuilding.getRandomStartingPlan();
        BuildingLocation location = null;
        for (int i = 0; i < 100 && location == null; ++i) {
            int x = minDistance + MillCommonUtilities.randomInt(maxDistance - minDistance);
            int z = minDistance + MillCommonUtilities.randomInt(maxDistance - minDistance);
            if (MillCommonUtilities.chanceOn(2)) {
                x = -x;
            }
            if (MillCommonUtilities.chanceOn(2)) {
                z = -z;
            }
            BuildingPlan.LocationReturn lr = plan.testSpotBedrock(world, p.getiX() + x, p.getiZ() + z);
            location = lr.location;
        }
        if (location == null) {
            MLN.major(null, "No spot found for: " + village);
            int x = minDistance + MillCommonUtilities.randomInt(maxDistance - minDistance);
            int z = minDistance + MillCommonUtilities.randomInt(maxDistance - minDistance);
            if (MillCommonUtilities.chanceOn(2)) {
                x = -x;
            }
            if (MillCommonUtilities.chanceOn(2)) {
                z = -z;
            }
            location = new BuildingLocation(plan, new Point(p.getiX() + x, 2.0, p.getiZ() + z), 0);
            location.bedrocklevel = true;
        }
        Vector<BuildingPlan.LocationBuildingPair> lbps = village.centreBuilding.buildLocation(Mill.getMillWorld(world), village, location, true, true, null, false, null);
        Building townHallEntity = lbps.firstElement().building;
        if (MLN.LogWorldGeneration >= 1) {
            MLN.major(null, "Registering building: " + townHallEntity);
        }
        townHallEntity.villageType = village;
        townHallEntity.findName(null);
        townHallEntity.initialiseBuildingProjects();
        townHallEntity.registerBuildingLocation(location);
        for (BuildingPlan.LocationBuildingPair lbp : lbps) {
            if (lbp == lbps.firstElement()) continue;
            townHallEntity.registerBuildingEntity(lbp.building);
            townHallEntity.registerBuildingLocation(lbp.location);
        }
        townHallEntity.initialiseVillage();
        String playerName = null;
        if (player != null) {
            playerName = player.getDisplayName();
        }
        Mill.getMillWorld(world).registerLoneBuildingsLocation(world, townHallEntity.getPos(), townHallEntity.getVillageQualifiedName(), townHallEntity.villageType, townHallEntity.culture, true, playerName);
        MLN.major(null, "Finished bedrock building " + village + " at " + townHallEntity.getPos());
        return true;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.field_76574_g != 0) {
            return;
        }
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        for (int i = 2; i < trace.length; ++i) {
            if (!trace[i].getClassName().equals(this.getClass().getName())) continue;
            return;
        }
        try {
            this.generateVillageAtPoint(world, random, chunkX * 16, 0, chunkZ * 16, null, true, false, Integer.MAX_VALUE, null, null, null);
        }
        catch (Exception e) {
            MLN.printException("Exception when attempting to generate village in " + world + " (dimension: " + world.func_72912_H().func_76076_i() + ")", e);
        }
    }

    private void generateHamlet(World world, VillageType hamlet, Point centralVillage, String name, Random random) {
        boolean generated = false;
        for (int minRadius = 130; !generated && minRadius < 200; minRadius += 50) {
            double angle = 0.06280000000000001 * (double)MillCommonUtilities.randomInt(100);
            for (int attempts = 0; !generated && attempts < 300; ++attempts) {
                int radius = minRadius + MillCommonUtilities.randomInt(40);
                int dx = (int)(Math.cos(angle += 0.020933333333333335) * (double)radius);
                int dz = (int)(Math.sin(angle) * (double)radius);
                if (MLN.LogWorldGeneration >= 1) {
                    MLN.major(this, "Trying to generate a hamlet " + hamlet + " around: " + (centralVillage.getiX() + dx) + "/" + (centralVillage.getiZ() + dz));
                }
                generated = this.generateVillageAtPoint(world, random, centralVillage.getiX() + dx, 0, centralVillage.getiZ() + dz, null, false, true, 100, hamlet, name, centralVillage);
            }
        }
        if (!generated && MLN.LogWorldGeneration >= 1) {
            MLN.major(this, "Could not generate hamlet " + hamlet);
        }
    }

    private boolean generateVillage(Point p, World world, VillageType village, EntityPlayer player, EntityPlayer closestPlayer, Random random, int minDistance, String name, boolean loneBuildings, Point parentVillage) throws MLN.MillenaireException {
        MillWorldInfo winfo = new MillWorldInfo();
        Vector<BuildingLocation> plannedBuildings = new Vector<BuildingLocation>();
        MillWorld mw = Mill.getMillWorld(world);
        p = new Point(p.x, MillCommonUtilities.findTopSoilBlock(world, p.getiX(), p.getiZ()), p.z);
        winfo.update(world, plannedBuildings, null, p, village.radius);
        for (int x = p.getChunkX() - village.radius / 16 - 1; x <= p.getChunkX() + village.radius / 16; ++x) {
            for (int z = p.getChunkZ() - village.radius / 16 - 1; z <= p.getChunkZ() + village.radius / 16; ++z) {
                if (world.func_72964_e((int)x, (int)z).field_76636_d) continue;
                world.func_72863_F().func_73158_c(x, z);
            }
        }
        if (player == null && !this.isAppropriateArea(winfo, p, village.radius)) {
            return false;
        }
        long startTime = System.nanoTime();
        BuildingLocation location = village.centreBuilding.getRandomStartingPlan().findBuildingLocation(winfo, null, p, village.radius, random, 3);
        if (location == null) {
            if (MLN.LogWorldGeneration >= 2) {
                MLN.minor(this, "Could not find place for central building: " + village.centreBuilding);
            }
            if (player != null) {
                ServerSender.sendTranslatedSentence(player, '6', "ui.generatenotenoughspace", new String[0]);
            }
            return false;
        }
        if (MLN.LogWorldGeneration >= 2) {
            MLN.minor(this, "Place found for TownHall (village type: " + village.key + "). Checking for the rest.");
        }
        p = location.pos;
        plannedBuildings.add(location);
        winfo.update(world, plannedBuildings, null, p, village.radius);
        boolean couldBuildKeyBuildings = true;
        AStarPathing pathing = new AStarPathing();
        pathing.createConnectionsTable(winfo, p);
        for (BuildingPlanSet planSet : village.startBuildings) {
            location = planSet.getRandomStartingPlan().findBuildingLocation(winfo, pathing, p, village.radius, random, -1);
            if (location != null) {
                plannedBuildings.add(location);
                winfo.update(world, plannedBuildings, null, p, village.radius);
                continue;
            }
            couldBuildKeyBuildings = false;
            if (MLN.LogWorldGeneration < 2) continue;
            MLN.minor(this, "Couldn't build " + planSet.key + ".");
        }
        if (MLN.LogWorldGeneration >= 3) {
            MLN.debug(this, "Time taken for finding if building possible: " + (System.nanoTime() - startTime));
        }
        if (!couldBuildKeyBuildings) {
            if (player != null) {
                ServerSender.sendTranslatedSentence(player, '6', "ui.generatenotenoughspacevillage", new String[0]);
            }
            return false;
        }
        if (player == null) {
            int minDistanceWithLoneBuildings;
            int minDistanceWithVillages;
            if (loneBuildings) {
                if (village.isKeyLoneBuildingForGeneration(closestPlayer)) {
                    minDistanceWithVillages = Math.min(minDistance, MLN.minDistanceBetweenVillagesAndLoneBuildings) / 2;
                    minDistanceWithLoneBuildings = Math.min(minDistance, MLN.minDistanceBetweenLoneBuildings) / 2;
                } else {
                    minDistanceWithVillages = Math.min(minDistance, MLN.minDistanceBetweenVillagesAndLoneBuildings);
                    minDistanceWithLoneBuildings = Math.min(minDistance, MLN.minDistanceBetweenLoneBuildings);
                }
            } else {
                minDistanceWithVillages = Math.min(minDistance, MLN.minDistanceBetweenVillages);
                minDistanceWithLoneBuildings = Math.min(minDistance, MLN.minDistanceBetweenVillagesAndLoneBuildings);
            }
            for (Point thp : mw.villagesList.pos) {
                if (!(p.distanceTo(thp) < (double)minDistanceWithVillages)) continue;
                if (MLN.LogWorldGeneration >= 1) {
                    MLN.major(this, "Found a nearby village on second attempt.");
                }
                return false;
            }
            for (Point thp : mw.loneBuildingsList.pos) {
                if (!(p.distanceTo(thp) < (double)minDistanceWithLoneBuildings)) continue;
                if (MLN.LogWorldGeneration >= 1) {
                    MLN.major(this, "Found a nearby lone building on second attempt.");
                }
                return false;
            }
        }
        if (MLN.LogWorldGeneration >= 1) {
            MLN.major(this, p + ": Generating village");
        }
        if (MLN.LogWorldGeneration >= 1) {
            for (BuildingLocation bl : plannedBuildings) {
                MLN.major(this, "Building " + bl.key + ": " + bl.minx + "/" + bl.minz + " to " + bl.maxx + "/" + bl.maxz);
            }
        }
        startTime = System.nanoTime();
        Vector<BuildingPlan.LocationBuildingPair> lbps = village.centreBuilding.buildLocation(mw, village, plannedBuildings.get(0), true, true, null, false, player);
        Building townHallEntity = lbps.firstElement().building;
        if (MLN.LogWorldGeneration >= 1) {
            MLN.major(this, "Registering building: " + townHallEntity);
        }
        townHallEntity.villageType = village;
        townHallEntity.findName(name);
        townHallEntity.initialiseBuildingProjects();
        townHallEntity.registerBuildingLocation(plannedBuildings.get(0));
        for (BuildingPlan.LocationBuildingPair lbp : lbps) {
            if (lbp == lbps.firstElement()) continue;
            townHallEntity.registerBuildingEntity(lbp.building);
            townHallEntity.registerBuildingLocation(lbp.location);
        }
        for (int i = 1; i < plannedBuildings.size(); ++i) {
            BuildingLocation bl = plannedBuildings.get(i);
            lbps = village.culture.getBuildingPlanSet(bl.key).buildLocation(mw, village, bl, true, false, townHallEntity.getPos(), false, player);
            if (MLN.LogWorldGeneration >= 1) {
                MLN.major(this, "Registering building: " + bl.key);
            }
            for (BuildingPlan.LocationBuildingPair lbp : lbps) {
                townHallEntity.registerBuildingEntity(lbp.building);
                townHallEntity.registerBuildingLocation(lbp.location);
            }
        }
        townHallEntity.initialiseVillage();
        String playerName = null;
        if (closestPlayer != null) {
            playerName = closestPlayer.getDisplayName();
        }
        if (loneBuildings) {
            mw.registerLoneBuildingsLocation(world, townHallEntity.getPos(), townHallEntity.getVillageQualifiedName(), townHallEntity.villageType, townHallEntity.culture, true, playerName);
        } else {
            mw.registerVillageLocation(world, townHallEntity.getPos(), townHallEntity.getVillageQualifiedName(), townHallEntity.villageType, townHallEntity.culture, true, playerName);
            townHallEntity.initialiseRelations(parentVillage);
            if (village.playerControlled) {
                townHallEntity.storeGoods(Mill.parchmentVillageScroll, mw.villagesList.pos.size() - 1, 1);
            }
        }
        if (MLN.LogWorldGeneration >= 1) {
            MLN.major(this, "New village generated at " + p + ", took: " + (System.nanoTime() - startTime));
        }
        for (String key : village.hamlets) {
            VillageType hamlet = village.culture.getVillageType(key);
            if (hamlet == null) continue;
            if (MLN.LogWorldGeneration >= 1) {
                MLN.major(this, "Trying to generate a hamlet: " + hamlet);
            }
            this.generateHamlet(world, hamlet, townHallEntity.getPos(), townHallEntity.getVillageNameWithoutQualifier(), random);
        }
        return true;
    }

    public boolean generateVillageAtPoint(World world, Random random, int x, int y, int z, EntityPlayer generatingPlayer, boolean checkForUnloaded, boolean alwaysGenerate, int minDistance, VillageType villageType, String name, Point parentVillage) {
        if (!Mill.loadingComplete || !MLN.generateVillages && !MLN.generateLoneBuildings && !alwaysGenerate) {
            return false;
        }
        if (world.field_72995_K) {
            return false;
        }
        MillWorld mw = Mill.getMillWorld(world);
        if (mw == null) {
            return false;
        }
        Point p = new Point(x, 65.0, z);
        EntityPlayer closestPlayer = generatingPlayer;
        if (closestPlayer == null) {
            closestPlayer = world.func_72977_a((double)x, 64.0, (double)z, 200.0);
        }
        try {
            boolean success;
            if (MLN.LogWorldGeneration >= 3) {
                MLN.debug(this, "Called for point: " + x + "/" + y + "/" + z);
            }
            MillCommonUtilities.random = random;
            boolean areaLoaded = false;
            if (checkForUnloaded) {
                if (!world.func_72904_c(x - 80, y, z - 80, x + 80, y, z + 80)) {
                    for (int i = -6; i < 7 && !areaLoaded; ++i) {
                        for (int j = -6; j < 7 && !areaLoaded; ++j) {
                            Point np;
                            int tx = x + i * 16;
                            int tz = z + j * 16;
                            if (coordsTried.contains(tx + (tz << 16)) || !world.func_72904_c(tx - 80, y, tz - 80, tx + 80, y, tz + 80)) continue;
                            x = tx;
                            z = tz;
                            areaLoaded = true;
                            p = np = new Point((x >> 4) * 16 + 8, 0.0, (z >> 4) * 16 + 8);
                        }
                    }
                } else {
                    areaLoaded = true;
                }
                if (!areaLoaded) {
                    if (generatingPlayer != null) {
                        ServerSender.sendTranslatedSentence(generatingPlayer, '6', "ui.worldnotgenerated", new String[0]);
                    }
                    return false;
                }
                if (p.horizontalDistanceTo(world.func_72861_E()) < (double)MLN.spawnProtectionRadius && Mill.proxy.isTrueServer()) {
                    if (generatingPlayer != null) {
                        ServerSender.sendTranslatedSentence(generatingPlayer, '6', "ui.tooclosetospawn", new String[0]);
                    }
                    return false;
                }
            }
            long startTime = System.nanoTime();
            coordsTried.add(x + (z << 16));
            if (MLN.generateVillages || alwaysGenerate) {
                boolean canAttemptVillage = true;
                int minDistanceVillages = Math.min(minDistance, MLN.minDistanceBetweenVillages);
                int minDistanceLoneBuildings = Math.min(minDistance, MLN.minDistanceBetweenVillagesAndLoneBuildings);
                if (generatingPlayer == null) {
                    if (p.horizontalDistanceTo(world.func_72861_E()) < (double)MLN.spawnProtectionRadius) {
                        canAttemptVillage = false;
                    }
                    for (Point thp : mw.villagesList.pos) {
                        if (!(p.distanceTo(thp) < (double)minDistanceVillages)) continue;
                        if (MLN.LogWorldGeneration >= 3) {
                            MLN.debug(this, "Time taken for finding near villages: " + (System.nanoTime() - startTime));
                        }
                        canAttemptVillage = false;
                    }
                    for (Point thp : mw.loneBuildingsList.pos) {
                        if (!(p.distanceTo(thp) < (double)minDistanceLoneBuildings)) continue;
                        if (MLN.LogWorldGeneration >= 3) {
                            MLN.debug(this, "Time taken for finding near lone buildings: " + (System.nanoTime() - startTime));
                        }
                        canAttemptVillage = false;
                    }
                }
                if (MLN.LogWorldGeneration >= 3) {
                    MLN.debug(this, "Time taken for finding near villages (not found): " + (System.nanoTime() - startTime));
                }
                if (canAttemptVillage) {
                    VillageType village;
                    if (villageType == null) {
                        String biomeName = world.func_72959_q().func_76935_a((int)x, (int)z).field_76791_y.toLowerCase();
                        Vector<VillageType> acceptableVillageType = new Vector<VillageType>();
                        HashMap<String, Integer> nbVillages = new HashMap<String, Integer>();
                        for (String type : mw.villagesList.types) {
                            if (nbVillages.containsKey(type)) {
                                nbVillages.put(type, (Integer)nbVillages.get(type) + 1);
                                continue;
                            }
                            nbVillages.put(type, 1);
                        }
                        for (Culture c : Culture.vectorCultures) {
                            for (VillageType vt : c.vectorVillageTypes) {
                                if (!vt.isValidForGeneration(Mill.getMillWorld(world), closestPlayer, nbVillages, new Point(x, 60.0, z), biomeName, false)) continue;
                                acceptableVillageType.add(vt);
                            }
                        }
                        village = acceptableVillageType.size() != 0 ? (VillageType)MillCommonUtilities.getWeightedChoice(acceptableVillageType, closestPlayer) : null;
                    } else {
                        village = villageType;
                    }
                    if (village != null && this.generateVillage(p, world, village, generatingPlayer, closestPlayer, random, minDistance, name, false, parentVillage)) {
                        return true;
                    }
                }
            }
            if (generatingPlayer != null || !MLN.generateLoneBuildings) {
                return false;
            }
            if (villageType != null) {
                return false;
            }
            boolean keyLoneBuildingsOnly = false;
            int minDistanceWithVillages = Math.min(minDistance, MLN.minDistanceBetweenVillagesAndLoneBuildings);
            int minDistanceWithLoneBuildings = Math.min(minDistance, MLN.minDistanceBetweenLoneBuildings);
            for (Point thp : mw.villagesList.pos) {
                if (p.distanceTo(thp) < (double)(minDistanceWithVillages / 2)) {
                    if (MLN.LogWorldGeneration >= 3) {
                        MLN.debug(this, "Time taken for finding near villages: " + (System.nanoTime() - startTime));
                    }
                    return false;
                }
                if (!(p.distanceTo(thp) < (double)minDistanceWithVillages)) continue;
                keyLoneBuildingsOnly = true;
            }
            for (Point thp : mw.loneBuildingsList.pos) {
                if (p.distanceTo(thp) < (double)(minDistanceWithLoneBuildings / 4)) {
                    if (MLN.LogWorldGeneration >= 3) {
                        MLN.debug(this, "Time taken for finding near villages: " + (System.nanoTime() - startTime));
                    }
                    return false;
                }
                if (!(p.distanceTo(thp) < (double)minDistanceWithLoneBuildings)) continue;
                keyLoneBuildingsOnly = true;
            }
            if (MLN.LogWorldGeneration >= 3) {
                MLN.debug(this, "Time taken for finding near villages (not found): " + (System.nanoTime() - startTime));
            }
            String biomeName = world.func_72959_q().func_76935_a((int)x, (int)z).field_76791_y.toLowerCase();
            Vector<VillageType> acceptableLoneBuildingsType = new Vector<VillageType>();
            HashMap<String, Integer> nbLoneBuildings = new HashMap<String, Integer>();
            for (String type : mw.loneBuildingsList.types) {
                if (nbLoneBuildings.containsKey(type)) {
                    nbLoneBuildings.put(type, (Integer)nbLoneBuildings.get(type) + 1);
                    continue;
                }
                nbLoneBuildings.put(type, 1);
            }
            for (Culture c : Culture.vectorCultures) {
                for (VillageType vt : c.vectorLoneBuildingTypes) {
                    if (!vt.isValidForGeneration(mw, closestPlayer, nbLoneBuildings, new Point(x, 60.0, z), biomeName, keyLoneBuildingsOnly)) continue;
                    acceptableLoneBuildingsType.add(vt);
                }
            }
            if (acceptableLoneBuildingsType.size() == 0) {
                return false;
            }
            VillageType loneBuilding = (VillageType)MillCommonUtilities.getWeightedChoice(acceptableLoneBuildingsType, closestPlayer);
            if (MLN.LogWorldGeneration >= 2) {
                MLN.minor(null, "Attempting to find lone building: " + loneBuilding);
            }
            if (loneBuilding == null) {
                return false;
            }
            if (loneBuilding.isKeyLoneBuildingForGeneration(closestPlayer) && MLN.LogWorldGeneration >= 1) {
                MLN.major(null, "Attempting to generate key lone building: " + loneBuilding.key);
            }
            if ((success = this.generateVillage(p, world, loneBuilding, generatingPlayer, closestPlayer, random, minDistance, name, true, null)) && closestPlayer != null && loneBuilding.isKeyLoneBuildingForGeneration(closestPlayer) && loneBuilding.keyLoneBuildingGenerateTag != null) {
                UserProfile profile = mw.getProfile(closestPlayer.getDisplayName());
                profile.clearTag(loneBuilding.keyLoneBuildingGenerateTag);
            }
            return success;
        }
        catch (Exception e) {
            MLN.printException("Exception when generating village:", e);
            return false;
        }
    }

    private boolean isAppropriateArea(MillWorldInfo winfo, Point centre, int radius) {
        int nbtiles = 0;
        int usabletiles = 0;
        for (int i = 0; i < winfo.length; ++i) {
            for (int j = 0; j < winfo.width; ++j) {
                ++nbtiles;
                if (!winfo.canBuild[i][j]) continue;
                ++usabletiles;
            }
        }
        return (double)usabletiles * 1.0 / (double)nbtiles > 0.7;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + this.hashCode();
    }
}

