/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.goal;

import java.util.Vector;
import net.minecraft.item.ItemStack;
import org.millenaire.common.MillVillager;
import org.millenaire.common.goal.Goal;

public class GoalDeliverGoodsHousehold
extends Goal {
    @Override
    public Goal.GoalInformation getDestination(MillVillager villager) throws Exception {
        return this.packDest(villager.getHouse().getSellingPos(), villager.getHouse());
    }

    @Override
    public ItemStack[] getHeldItemsTravelling(MillVillager villager) throws Exception {
        Vector<ItemStack> items = new Vector<ItemStack>();
        for (MillVillager v : villager.getHouse().villagers) {
            for (MillVillager.InvItem key : v.requiresGoods().keySet()) {
                if (villager.countInv(key.getItem(), key.meta) <= 0) continue;
                items.add(new ItemStack(key.getItem(), 1, key.meta));
            }
        }
        return items.toArray(new ItemStack[items.size()]);
    }

    @Override
    public boolean isPossibleSpecific(MillVillager villager) throws Exception {
        return false;
    }

    @Override
    public boolean performAction(MillVillager villager) throws Exception {
        for (MillVillager v : villager.getHouse().villagers) {
            for (MillVillager.InvItem key : v.requiresGoods().keySet()) {
                villager.putInBuilding(villager.getHouse(), key.getItem(), key.meta, 256);
            }
        }
        return true;
    }

    @Override
    public int priority(MillVillager villager) throws Exception {
        return 100;
    }
}

