/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.goal.generic;

import java.io.BufferedReader;
import java.io.File;
import java.util.HashMap;
import java.util.Vector;
import org.millenaire.common.Building;
import org.millenaire.common.MLN;
import org.millenaire.common.MillVillager;
import org.millenaire.common.core.MillCommonUtilities;
import org.millenaire.common.goal.Goal;
import org.millenaire.common.goal.generic.GoalGeneric;
import org.millenaire.common.item.Goods;

public class GoalGenericCrafting
extends GoalGeneric {
    public HashMap<MillVillager.InvItem, Integer> inputs = new HashMap();
    public HashMap<MillVillager.InvItem, Integer> outputs = new HashMap();

    @Override
    public boolean swingArms() {
        return true;
    }

    @Override
    public int actionDuration(MillVillager villager) throws Exception {
        return this.duration;
    }

    @Override
    public Goal.GoalInformation getDestination(MillVillager villager) throws Exception {
        Vector<Building> buildings = this.getBuildings(villager);
        for (Building dest : buildings) {
            if (!this.isDestPossible(villager, dest)) continue;
            return this.packDest(dest.getCraftingPos(), dest);
        }
        return null;
    }

    @Override
    public boolean isPossibleGenericGoal(MillVillager villager) throws Exception {
        return true;
    }

    @Override
    public boolean performAction(MillVillager villager) throws Exception {
        Building dest = villager.getGoalBuildingDest();
        if (dest == null) {
            return true;
        }
        for (MillVillager.InvItem item : this.inputs.keySet()) {
            if (villager.countInv(item) + dest.countGoods(item) >= this.inputs.get(item)) continue;
            return true;
        }
        for (MillVillager.InvItem item : this.inputs.keySet()) {
            int nbTaken = villager.takeFromInv(item, 1024);
            dest.storeGoods(item, nbTaken);
            dest.takeGoods(item, (int)this.inputs.get(item));
        }
        for (MillVillager.InvItem item : this.outputs.keySet()) {
            dest.storeGoods(item, (int)this.outputs.get(item));
        }
        if (this.sound != null) {
            MillCommonUtilities.playSoundByMillName(villager.field_70170_p, villager.getPos(), this.sound, 10.0f);
        }
        return true;
    }

    public static GoalGenericCrafting loadGenericCraftingGoal(File file) {
        GoalGenericCrafting g = new GoalGenericCrafting();
        g.key = file.getName().split("\\.")[0].toLowerCase();
        try {
            String line;
            BufferedReader reader = MillCommonUtilities.getReader(file);
            while ((line = reader.readLine()) != null) {
                String[] temp2;
                String value;
                if (line.trim().length() <= 0 || line.startsWith("//")) continue;
                String[] temp = line.split("=");
                if (temp.length != 2) {
                    MLN.error(null, "Invalid line when loading generic crafting goal " + file.getName() + ": " + line);
                    continue;
                }
                String key = temp[0].toLowerCase();
                if (GoalGeneric.readGenericGoalConfigLine(g, key, value = temp[1], file, line)) continue;
                if (key.equals("input")) {
                    temp2 = value.split(",");
                    if (temp2.length != 2) {
                        MLN.error(null, "Inputs must take the form of input=goodname,goodquatity in generic crafting goal " + file.getName() + ": " + line);
                        continue;
                    }
                    if (Goods.goodsName.containsKey(temp2[0])) {
                        g.inputs.put(Goods.goodsName.get(temp2[0]), Integer.parseInt(temp2[1]));
                        continue;
                    }
                    MLN.error(null, "Unknown input item in generic crafting goal " + file.getName() + ": " + line);
                    continue;
                }
                if (key.equals("output")) {
                    temp2 = value.split(",");
                    if (temp2.length != 2) {
                        MLN.error(null, "Outputs must take the form of input=goodname,goodquatity in generic crafting goal " + file.getName() + ": " + line);
                        continue;
                    }
                    if (Goods.goodsName.containsKey(temp2[0])) {
                        g.outputs.put(Goods.goodsName.get(temp2[0]), Integer.parseInt(temp2[1]));
                        continue;
                    }
                    MLN.error(null, "Unknown output item in generic crafting goal " + file.getName() + ": " + line);
                    continue;
                }
                MLN.error(null, "Unknown line in generic crafting goal " + file.getName() + ": " + line);
            }
            reader.close();
        }
        catch (Exception e) {
            MLN.printException(e);
            return null;
        }
        return g;
    }

    @Override
    public boolean isDestPossibleSpecific(MillVillager villager, Building b) {
        for (MillVillager.InvItem item : this.inputs.keySet()) {
            if (villager.countInv(item) + b.countGoods(item) >= this.inputs.get(item)) continue;
            return false;
        }
        return true;
    }
}

