/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.pathing.atomicstryker;

import java.util.ArrayList;
import java.util.PriorityQueue;
import net.minecraft.world.World;
import org.millenaire.common.pathing.atomicstryker.AStarNode;
import org.millenaire.common.pathing.atomicstryker.AStarPathPlanner;
import org.millenaire.common.pathing.atomicstryker.AStarStatic;

public class AStarWorker
implements Runnable {
    private final long SEARCH_TIME_LIMIT = 150L;
    public AStarPathPlanner boss;
    public boolean isRunning = false;
    public final ArrayList<AStarNode> closedNodes;
    private AStarNode startNode;
    protected AStarNode targetNode;
    private boolean allowDropping;
    protected World worldObj;
    private long timeLimit;
    private final PriorityQueue<AStarNode> queue;
    private boolean isBusy = false;

    public boolean isBusy() {
        return this.isBusy;
    }

    public AStarWorker(AStarPathPlanner creator) {
        this.boss = creator;
        this.closedNodes = new ArrayList();
        this.queue = new PriorityQueue(500);
    }

    private void addToBinaryHeap(AStarNode input) {
        this.queue.offer(input);
    }

    private void checkPossibleLadder(AStarNode node) {
        int x = node.x;
        int y = node.y;
        int z = node.z;
        if (AStarStatic.isLadder(this.worldObj, this.worldObj.func_147439_a(x, y, z), x, y, z)) {
            AStarNode ladder = null;
            if (AStarStatic.isLadder(this.worldObj, this.worldObj.func_147439_a(x, y + 1, z), x, y + 1, z)) {
                // empty if block
            }
            if (!this.tryToUpdateExistingHeapNode(node, ladder = new AStarNode(x, y + 1, z, node.getG() + 2, node, this.targetNode))) {
                this.addToBinaryHeap(ladder);
            }
            if (AStarStatic.isLadder(this.worldObj, this.worldObj.func_147439_a(x, y - 1, z), x, y - 1, z)) {
                // empty if block
            }
            if (!this.tryToUpdateExistingHeapNode(node, ladder = new AStarNode(x, y - 1, z, node.getG() + 2, node, this.targetNode))) {
                this.addToBinaryHeap(ladder);
            }
        }
    }

    private int getCostNodeToNode(AStarNode a, AStarNode b) {
        return Math.abs(a.x - b.x) + Math.abs(a.y - b.y) + Math.abs(a.z - b.z);
    }

    public void getNextCandidates(AStarNode parent, boolean droppingAllowed) {
        int x = parent.x;
        int y = parent.y;
        int z = parent.z;
        int[][] c = droppingAllowed ? AStarStatic.candidates_allowdrops : AStarStatic.candidates;
        for (int i = 0; i < c.length; ++i) {
            AStarNode check = new AStarNode(x + c[i][0], y + c[i][1], z + c[i][2], parent.getG() + c[i][3], parent, this.targetNode);
            boolean found = false;
            for (AStarNode toUpdate : this.closedNodes) {
                if (!check.equals(toUpdate)) continue;
                toUpdate.updateDistance(check.getG() + this.getCostNodeToNode(toUpdate, check), parent);
                found = true;
                break;
            }
            if (found || this.tryToUpdateExistingHeapNode(parent, check) || !AStarStatic.isViable(this.worldObj, check, c[i][1], this.boss.config)) continue;
            this.addToBinaryHeap(check);
        }
    }

    public ArrayList<AStarNode> getPath(AStarNode start, AStarNode end, boolean searchMode) {
        this.queue.offer(start);
        this.targetNode = end;
        AStarNode current = start;
        while (!this.isNodeEnd(current, end)) {
            this.closedNodes.add(this.queue.poll());
            this.checkPossibleLadder(current);
            this.getNextCandidates(current, searchMode);
            if (this.queue.isEmpty() || this.shouldInterrupt()) {
                return null;
            }
            current = this.queue.peek();
        }
        ArrayList<AStarNode> foundpath = new ArrayList<AStarNode>();
        foundpath.add(current);
        while (current != start) {
            foundpath.add(current.parent);
            current = current.parent;
        }
        return foundpath;
    }

    protected boolean isCoordsEnd(int x, int y, int z, AStarNode end) {
        if (!this.boss.config.tolerance) {
            return x == end.x && y == end.y && z == end.z;
        }
        return Math.abs(x - end.x) <= this.boss.config.toleranceHorizontal && Math.abs(z - end.z) <= this.boss.config.toleranceHorizontal && Math.abs(y - end.y) <= this.boss.config.toleranceVertical;
    }

    protected boolean isNodeEnd(AStarNode cn, AStarNode end) {
        return this.isCoordsEnd(cn.x, cn.y, cn.z, end);
    }

    @Override
    public void run() {
        this.isBusy = true;
        this.timeLimit = System.currentTimeMillis() + 150L;
        ArrayList<AStarNode> result = null;
        result = this.getPath(this.startNode, this.targetNode, this.allowDropping);
        if (result == null) {
            this.boss.onNoPathAvailable();
        } else {
            this.boss.onFoundPath(result);
        }
        this.isBusy = false;
    }

    public void setup(World winput, AStarNode start, AStarNode end, boolean mode) {
        this.worldObj = winput;
        this.startNode = start;
        this.targetNode = end;
        this.allowDropping = mode;
    }

    protected boolean shouldInterrupt() {
        return System.currentTimeMillis() > this.timeLimit;
    }

    private boolean tryToUpdateExistingHeapNode(AStarNode parent, AStarNode checkedOne) {
        for (AStarNode itNode : this.queue) {
            if (!itNode.equals(checkedOne)) continue;
            itNode.updateDistance(checkedOne.getG(), parent);
            return true;
        }
        return false;
    }
}

