/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod;

import ckathode.weaponmod.AdvancedExplosion;
import ckathode.weaponmod.BalkonsWeaponMod;
import ckathode.weaponmod.network.MsgExplosion;
import cpw.mods.fml.common.network.NetworkRegistry;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public abstract class PhysHelper {
    private static double kbMotionX = 0.0;
    private static double kbMotionY = 0.0;
    private static double kbMotionZ = 0.0;
    private static int knockBackModifier = 0;

    public static AdvancedExplosion createStandardExplosion(World world, Entity entity, double d, double d1, double d2, float size) {
        AdvancedExplosion explosion = new AdvancedExplosion(world, entity, d, d1, d2, size);
        explosion.doEntityExplosion();
        explosion.doBlockExplosion();
        explosion.doParticleExplosion(true, true);
        PhysHelper.sendExplosion(world, explosion, true, true);
        return explosion;
    }

    public static AdvancedExplosion createAdvancedExplosion(World world, Entity entity, double d, double d1, double d2, float size, boolean destroyBlocks, boolean spawnSmallParticles, boolean spawnBigParticles) {
        AdvancedExplosion explosion = new AdvancedExplosion(world, entity, d, d1, d2, size);
        explosion.doEntityExplosion();
        if (destroyBlocks) {
            explosion.doBlockExplosion();
        }
        explosion.doParticleExplosion(spawnSmallParticles, spawnBigParticles);
        PhysHelper.sendExplosion(world, explosion, spawnSmallParticles, spawnBigParticles);
        return explosion;
    }

    public static AdvancedExplosion createAdvancedExplosion(World world, Entity entity, DamageSource damagesource, double d, double d1, double d2, float size, boolean destroyBlocks, boolean spawnSmallParticles, boolean spawnBigParticles) {
        AdvancedExplosion explosion = new AdvancedExplosion(world, entity, d, d1, d2, size);
        explosion.doEntityExplosion(damagesource);
        if (destroyBlocks) {
            explosion.doBlockExplosion();
        }
        explosion.doParticleExplosion(spawnSmallParticles, spawnBigParticles);
        PhysHelper.sendExplosion(world, explosion, spawnSmallParticles, spawnBigParticles);
        return explosion;
    }

    public static AdvancedExplosion createAdvancedExplosion(World world, Entity entity, double d, double d1, double d2, float size, boolean destroyBlocks, boolean spawnParticles) {
        AdvancedExplosion explosion = new AdvancedExplosion(world, entity, d, d1, d2, size);
        explosion.doEntityExplosion();
        if (destroyBlocks) {
            explosion.doBlockExplosion();
        }
        explosion.doParticleExplosion(spawnParticles, spawnParticles);
        PhysHelper.sendExplosion(world, explosion, spawnParticles, spawnParticles);
        return explosion;
    }

    private static void sendExplosion(World world, AdvancedExplosion explosion, boolean smallparts, boolean bigparts) {
        if (world instanceof WorldServer && !world.field_72995_K) {
            MsgExplosion msg = new MsgExplosion(explosion, smallparts, bigparts);
            BalkonsWeaponMod.instance.messagePipeline.sendToAllAround(msg, new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, explosion.field_77284_b, explosion.field_77285_c, explosion.field_77282_d, 64.0));
        }
    }

    public static void knockBack(EntityLivingBase entityliving, EntityLivingBase attacker, float knockback) {
        entityliving.field_70159_w = kbMotionX;
        entityliving.field_70181_x = kbMotionY;
        entityliving.field_70179_y = kbMotionZ;
        double dx = attacker.field_70165_t - entityliving.field_70165_t;
        double dz = attacker.field_70161_v - entityliving.field_70161_v;
        while (dx * dx + dz * dz < 1.0E-4) {
            dx = (Math.random() - Math.random()) * 0.01;
            dz = (Math.random() - Math.random()) * 0.01;
        }
        entityliving.field_70739_aP = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - entityliving.field_70177_z;
        float f = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
        entityliving.field_70159_w -= dx / (double)f * (double)knockback;
        entityliving.field_70181_x += (double)knockback;
        entityliving.field_70179_y -= dz / (double)f * (double)knockback;
        if (entityliving.field_70181_x > 0.4) {
            entityliving.field_70181_x = 0.4;
        }
        if (knockBackModifier > 0) {
            dx = -Math.sin(Math.toRadians(attacker.field_70177_z)) * (double)knockBackModifier * 0.5;
            dz = Math.cos(Math.toRadians(attacker.field_70177_z)) * (double)knockBackModifier * 0.5;
            entityliving.func_70024_g(dx, 0.1, dz);
        }
        knockBackModifier = 0;
        kbMotionZ = 0.0;
        kbMotionY = 0.0;
        kbMotionX = 0.0;
    }

    public static void prepareKnockbackOnEntity(EntityLivingBase attacker, EntityLivingBase entity) {
        knockBackModifier = EnchantmentHelper.func_77507_b((EntityLivingBase)attacker, (EntityLivingBase)entity);
        if (attacker.func_70051_ag()) {
            ++knockBackModifier;
        }
        kbMotionX = entity.field_70159_w;
        kbMotionY = entity.field_70181_x;
        kbMotionZ = entity.field_70179_y;
    }
}

