/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity.projectile;

import ckathode.weaponmod.WeaponDamageSource;
import ckathode.weaponmod.entity.projectile.EntityMaterialProjectile;
import ckathode.weaponmod.item.ItemFlail;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityFlail
extends EntityMaterialProjectile {
    public boolean isSwinging;
    private float flailDamage;
    private double distanceTotal;
    private double distanceX;
    private double distanceY;
    private double distanceZ;

    public EntityFlail(World world) {
        super(world);
        this.field_70158_ak = true;
        this.flailDamage = 1.0f;
        this.distanceTotal = 0.0;
        this.distanceZ = 0.0;
        this.distanceY = 0.0;
        this.distanceX = 0.0;
    }

    public EntityFlail(World world, double d, double d1, double d2) {
        this(world);
        this.func_70107_b(d, d1, d2);
    }

    public EntityFlail(World world, EntityLivingBase entityliving, ItemStack itemstack) {
        this(world);
        this.field_70250_c = entityliving;
        this.setPickupModeFromEntity(entityliving);
        this.setThrownItemStack(itemstack);
        this.distanceTotal = 0.0;
        this.func_70012_b(entityliving.field_70165_t, entityliving.field_70163_u + (double)entityliving.func_70047_e(), entityliving.field_70161_v, entityliving.field_70177_z, entityliving.field_70125_A);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * 3.141593f)) * 0.16f);
        this.field_70163_u -= 0.4;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * 3.141593f)) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.swing();
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70250_c != null) {
            ItemStack itemstack;
            this.distanceX = this.field_70250_c.field_70165_t - this.field_70165_t;
            this.distanceY = this.field_70250_c.field_70163_u - this.field_70163_u;
            this.distanceZ = this.field_70250_c.field_70161_v - this.field_70161_v;
            this.distanceTotal = Math.sqrt(this.distanceX * this.distanceX + this.distanceY * this.distanceY + this.distanceZ * this.distanceZ);
            if (this.distanceTotal > 3.0) {
                this.returnToOwner(this.field_70250_c, true);
            }
            if (this.field_70250_c instanceof EntityPlayer && ((itemstack = ((EntityPlayer)this.field_70250_c).func_71045_bC()) == null || this.thrownItem != null && itemstack.func_77973_b() != this.thrownItem.func_77973_b())) {
                this.pickUpByOwner();
            }
        }
        if (this.field_70254_i) {
            this.field_70254_i = false;
            return;
        }
        this.returnToOwner(this.field_70250_c, false);
    }

    public void returnToOwner(Entity entity, boolean looseFromGround) {
        if (entity == null) {
            return;
        }
        if (looseFromGround) {
            this.field_70254_i = false;
        }
        double targetPosX = this.field_70250_c.field_70165_t;
        double targetPosY = this.field_70250_c.field_70121_D.field_72338_b + (double)0.4f;
        double targetPosZ = this.field_70250_c.field_70161_v;
        float f = 27.0f;
        float f1 = 2.0f;
        this.distanceX = (targetPosX += -Math.sin((double)((this.field_70250_c.field_70177_z + f) / 180.0f) * Math.PI) * Math.cos((double)(this.field_70250_c.field_70125_A / 180.0f) * Math.PI) * (double)f1) - this.field_70165_t;
        this.distanceY = targetPosY - this.field_70163_u;
        this.distanceZ = (targetPosZ += Math.cos((double)((this.field_70250_c.field_70177_z + f) / 180.0f) * Math.PI) * Math.cos((double)(this.field_70250_c.field_70125_A / 180.0f) * Math.PI) * (double)f1) - this.field_70161_v;
        this.distanceTotal = Math.sqrt(this.distanceX * this.distanceX + this.distanceY * this.distanceY + this.distanceZ * this.distanceZ);
        if (this.distanceTotal > 3.0) {
            this.field_70165_t = targetPosX;
            this.field_70163_u = targetPosY;
            this.field_70161_v = targetPosZ;
        } else if (this.distanceTotal > 2.5) {
            this.isSwinging = false;
            this.field_70159_w *= -0.5;
            this.field_70181_x *= -0.5;
            this.field_70179_y *= -0.5;
        }
        if (!this.isSwinging) {
            float f6 = 0.2f;
            this.field_70159_w = this.distanceX * (double)f6 * this.distanceTotal;
            this.field_70181_x = this.distanceY * (double)f6 * this.distanceTotal;
            this.field_70179_y = this.distanceZ * (double)f6 * this.distanceTotal;
        }
    }

    public void pickUpByOwner() {
        this.func_70106_y();
        if (this.field_70250_c instanceof EntityPlayer) {
            ((ItemFlail)this.thrownItem.func_77973_b()).setThrown((EntityPlayer)this.field_70250_c, false);
        }
    }

    public void swing() {
        if (this.isSwinging) {
            return;
        }
        this.field_70170_p.func_72956_a(this.field_70250_c, "random.bow", 0.5f, 0.4f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70250_c.field_70177_z / 180.0f * 3.141593f)) * MathHelper.func_76134_b((float)(this.field_70250_c.field_70125_A / 180.0f * 3.141593f));
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70250_c.field_70125_A / 180.0f * 3.141593f));
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70250_c.field_70177_z / 180.0f * 3.141593f)) * MathHelper.func_76134_b((float)(this.field_70250_c.field_70125_A / 180.0f * 3.141593f));
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, 0.75f, 3.0f);
        this.isSwinging = true;
        this.field_70254_i = false;
    }

    @Override
    public void onEntityHit(Entity entity) {
        if (entity == this.field_70250_c) {
            return;
        }
        DamageSource damagesource = null;
        damagesource = this.field_70250_c instanceof EntityLivingBase ? DamageSource.func_76358_a((EntityLivingBase)((EntityLivingBase)this.field_70250_c)) : WeaponDamageSource.causeProjectileWeaponDamage(this, (Entity)this);
        if (entity.func_70097_a(damagesource, this.flailDamage + this.extraDamage)) {
            this.playHitSound();
            this.returnToOwner(this.field_70250_c, true);
        } else {
            this.bounceBack();
        }
    }

    @Override
    public void bounceBack() {
        this.field_70159_w *= -0.8;
        this.field_70181_x *= -0.8;
        this.field_70179_y *= -0.8;
        this.field_70177_z += 180.0f;
        this.field_70126_B += 180.0f;
        this.field_70257_an = 0;
    }

    @Override
    public void playHitSound() {
        if (this.field_70254_i) {
            return;
        }
        this.field_70170_p.func_72956_a((Entity)this, "damage.hurtflesh", 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f);
    }

    @Override
    public void setThrownItemStack(ItemStack itemstack) {
        if (!(itemstack.func_77973_b() instanceof ItemFlail)) {
            return;
        }
        super.setThrownItemStack(itemstack);
        this.flailDamage = ((ItemFlail)itemstack.func_77973_b()).getFlailDamage();
    }

    @Override
    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74776_a("fDmg", this.flailDamage);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.flailDamage = nbttagcompound.func_74760_g("fDmg");
    }

    @Override
    public void func_70100_b_(EntityPlayer entityplayer) {
    }

    @Override
    public int getMaxArrowShake() {
        return 0;
    }

    @Override
    public float func_70053_R() {
        return 0.2f;
    }
}

