/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.item;

import ckathode.weaponmod.BalkonsWeaponMod;
import ckathode.weaponmod.ReloadHelper;
import ckathode.weaponmod.WeaponModAttributes;
import ckathode.weaponmod.entity.projectile.EntityProjectile;
import ckathode.weaponmod.item.AbstractWeaponComponent;
import com.google.common.collect.Multimap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public abstract class RangedComponent
extends AbstractWeaponComponent {
    protected static final int MAX_DELAY = 72000;
    public final RangedSpecs rangedSpecs;

    public static boolean isReloaded(ItemStack itemstack) {
        return ReloadHelper.getReloadState(itemstack) >= ReloadHelper.STATE_RELOADED;
    }

    public static boolean isReadyToFire(ItemStack itemstack) {
        return ReloadHelper.getReloadState(itemstack) == ReloadHelper.STATE_READY;
    }

    public static void setReloadState(ItemStack itemstack, int state) {
        ReloadHelper.setReloadState(itemstack, state);
    }

    public RangedComponent(RangedSpecs rangedspecs) {
        this.rangedSpecs = rangedspecs;
    }

    @Override
    protected void onSetItem() {
    }

    @Override
    public void setThisItemProperties() {
        this.item.func_77656_e(this.rangedSpecs.durability);
        this.item.func_77625_d(this.rangedSpecs.stackSize);
    }

    @Override
    public float getEntityDamageMaterialPart() {
        return 0.0f;
    }

    @Override
    public float getEntityDamage() {
        return 0.0f;
    }

    @Override
    public float getBlockDamage(ItemStack itemstack, Block block) {
        return 0.0f;
    }

    @Override
    public boolean canHarvestBlock(Block block) {
        return false;
    }

    @Override
    public boolean onBlockDestroyed(ItemStack itemstack, World world, Block block, int j, int k, int l, EntityLivingBase entityliving) {
        return false;
    }

    @Override
    public boolean hitEntity(ItemStack itemstack, EntityLivingBase entityliving, EntityLivingBase attacker) {
        return false;
    }

    @Override
    public float getKnockBack(ItemStack itemstack, EntityLivingBase entityliving, EntityLivingBase attacker) {
        return 0.0f;
    }

    @Override
    public int getItemEnchantability() {
        return 1;
    }

    @Override
    public void addItemAttributeModifiers(Multimap<String, AttributeModifier> multimap) {
        multimap.put((Object)WeaponModAttributes.RELOAD_TIME.func_111108_a(), (Object)new AttributeModifier(this.weapon.getUUID(), "Weapon reloadtime modifier", (double)this.rangedSpecs.getReloadTime(), 0));
    }

    @Override
    public boolean onLeftClickEntity(ItemStack itemstack, EntityPlayer player, Entity entity) {
        return false;
    }

    @Override
    public EnumAction getItemUseAction(ItemStack itemstack) {
        int state = ReloadHelper.getReloadState(itemstack);
        if (state == ReloadHelper.STATE_NONE) {
            return EnumAction.block;
        }
        if (state == ReloadHelper.STATE_READY) {
            return EnumAction.bow;
        }
        return EnumAction.none;
    }

    @Override
    public int getMaxItemUseDuration(ItemStack itemstack) {
        return 72000;
    }

    @Override
    public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (itemstack.field_77994_a <= 0 || entityplayer.func_71039_bw()) {
            return itemstack;
        }
        if (this.hasAmmo(itemstack, world, entityplayer)) {
            if (RangedComponent.isReadyToFire(itemstack)) {
                this.soundCharge(itemstack, world, entityplayer);
                entityplayer.func_71008_a(itemstack, this.getMaxItemUseDuration(itemstack));
            } else {
                entityplayer.func_71008_a(itemstack, this.getMaxItemUseDuration(itemstack));
            }
        } else {
            this.soundEmpty(itemstack, world, entityplayer);
            RangedComponent.setReloadState(itemstack, ReloadHelper.STATE_NONE);
        }
        return itemstack;
    }

    @Override
    public void onUsingTick(ItemStack itemstack, EntityPlayer entityplayer, int count) {
        if (ReloadHelper.getReloadState(itemstack) == ReloadHelper.STATE_NONE && this.getMaxItemUseDuration(itemstack) - count >= this.getReloadDuration(itemstack)) {
            this.effectReloadDone(itemstack, entityplayer.field_70170_p, entityplayer);
            entityplayer.func_71041_bz();
            RangedComponent.setReloadState(itemstack, ReloadHelper.STATE_RELOADED);
        }
    }

    @Override
    public void onPlayerStoppedUsing(ItemStack itemstack, World world, EntityPlayer entityplayer, int i) {
        if (!RangedComponent.isReloaded(itemstack)) {
            return;
        }
        if (RangedComponent.isReadyToFire(itemstack)) {
            if (this.hasAmmoAndConsume(itemstack, world, entityplayer)) {
                this.fire(itemstack, world, entityplayer, i);
            }
            RangedComponent.setReloadState(itemstack, ReloadHelper.STATE_NONE);
        } else {
            RangedComponent.setReloadState(itemstack, ReloadHelper.STATE_READY);
        }
    }

    @Override
    public void onUpdate(ItemStack itemstack, World world, Entity entity, int i, boolean flag) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldRotateAroundWhenRendering() {
        return false;
    }

    public void soundEmpty(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        world.func_72956_a((Entity)entityplayer, "random.click", 1.0f, 1.25f);
    }

    public void soundCharge(ItemStack itemstack, World world, EntityPlayer entityplayer) {
    }

    public final void postShootingEffects(ItemStack itemstack, EntityPlayer entityplayer, World world) {
        this.effectPlayer(itemstack, entityplayer, world);
        this.effectShoot(world, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, entityplayer.field_70177_z, entityplayer.field_70125_A);
    }

    public abstract void effectReloadDone(ItemStack var1, World var2, EntityPlayer var3);

    public abstract void fire(ItemStack var1, World var2, EntityPlayer var3, int var4);

    public abstract void effectPlayer(ItemStack var1, EntityPlayer var2, World var3);

    public abstract void effectShoot(World var1, double var2, double var4, double var6, float var8, float var9);

    public void applyProjectileEnchantments(EntityProjectile entity, ItemStack itemstack) {
        int knockback;
        int damage;
        if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77342_w.field_77352_x, (ItemStack)itemstack) > 0) {
            entity.setPickupMode(0);
        }
        if ((damage = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)itemstack)) > 0) {
            entity.setExtraDamage(damage);
        }
        if ((knockback = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)itemstack)) > 0) {
            entity.func_70240_a(knockback);
        }
        if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)itemstack) > 0) {
            entity.func_70015_d(100);
        }
    }

    public int getReloadDuration(ItemStack itemstack) {
        return this.rangedSpecs.getReloadTime();
    }

    public Item getAmmoItem() {
        return this.rangedSpecs.getAmmoItem();
    }

    public boolean hasAmmoAndConsume(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        return entityplayer.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((int)Enchantment.field_77342_w.field_77352_x, (ItemStack)itemstack) > 0 || entityplayer.field_71071_by.func_146026_a(this.getAmmoItem());
    }

    public boolean hasAmmo(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        return entityplayer.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((int)Enchantment.field_77342_w.field_77352_x, (ItemStack)itemstack) > 0 || entityplayer.field_71071_by.func_146028_b(this.getAmmoItem());
    }

    public static enum RangedSpecs {
        BLOWGUN("weaponmod:dart", "blowgun", 250, 1),
        CROSSBOW("weaponmod:bolt", "crossbow", 250, 1),
        MUSKET("weaponmod:bullet", "musket", 80, 1),
        BLUNDERBUSS("weaponmod:shot", "blunderbuss", 80, 1),
        FLINTLOCK("weaponmod:bullet", "flintlock", 80, 1);

        private int reloadTime;
        private Item ammoItem;
        private String ammoItemTag;
        public final String reloadTimeTag;
        public final int durability;
        public final int stackSize;

        private RangedSpecs(String ammoitemtag, String reloadtimetag, int durability, int stacksize) {
            this.ammoItemTag = ammoitemtag;
            this.reloadTimeTag = reloadtimetag;
            this.durability = durability;
            this.stackSize = stacksize;
            this.ammoItem = null;
            this.reloadTime = -1;
        }

        public int getReloadTime() {
            if (this.reloadTime < 0 && BalkonsWeaponMod.instance != null) {
                this.reloadTime = BalkonsWeaponMod.instance.modConfig.getReloadTime(this.reloadTimeTag);
                BalkonsWeaponMod.modLog.debug("Found reaload time " + this.reloadTime + " for " + this.reloadTimeTag + " @" + (Object)((Object)this));
            }
            return this.reloadTime;
        }

        public Item getAmmoItem() {
            if (this.ammoItem == null && this.ammoItemTag != null) {
                this.ammoItem = (Item)Item.field_150901_e.func_82594_a(this.ammoItemTag);
                BalkonsWeaponMod.modLog.debug("Found item " + this.ammoItem + " for " + this.ammoItemTag + " @" + (Object)((Object)this));
                this.ammoItemTag = null;
            }
            return this.ammoItem;
        }
    }
}

