/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity.projectile;

import ckathode.weaponmod.entity.projectile.EntityProjectile;
import ckathode.weaponmod.entity.projectile.MaterialRegistry;
import ckathode.weaponmod.item.IItemWeapon;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public abstract class EntityMaterialProjectile
extends EntityProjectile {
    private static final float[][] MATERIAL_COLORS = new float[][]{{0.6f, 0.4f, 0.1f}, {0.5f, 0.5f, 0.5f}, {1.0f, 1.0f, 1.0f}, {0.0f, 0.8f, 0.7f}, {1.0f, 0.9f, 0.0f}};
    protected ItemStack thrownItem;

    public EntityMaterialProjectile(World world) {
        super(world);
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(25, (Object)0);
    }

    public float getMeleeHitDamage(Entity entity) {
        if (this.field_70250_c instanceof EntityLivingBase && entity instanceof EntityLivingBase) {
            return EnchantmentHelper.func_77512_a((EntityLivingBase)((EntityLivingBase)this.field_70250_c), (EntityLivingBase)((EntityLivingBase)entity));
        }
        return 0.0f;
    }

    @Override
    public void applyEntityHitEffects(Entity entity) {
        super.applyEntityHitEffects(entity);
        if (this.field_70250_c instanceof EntityLivingBase && entity instanceof EntityLivingBase) {
            int i = EnchantmentHelper.func_77507_b((EntityLivingBase)((EntityLivingBase)this.field_70250_c), (EntityLivingBase)((EntityLivingBase)entity));
            if (i != 0) {
                entity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f));
            }
            if ((i = EnchantmentHelper.func_90036_a((EntityLivingBase)((EntityLivingBase)this.field_70250_c))) > 0 && !entity.func_70027_ad()) {
                entity.func_70015_d(1);
            }
        }
    }

    public void setThrownItemStack(ItemStack itemstack) {
        this.thrownItem = itemstack;
        this.updateWeaponMaterial();
    }

    @Override
    public ItemStack getPickupItem() {
        return this.thrownItem;
    }

    public int getWeaponMaterialId() {
        return this.field_70180_af.func_75683_a(25);
    }

    protected final void updateWeaponMaterial() {
        if (this.thrownItem != null && this.thrownItem.func_77973_b() instanceof IItemWeapon && ((IItemWeapon)this.thrownItem.func_77973_b()).getMeleeComponent() != null) {
            int material = MaterialRegistry.getMaterialID(this.thrownItem);
            if (material < 0) {
                material = ((IItemWeapon)this.thrownItem.func_77973_b()).getMeleeComponent().weaponMaterial.ordinal();
            }
            this.field_70180_af.func_75692_b(25, (Object)((byte)(material & 0xFF)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public final float[] getMaterialColor() {
        int id = this.getWeaponMaterialId();
        if (id < 5) {
            return MATERIAL_COLORS[id];
        }
        return MaterialRegistry.getColorFromMaterialID(id);
    }

    @Override
    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        if (this.thrownItem != null) {
            nbttagcompound.func_74782_a("thrI", (NBTBase)this.thrownItem.func_77955_b(new NBTTagCompound()));
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.setThrownItemStack(ItemStack.func_77949_a((NBTTagCompound)nbttagcompound.func_74775_l("thrI")));
    }
}

