/*
 * Decompiled with CFR 0.152.
 */
package need4speed402.mods.barrels.server;

import java.io.IOException;
import java.io.OutputStream;
import need4speed402.mods.barrels.Barrels;
import need4speed402.mods.barrels.server.packet.PacketBarrel;
import net.minecraft.world.storage.MapData;

public enum PacketType {
    REQUEST_ITEM(false, true){

        @Override
        public void serialize(OutputStream stream, PacketBarrel packet) throws IOException {
            Barrels.getPacketHandler().encodeRequestItem(stream, packet.getX(), packet.getY(), packet.getZ(), null, true);
        }
    }
    ,
    REQUEST_ITEM_PLAYER(false, true){

        @Override
        public void serialize(OutputStream stream, PacketBarrel packet) throws IOException {
            Barrels.getPacketHandler().encodeRequestItem(stream, packet.getX(), packet.getY(), packet.getZ(), packet.getPlayerSlots(), true);
        }
    }
    ,
    REQUEST_PLAYER(false, true){

        @Override
        public void serialize(OutputStream stream, PacketBarrel packet) throws IOException {
            Barrels.getPacketHandler().encodeRequestPlayerSlot(stream, packet.getPlayerSlots());
        }
    }
    ,
    REQUEST_MAP(false, true){

        @Override
        public void serialize(OutputStream stream, PacketBarrel packet) throws IOException {
            Barrels.getPacketHandler().encodeRequestMapData(stream, packet.getX(), packet.getY(), packet.getZ());
        }
    }
    ,
    ITEM(true, false){

        @Override
        public void serialize(OutputStream stream, PacketBarrel packet) throws IOException {
            Barrels.getPacketHandler().encode(stream, packet.getX(), packet.getY(), packet.getZ(), packet.getItem(), packet.getOrientation(), packet.getFramesAsBoolean(), false, null);
        }
    }
    ,
    ITEM_ALL(true, false){

        @Override
        public void serialize(OutputStream stream, PacketBarrel packet) throws IOException {
            Barrels.getPacketHandler().encode(stream, packet.getX(), packet.getY(), packet.getZ(), packet.getItem(), packet.getOrientation(), packet.getFramesAsBoolean(), true, null);
        }
    }
    ,
    ITEM_PLAYER(true, false){

        @Override
        public void serialize(OutputStream stream, PacketBarrel packet) throws IOException {
            Barrels.getPacketHandler().encode(stream, packet.getX(), packet.getY(), packet.getZ(), packet.getItem(), packet.getOrientation(), packet.getFramesAsBoolean(), false, packet.getPlayerSlots());
        }
    }
    ,
    ITEM_PLAYER_ALL(true, false){

        @Override
        public void serialize(OutputStream stream, PacketBarrel packet) throws IOException {
            Barrels.getPacketHandler().encode(stream, packet.getX(), packet.getY(), packet.getZ(), packet.getItem(), packet.getOrientation(), packet.getFramesAsBoolean(), true, packet.getPlayerSlots());
        }
    }
    ,
    PLAYER(true, false){

        @Override
        public void serialize(OutputStream stream, PacketBarrel packet) throws IOException {
            Barrels.getPacketHandler().encodePlayer(stream, packet.getPlayerSlots());
        }
    }
    ,
    METADATA(true, false){

        @Override
        public void serialize(OutputStream stream, PacketBarrel packet) throws IOException {
            Barrels.getPacketHandler().encodeMetadata(stream, packet.getX(), packet.getY(), packet.getZ(), packet.getBlockMetadata());
        }
    }
    ,
    FRAME(true, false){

        @Override
        public void serialize(OutputStream stream, PacketBarrel packet) throws IOException {
            Barrels.getPacketHandler().encodeFrames(stream, packet.getX(), packet.getY(), packet.getZ(), packet.getFramesAsBoolean());
        }
    }
    ,
    COUNT(true, false){

        @Override
        public void serialize(OutputStream stream, PacketBarrel packet) throws IOException {
            Barrels.getPacketHandler().encodeCount(stream, packet.getX(), packet.getY(), packet.getZ(), packet.getItem().field_77994_a);
        }
    }
    ,
    COUNT_PLAYER(true, false){

        @Override
        public void serialize(OutputStream stream, PacketBarrel packet) throws IOException {
            Barrels.getPacketHandler().encodeCount(stream, packet.getX(), packet.getY(), packet.getZ(), packet.getItem().field_77994_a, packet.getPlayerSlots());
        }
    }
    ,
    ORIENTATION(true, false){

        @Override
        public void serialize(OutputStream stream, PacketBarrel packet) throws IOException {
            Barrels.getPacketHandler().encodeOrientaion(stream, packet.getX(), packet.getY(), packet.getZ(), packet.getOrientation());
        }
    }
    ,
    MAP(true, false){

        @Override
        public void serialize(OutputStream stream, PacketBarrel packet) throws IOException {
            Barrels.getPacketHandler().encodeMapData(stream, packet.getX(), packet.getY(), packet.getZ(), (MapData)packet.getMap(), packet.getItemMapID());
        }
    };

    private boolean server;
    private boolean client;

    private PacketType(boolean client, boolean server) {
        this.client = client;
        this.server = server;
    }

    public boolean forClient() {
        return this.client;
    }

    public boolean forServer() {
        return this.server;
    }

    public abstract void serialize(OutputStream var1, PacketBarrel var2) throws IOException;
}

