/*
 * Decompiled with CFR 0.152.
 */
package com.rikmuld.camping.common.network.packets;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;

public abstract class PacketMain {
    public abstract void encodeInto(ChannelHandlerContext var1, ByteBuf var2);

    public abstract void decodeInto(ChannelHandlerContext var1, ByteBuf var2);

    public abstract void handleClientSide(EntityPlayer var1);

    public abstract void handleServerSide(EntityPlayer var1);

    public static ItemStack readItemStack(PacketBuffer stream) throws IOException {
        ItemStack itemstack = null;
        short id = stream.readShort();
        if (id >= 0) {
            byte stackSize = stream.readByte();
            short damage = stream.readShort();
            itemstack = new ItemStack(Item.func_150899_d((int)id), (int)stackSize, (int)damage);
            itemstack.field_77990_d = PacketMain.readNBTTagCompound(stream);
        }
        return itemstack;
    }

    public static NBTTagCompound readNBTTagCompound(PacketBuffer stream) throws IOException {
        short short1 = stream.readShort();
        if (short1 < 0) {
            return null;
        }
        byte[] abyte = new byte[short1];
        stream.readBytes(abyte);
        return CompressedStreamTools.func_74792_a((byte[])abyte);
    }

    public static void writeItemStack(ItemStack stack, PacketBuffer stream) throws IOException {
        if (stack == null) {
            stream.writeShort(-1);
        } else {
            stream.writeShort(Item.func_150891_b((Item)stack.func_77973_b()));
            stream.writeByte(stack.field_77994_a);
            stream.writeShort(stack.func_77960_j());
            NBTTagCompound nbttagcompound = null;
            if (stack.func_77973_b().func_77645_m() || stack.func_77973_b().func_77651_p()) {
                nbttagcompound = stack.field_77990_d;
            }
            PacketMain.writeNBTTagCompound(nbttagcompound, stream);
        }
    }

    protected static void writeNBTTagCompound(NBTTagCompound tag, PacketBuffer stream) throws IOException {
        if (tag == null) {
            stream.writeShort(-1);
        } else {
            byte[] abyte = CompressedStreamTools.func_74798_a((NBTTagCompound)tag);
            stream.writeShort((int)((short)abyte.length));
            stream.writeBytes(abyte);
        }
    }
}

