/*
 * Decompiled with CFR 0.152.
 */
package com.rikmuld.camping.common.network.packets;

import com.rikmuld.camping.common.network.packets.PacketMain;
import com.rikmuld.camping.common.obj.tiles.TileEntityMain;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.nio.ByteBuffer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;

public class PacketTileData
extends PacketMain {
    public int x;
    public int y;
    public int z;
    public int id;
    public int length;
    public byte[] data;

    public PacketTileData() {
    }

    public PacketTileData(int id, int x, int y, int z, int ... data) {
        this.id = id;
        this.x = x;
        this.y = y;
        this.z = z;
        this.length = data.length * 4;
        this.data = new byte[data.length * 4];
        for (int i = 0; i < data.length; ++i) {
            byte[] intData = ByteBuffer.allocate(4).putInt(data[i]).array();
            for (int o = 0; o < 4; ++o) {
                this.data[i * 4 + o] = intData[o];
            }
        }
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        PacketBuffer stream = new PacketBuffer(buffer);
        stream.writeInt(this.id);
        stream.writeInt(this.x);
        stream.writeInt(this.y);
        stream.writeInt(this.z);
        stream.writeInt(this.length);
        stream.writeBytes(this.data);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        PacketBuffer stream = new PacketBuffer(buffer);
        this.id = stream.readInt();
        this.x = stream.readInt();
        this.y = stream.readInt();
        this.z = stream.readInt();
        this.length = stream.readInt();
        this.data = new byte[this.length];
        stream.readBytes(this.data);
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        this.handlerBothSides(player);
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        this.handlerBothSides(player);
    }

    public void handlerBothSides(EntityPlayer player) {
        int[] intData = new int[this.length / 4];
        for (int i = 0; i < this.length / 4; ++i) {
            byte[] wrap = new byte[4];
            for (int o = i * 4; o < i * 4 + 4; ++o) {
                wrap[o - i * 4] = this.data[o];
            }
            intData[i] = ByteBuffer.wrap(wrap).getInt();
        }
        if (player.field_70170_p.func_147438_o(this.x, this.y, this.z) != null) {
            ((TileEntityMain)player.field_70170_p.func_147438_o(this.x, this.y, this.z)).setTileData(this.id, intData);
        }
    }
}

