/*
 * Decompiled with CFR 0.152.
 */
package com.rikmuld.camping.common.obj.tiles;

import com.rikmuld.camping.common.inventory.SlotCooking;
import com.rikmuld.camping.common.network.packets.PacketItems;
import com.rikmuld.camping.common.obj.tiles.TileEntityInventory;
import com.rikmuld.camping.core.registry.MiscRegistry;
import com.rikmuld.camping.core.registry.ObjRegistry;
import com.rikmuld.camping.core.util.ItemStackUtil;
import com.rikmuld.camping.misc.CookingEquipment;
import com.rikmuld.camping.misc.CookingEquipmentList;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;

public class TileEntityCampfireCook
extends TileEntityInventory {
    public int maxFeul = 20000;
    public int fuelForCoal = 1000;
    public int fuel;
    public float[][] coals = new float[3][20];
    Random rand = new Random();
    public int[] cookProgress = new int[10];
    public int[] oldCookProgress = new int[10];
    public CookingEquipment equipment;
    public ArrayList<SlotCooking> slots;
    private boolean active;
    private boolean oldActive;
    private int update;

    public TileEntityCampfireCook() {
        for (int i = 0; i < 20; ++i) {
            this.coals[0][i] = this.rand.nextFloat() / 5.0f;
            this.coals[1][i] = this.rand.nextFloat() / 5.0f;
            this.coals[2][i] = this.rand.nextFloat() * 360.0f;
        }
    }

    private void cookFood() {
        if (this.equipment != null) {
            for (int i = 0; i < this.equipment.maxFood; ++i) {
                this.oldCookProgress[i] = this.cookProgress[i];
                if (this.cookProgress[i] >= this.equipment.cookTime) {
                    this.cookProgress[i] = 0;
                    if (this.equipment.canCook(this.func_70301_a(i + 2))) {
                        if (this.equipment.getCookedFood(this.func_70301_a(i + 2)) != null) {
                            this.func_70299_a(i + 2, this.equipment.getCookedFood(this.func_70301_a(i + 2)).func_77946_l());
                        } else {
                            this.func_70299_a(i + 2, new ItemStack(ObjRegistry.parts, 1, 3));
                        }
                    } else {
                        this.func_70299_a(i + 2, new ItemStack(ObjRegistry.parts, 1, 3));
                    }
                    MiscRegistry.packetHandler.sendToAll(new PacketItems(i + 2, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_70301_a(i + 2)));
                }
                if (this.fuel > 0) {
                    if (!(this.func_70301_a(i + 2) == null || this.func_70301_a(i + 2).func_77973_b().equals(ObjRegistry.parts) && this.func_70301_a(i + 2).func_77960_j() == 3)) {
                        int n = i;
                        this.cookProgress[n] = this.cookProgress[n] + 1;
                    }
                } else if (this.cookProgress[i] > 0) {
                    this.cookProgress[i] = 0;
                }
                if (this.func_70301_a(i + 2) == null && this.cookProgress[i] > 0) {
                    this.cookProgress[i] = 0;
                }
                if (this.oldCookProgress[i] == this.cookProgress[i]) continue;
                this.sendTileData(1, true, this.cookProgress[i], i);
            }
        }
    }

    public int getCoalPieces() {
        return this.fuel > 0 ? (this.fuel / this.fuelForCoal + 1 <= 20 ? this.fuel / this.fuelForCoal + 1 : 20) : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72332_a().func_72299_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
    }

    public float getScaledCoal(int maxPixels) {
        return (float)this.fuel / (float)this.maxFeul * (float)maxPixels;
    }

    public float getScaledcookProgress(int maxPixels, int foodNum) {
        return ((float)this.cookProgress[foodNum] + 1.0f) / (float)this.equipment.cookTime * (float)maxPixels;
    }

    @Override
    public int func_70302_i_() {
        return 12;
    }

    public void manageCookingEquipment() {
        if (this.equipment == null && this.func_70301_a(1) != null) {
            this.equipment = CookingEquipmentList.getCooking(this.func_70301_a(1));
        } else if (this.equipment != null && this.func_70301_a(1) == null) {
            this.equipment = null;
        }
        if (this.slots != null) {
            int i;
            if (this.equipment != null) {
                for (i = 0; i < this.equipment.maxFood; ++i) {
                    if (this.slots.get((int)i).active) continue;
                    this.slots.get(i).activate(this.equipment.slots[0][i], this.equipment.slots[1][i], this.equipment, this);
                }
            }
            if (this.equipment == null) {
                for (i = 0; i < 10; ++i) {
                    if (!this.slots.get((int)i).active) continue;
                    this.slots.get(i).deActivate();
                    if (this.slots.get(i).func_75211_c() == null) continue;
                    ItemStackUtil.dropItemsInWorld(new ItemStack[]{this.slots.get(i).func_75211_c()}, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    this.slots.get(i).func_75215_d(null);
                }
            }
        }
    }

    public void manageFuel() {
        if (this.fuel > 0) {
            this.sendTileData(0, true, --this.fuel);
        }
        if (this.fuel + this.fuelForCoal <= this.maxFeul && this.func_70301_a(0) != null) {
            this.func_70298_a(0, 1);
            this.fuel += this.fuelForCoal;
        }
    }

    public void manageLight() {
        if (this.active != this.oldActive) {
            this.update = 5;
        }
        if (this.update > 0) {
            --this.update;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.fuel = tag.func_74762_e("fuel");
        this.cookProgress = tag.func_74759_k("cookProgress");
        for (int i = 0; i < this.coals.length; ++i) {
            for (int j = 0; j < this.coals[i].length; ++j) {
                this.coals[i][j] = tag.func_74760_g("coals" + i + j);
            }
        }
    }

    public void setSlots(ArrayList<SlotCooking> slots) {
        this.slots = slots;
    }

    @Override
    public void setTileData(int id, int[] data) {
        if (id == 0) {
            this.fuel = data[0];
        }
        if (id == 1) {
            this.cookProgress[data[1]] = data[0];
        }
    }

    public void func_145845_h() {
        this.manageCookingEquipment();
        if (!this.field_145850_b.field_72995_K) {
            this.active = this.fuel > 0;
            this.manageFuel();
            this.cookFood();
            this.manageLight();
            this.oldActive = this.active;
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74768_a("fuel", this.fuel);
        tag.func_74783_a("cookProgress", this.cookProgress);
        for (int i = 0; i < this.coals.length; ++i) {
            for (int j = 0; j < this.coals[i].length; ++j) {
                tag.func_74776_a("coals" + i + j, this.coals[i][j]);
            }
        }
    }
}

