/*
 * Decompiled with CFR 0.152.
 */
package com.rikmuld.camping.core.util;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ItemStackUtil {
    static Random rand = new Random();

    public static void addDamage(ItemStack item, EntityPlayer player, int damage) {
        ItemStack returnStack = new ItemStack(item.func_77973_b(), 1, item.func_77960_j() + damage);
        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, returnStack.func_77960_j() >= item.func_77958_k() ? null : returnStack);
    }

    public static ItemStack addDamage(ItemStack item, int damage) {
        ItemStack returnStack = new ItemStack(item.func_77973_b(), 1, item.func_77960_j() + damage);
        ItemStack returnStack2 = returnStack.func_77946_l();
        returnStack2.field_77994_a = 0;
        return returnStack.func_77960_j() >= item.func_77958_k() ? returnStack2 : returnStack;
    }

    public static boolean canMergePartStacks(ItemStack stack, ItemStack stack2) {
        if (stack.func_77973_b().equals(stack2.func_77973_b()) && stack.func_77960_j() == stack2.func_77960_j() && stack.field_77994_a < stack.func_77976_d() && stack.func_77942_o() == stack2.func_77942_o()) {
            if (stack.func_77942_o() && stack.func_77978_p().equals((Object)stack2.func_77978_p())) {
                return true;
            }
            if (!stack.func_77942_o()) {
                return true;
            }
        }
        return false;
    }

    public static void dropItemInWorld(ItemStack itemStack, World world, int x, int y, int z) {
        if (!world.field_72995_K && itemStack != null && itemStack.field_77994_a > 0) {
            float dX = rand.nextFloat() * 0.8f + 0.1f;
            float dY = rand.nextFloat() * 0.8f + 0.1f;
            float dZ = rand.nextFloat() * 0.8f + 0.1f;
            EntityItem entityItem = new EntityItem(world, (double)((float)x + dX), (double)((float)y + dY), (double)((float)z + dZ), new ItemStack(itemStack.func_77973_b(), itemStack.field_77994_a, itemStack.func_77960_j()));
            if (itemStack.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d((NBTTagCompound)itemStack.func_77978_p().func_74737_b());
            }
            float factor = 0.05f;
            entityItem.field_70159_w = rand.nextGaussian() * (double)factor;
            entityItem.field_70181_x = rand.nextGaussian() * (double)factor + (double)0.2f;
            entityItem.field_70179_y = rand.nextGaussian() * (double)factor;
            world.func_72838_d((Entity)entityItem);
            itemStack.field_77994_a = 0;
        }
    }

    public static void dropItemsInWorld(ArrayList<ItemStack> stacks, World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            for (int i = 0; i < stacks.size(); ++i) {
                ItemStack itemStack = stacks.get(i);
                ItemStackUtil.dropItemInWorld(itemStack, world, x, y, z);
            }
        }
    }

    public static void dropItemsInWorld(ItemStack[] stacks, World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            for (int i = 0; i < stacks.length; ++i) {
                ItemStack itemStack = stacks[i];
                ItemStackUtil.dropItemInWorld(itemStack, world, x, y, z);
            }
        }
    }

    public static ItemStack[] getMetaCycle(Object input, int maxMetadata) {
        ItemStack[] stack = new ItemStack[maxMetadata];
        for (int i = 0; i < maxMetadata; ++i) {
            if (input instanceof Block) {
                stack[i] = new ItemStack((Block)input, 1, i);
            }
            if (!(input instanceof Item)) continue;
            stack[i] = new ItemStack((Item)input, 1, i);
        }
        return stack;
    }

    public static ItemStack getWildValue(ItemStack input) {
        return new ItemStack(input.func_77973_b(), 1, Short.MAX_VALUE);
    }

    public static void setCurrentPlayerItem(EntityPlayer player, ItemStack stack) {
        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, stack);
    }

    public static ItemStack toStack(Object object) {
        ItemStack stack = null;
        if (object instanceof Block) {
            Block block = (Block)object;
            stack = new ItemStack(block);
        }
        if (object instanceof Item) {
            Item item = (Item)object;
            stack = new ItemStack(item);
        }
        if (object instanceof ItemStack) {
            stack = (ItemStack)object;
        }
        return stack;
    }
}

